<?php

if (!function_exists('copy_convert_utf')) {
    /**
     * Копирование файла с конвертацией в utf-8
     *
     * @param string $old
     * @param string $new
     * @return boolean
     * @throws \Exception
     */
    function copy_convert_utf($old, $new)
    {
        $content = file_get_contents($old);

        $fh = fopen($new, 'wb');
        if (!$fh) {
            throw new \RuntimeException('Ошибка при создании файла');
        }

        $content = utf16_to_utf8($content);

        fwrite($fh, $content);
        fclose($fh);

        return true;
    }
}
