<?php

namespace PriceReader\Readers;

use PriceReader\Data\PriceData;
use PriceReader\Exceptions\ParceError;
use SplFileInfo;
use XlsParser\SimpleXLSX;

/**
 * Description of CsvReader
 *
 * @author d.lanec
 */
class XlsxReader extends PriceReader
{
    protected $tmpdir;

    /**
     * XlsxReader constructor.
     *
     * @param SplFileInfo $file
     * @param string       $encoding
     * @param string       $tmpdir
     */
    public function __construct(SplFileInfo $file, $encoding, $tmpdir)
    {
        $this->tmpdir = $tmpdir;
        parent::__construct($file, $encoding);
    }

    /**
     * Получение данных из xlsx
     *
     * @param int $limitrows
     * @param int $sheet
     *
     * @return PriceData
     * @throws ParceError
     */
    public function getPriceData(int $limitrows = null, int $sheet = 0): PriceData
    {
        if (!($xlsx = SimpleXLSX::parse($this->file->getPathname()))) {
            throw new ParceError($this->file->getPathname());
        }

        $PriceData = new PriceData($this->file->getPathname(), $limitrows, $this->encoding);

        if (!$xlsx->sheetsCount()) {
            return $PriceData;
        }

        $PriceData->setSheets($xlsx->sheetNames());
        if (!$sheet) {
            $sheet = array_keys($PriceData->getSheets())[0];
        }

        $PriceData->addRows($xlsx->rows($sheet));

        return $PriceData;
    }
}
