<?php

namespace PriceReader\Readers;

use PriceReader\Data\PriceData;
use XlsParser\Spreadsheet_Excel_Reader;

/**
 * Description of CsvReader
 *
 * @author d.lanec
 */
class XlsReader extends PriceReader
{

    /**
     * Получение демо данных из xls
     *
     * @param int $limitrows
     * @param int $sheet
     *
     * @return PriceData
     */
    public function getPriceData(int $limitrows = null, int $sheet = 0): PriceData
    {
        $data = new Spreadsheet_Excel_Reader();

        $data->setRowColOffset(0);

        $data->setOutputEncoding($this->encoding !== 'auto' ? $this->encoding : 'cp1251');

        $data->read($this->file->getPathname());

        $PriceData = new PriceData($this->file->getPathname(), $limitrows, $this->encoding);

        $use_sheets = [];
        foreach ($data->boundsheets as $key => $sheetElem) {
            $use_sheets[$key] = iconv(
                ($this->encoding !== 'auto' ? $this->encoding : 'cp1251'),
                'utf-8',
                $sheetElem['name']
            );
        }
        $PriceData->setSheets($use_sheets);
        $PriceData->addRows($data->sheets[$sheet]['cells']);

        return $PriceData;
    }
}
