<?php

namespace PriceReader\Readers;

use \PriceReader\Data\PriceData;
use \SplFileInfo;

/**
 * Description of PriceReader
 *
 * @author d.lanec
 */
abstract class PriceReader
{

    /**
     * целевой файл
     * @var SplFileInfo
     */
    protected $file;

    /**
     * кодировка
     * @var string
     */
    protected $encoding;

    /**
     *
     * @param SplFileInfo $file
     * @param string       $encoding
     *
     * @internal param type $filename
     * @internal param type $numstr
     */
    public function __construct(SplFileInfo $file, string $encoding)
    {
        $this->file = $file;
        $this->encoding = $encoding;
    }

    /**
     * чтение данных
     * @param int|null $limitrows
     * @param int $sheet
     * @return PriceData
     */
    abstract public function getPriceData(int $limitrows = null, int $sheet = 0): PriceData;
}
