<?php

namespace PriceReader\Readers;

use PriceReader\Data\CsvPriceData;
use PriceReader\Data\PriceData;
use SplFileInfo;

/**
 * Description of CsvReader
 *
 * @author d.lanec
 */
class CsvReader extends PriceReader
{

    /**
     * @var string
     */
    protected $delimeter;

    protected $useSheets;/**
     * @return string
     */
    public function getDelimeter() : string
    {
        return $this->delimeter;
    }

    /**
     * @param string $delimeter
     * @return CsvReader
     */
    public function setDelimeter(string $delimeter): self
    {
        $this->delimeter = $delimeter;

        return $this;
    }

    /**
     * Получение демо данных из CSV
     *
     * @param int|null $limitrows
     * @param int $sheet
     * @return CsvPriceData|PriceData
     */
    public function getPriceData(int $limitrows = null, int $sheet = 0): PriceData
    {
        if (preg_match('~([a-z0-9]+\.)(\d+)\.([^.]+)\.csv~i', $this->file->getFilename(), $fileMatches)) {
            $this->getUseSheets();
            //Если пришедший лист не совпадает с используемым файлом, необходимо найти нужный лист
            if ((int)$fileMatches[2] !== $sheet) {
                $this->file = $this->getSheetFile($sheet);
            }
        }

        $PriceData = new CsvPriceData($this->file->getPathname(), $limitrows, $this->encoding);

        if ($this->delimeter) {
            $PriceData->setDelimiter($this->delimeter);
        }

        if ($this->useSheets) {
            $PriceData->setSheets($this->useSheets);
        }
        return $PriceData;
    }
    /**
         * @return array
         */
    protected function getUseSheets(): array
    {
        if ($this->useSheets) {
            return $this->useSheets;
        }

        preg_match('~([a-z0-9]+\.)(\d+)\.([^.]+)\.csv~i', $this->file->getFilename(), $fileMatches);
        foreach (new \DirectoryIterator($this->file->getPath()) as $fileInfo) {
            if (!$fileInfo->isFile() || $fileInfo->getExtension() !== 'csv') {
                continue;
            }
            if (preg_match('~([a-z0-9]+\.)(\d+)\.([^.]+)\.csv~i', $fileInfo->getFilename(), $sheetMatches)
                && $sheetMatches[1] === $fileMatches[1]
            ) {
                $this->useSheets[(int)$sheetMatches[2]] = $sheetMatches[3];
            }
        }
        ksort($this->useSheets);

        return $this->useSheets;
    }

    /**
     * @param int $sheet
     * @return SplFileInfo
     */
    public function getSheetFile(int $sheet): SplFileInfo
    {
        preg_match('~([a-z0-9]+\.)(\d+)\.([^.]+)\.csv~i', $this->file->getFilename(), $fileMatches);
        foreach (new \DirectoryIterator($this->file->getPath()) as $fileInfo) {
            if (!$fileInfo->isFile() || $fileInfo->getExtension() !== 'csv') {
                continue;
            }

            if (preg_match('~([a-z0-9]+\.)(\d+)\.([^.]+)\.csv~i', $fileInfo->getFilename(), $sheetMatches)
                && $sheetMatches[1] === $fileMatches[1]
                && (int)$sheetMatches[2] === $sheet
                && $sheetMatches[3] === $this->getUseSheets()[$sheet]
            ) {
                return $fileInfo;
            }
        }

        return $this->file;
    }
}
