# PartScannerClient\PriceListApi

All URIs are relative to *https://virtserver.swaggerhub.com/dimaxz/partscanner/1.0.0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**priceListsGet**](PriceListApi.md#pricelistsget) | **GET** /price-lists | получение прайс-листов
[**priceListsIdDelete**](PriceListApi.md#pricelistsiddelete) | **DELETE** /price-lists/{id} | удаление объекта
[**priceListsIdFileGet**](PriceListApi.md#pricelistsidfileget) | **GET** /price-lists/{id}/file | получение прайс-листа по id
[**priceListsIdFileRawsGet**](PriceListApi.md#pricelistsidfilerawsget) | **GET** /price-lists/{id}/file/raws | содержимое файла прайс-листа согласно разметке
[**priceListsIdGet**](PriceListApi.md#pricelistsidget) | **GET** /price-lists/{id} | получение прайс-листа по id
[**priceListsIdLogsGet**](PriceListApi.md#pricelistsidlogsget) | **GET** /price-lists/{id}/logs | отчет работы прайс-листа
[**priceListsIdPositionsGet**](PriceListApi.md#pricelistsidpositionsget) | **GET** /price-lists/{id}/positions | позиции прайс-листа
[**priceListsIdPositionsReloadPut**](PriceListApi.md#pricelistsidpositionsreloadput) | **PUT** /price-lists/{id}/positions/reload | задание на обновление позиций прайс-листа из файла
[**priceListsIdPut**](PriceListApi.md#pricelistsidput) | **PUT** /price-lists/{id} | обновление прайс-листа
[**priceListsPost**](PriceListApi.md#pricelistspost) | **POST** /price-lists | создание прайс-листа
[**priceListsPriceIdPositionsIdGet**](PriceListApi.md#pricelistspriceidpositionsidget) | **GET** /price-lists/{price_id}/positions/{id} | получение позиции прайс-листа по id

# **priceListsGet**
> \PartScannerClient\Model\InlineResponse20010 priceListsGet($limit, $page, $filter_by_id, $sort_by_id, $include, $filter_by_assortment_id)

получение прайс-листов

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы
$filter_by_id = 56; // int | фильтр по ключу
$sort_by_id = "sort_by_id_example"; // string | сортировка по ключу (asc,desc)
$include = "include_example"; // string | include=file
$filter_by_assortment_id = 56; // int | 

try {
    $result = $apiInstance->priceListsGet($limit, $page, $filter_by_id, $sort_by_id, $include, $filter_by_assortment_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| кол-во результатов | [optional]
 **page** | **int**| номер страницы | [optional]
 **filter_by_id** | **int**| фильтр по ключу | [optional]
 **sort_by_id** | **string**| сортировка по ключу (asc,desc) | [optional]
 **include** | **string**| include&#x3D;file | [optional]
 **filter_by_assortment_id** | **int**|  | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse20010**](../Model/InlineResponse20010.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **priceListsIdDelete**
> priceListsIdDelete($id)

удаление объекта

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 

try {
    $apiInstance->priceListsIdDelete($id);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **priceListsIdFileGet**
> \PartScannerClient\Model\InlineResponse20013 priceListsIdFileGet($id)

получение прайс-листа по id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 

try {
    $result = $apiInstance->priceListsIdFileGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsIdFileGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

[**\PartScannerClient\Model\InlineResponse20013**](../Model/InlineResponse20013.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **priceListsIdFileRawsGet**
> \PartScannerClient\Model\InlineResponse20014 priceListsIdFileRawsGet($id, $limit, $page, $filter_by_id, $sort_by_id)

содержимое файла прайс-листа согласно разметке

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы
$filter_by_id = 56; // int | фильтр по ключу
$sort_by_id = "sort_by_id_example"; // string | сортировка по ключу (asc,desc)

try {
    $result = $apiInstance->priceListsIdFileRawsGet($id, $limit, $page, $filter_by_id, $sort_by_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsIdFileRawsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |
 **limit** | **int**| кол-во результатов | [optional]
 **page** | **int**| номер страницы | [optional]
 **filter_by_id** | **int**| фильтр по ключу | [optional]
 **sort_by_id** | **string**| сортировка по ключу (asc,desc) | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse20014**](../Model/InlineResponse20014.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **priceListsIdGet**
> \PartScannerClient\Model\InlineResponse20011 priceListsIdGet($id, $include)

получение прайс-листа по id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 
$include = "include_example"; // string | include=file

try {
    $result = $apiInstance->priceListsIdGet($id, $include);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |
 **include** | **string**| include&#x3D;file | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse20011**](../Model/InlineResponse20011.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **priceListsIdLogsGet**
> \PartScannerClient\Model\InlineResponse20012 priceListsIdLogsGet($id, $limit, $page, $filter_by_id, $sort_by_id)

отчет работы прайс-листа

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы
$filter_by_id = 56; // int | фильтр по ключу
$sort_by_id = "sort_by_id_example"; // string | сортировка по ключу (asc,desc)

try {
    $result = $apiInstance->priceListsIdLogsGet($id, $limit, $page, $filter_by_id, $sort_by_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsIdLogsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |
 **limit** | **int**| кол-во результатов | [optional]
 **page** | **int**| номер страницы | [optional]
 **filter_by_id** | **int**| фильтр по ключу | [optional]
 **sort_by_id** | **string**| сортировка по ключу (asc,desc) | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse20012**](../Model/InlineResponse20012.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **priceListsIdPositionsGet**
> \PartScannerClient\Model\InlineResponse2002 priceListsIdPositionsGet($id, $limit, $page, $filter_by_id, $sort_by_id)

позиции прайс-листа

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы
$filter_by_id = 56; // int | фильтр по ключу
$sort_by_id = "sort_by_id_example"; // string | сортировка по ключу (asc,desc)

try {
    $result = $apiInstance->priceListsIdPositionsGet($id, $limit, $page, $filter_by_id, $sort_by_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsIdPositionsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |
 **limit** | **int**| кол-во результатов | [optional]
 **page** | **int**| номер страницы | [optional]
 **filter_by_id** | **int**| фильтр по ключу | [optional]
 **sort_by_id** | **string**| сортировка по ключу (asc,desc) | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse2002**](../Model/InlineResponse2002.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **priceListsIdPositionsReloadPut**
> priceListsIdPositionsReloadPut($id)

задание на обновление позиций прайс-листа из файла

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 

try {
    $apiInstance->priceListsIdPositionsReloadPut($id);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsIdPositionsReloadPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **priceListsIdPut**
> priceListsIdPut($body, $id)

обновление прайс-листа

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\PriceListRequest(); // \PartScannerClient\Model\PriceListRequest | 
$id = 56; // int | 

try {
    $apiInstance->priceListsIdPut($body, $id);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsIdPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\PriceListRequest**](../Model/PriceListRequest.md)|  |
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **priceListsPost**
> \PartScannerClient\Model\SuccessCreateResponse priceListsPost($body)

создание прайс-листа

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\PriceListRequest(); // \PartScannerClient\Model\PriceListRequest | 

try {
    $result = $apiInstance->priceListsPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\PriceListRequest**](../Model/PriceListRequest.md)|  |

### Return type

[**\PartScannerClient\Model\SuccessCreateResponse**](../Model/SuccessCreateResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **priceListsPriceIdPositionsIdGet**
> \PartScannerClient\Model\InlineResponse2003 priceListsPriceIdPositionsIdGet($price_id, $id)

получение позиции прайс-листа по id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\PriceListApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$price_id = 56; // int | 
$id = 56; // int | 

try {
    $result = $apiInstance->priceListsPriceIdPositionsIdGet($price_id, $id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceListApi->priceListsPriceIdPositionsIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **price_id** | **int**|  |
 **id** | **int**|  |

### Return type

[**\PartScannerClient\Model\InlineResponse2003**](../Model/InlineResponse2003.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

