# PartScannerClient\CurrencyApi

All URIs are relative to *https://virtserver.swaggerhub.com/dimaxz/partscanner/1.0.0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**currenciesGet**](CurrencyApi.md#currenciesget) | **GET** /currencies | получение валют
[**currenciesIdGet**](CurrencyApi.md#currenciesidget) | **GET** /currencies/{id} | получение валюты по id

# **currenciesGet**
> \PartScannerClient\Model\InlineResponse2002 currenciesGet($limit, $page, $filter_by_id, $sort_by_id)

получение валют

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\CurrencyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы
$filter_by_id = 56; // int | фильтр по ключу
$sort_by_id = "sort_by_id_example"; // string | сортировка по ключу (asc,desc)

try {
    $result = $apiInstance->currenciesGet($limit, $page, $filter_by_id, $sort_by_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CurrencyApi->currenciesGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| кол-во результатов | [optional]
 **page** | **int**| номер страницы | [optional]
 **filter_by_id** | **int**| фильтр по ключу | [optional]
 **sort_by_id** | **string**| сортировка по ключу (asc,desc) | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse2002**](../Model/InlineResponse2002.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **currenciesIdGet**
> \PartScannerClient\Model\InlineResponse2003 currenciesIdGet($id)

получение валюты по id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\CurrencyApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 

try {
    $result = $apiInstance->currenciesIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CurrencyApi->currenciesIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

[**\PartScannerClient\Model\InlineResponse2003**](../Model/InlineResponse2003.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

