# PartScannerClient\ProviderApi

All URIs are relative to *https://virtserver.swaggerhub.com/dimaxz/partscanner/1.0.0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**providersGet**](ProviderApi.md#providersget) | **GET** /providers | получение поставщиков
[**providersIdDelete**](ProviderApi.md#providersiddelete) | **DELETE** /providers/{id} | удаление объекта
[**providersIdGet**](ProviderApi.md#providersidget) | **GET** /providers/{id} | получение поставщика по id
[**providersIdPut**](ProviderApi.md#providersidput) | **PUT** /providers/{id} | обновление поставщика
[**providersPost**](ProviderApi.md#providerspost) | **POST** /providers | создание поставщика

# **providersGet**
> \PartScannerClient\Model\InlineResponse2006 providersGet($limit, $page, $filter_by_id, $sort_by_id, $filter_by_name)

получение поставщиков

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\ProviderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы
$filter_by_id = 56; // int | фильтр по ключу
$sort_by_id = "sort_by_id_example"; // string | сортировка по ключу (asc,desc)
$filter_by_name = "filter_by_name_example"; // string | фильтрация по имени

try {
    $result = $apiInstance->providersGet($limit, $page, $filter_by_id, $sort_by_id, $filter_by_name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProviderApi->providersGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| кол-во результатов | [optional]
 **page** | **int**| номер страницы | [optional]
 **filter_by_id** | **int**| фильтр по ключу | [optional]
 **sort_by_id** | **string**| сортировка по ключу (asc,desc) | [optional]
 **filter_by_name** | **string**| фильтрация по имени | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse2006**](../Model/InlineResponse2006.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **providersIdDelete**
> providersIdDelete($id)

удаление объекта

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\ProviderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 

try {
    $apiInstance->providersIdDelete($id);
} catch (Exception $e) {
    echo 'Exception when calling ProviderApi->providersIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **providersIdGet**
> \PartScannerClient\Model\InlineResponse2007 providersIdGet($id)

получение поставщика по id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\ProviderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 56; // int | 

try {
    $result = $apiInstance->providersIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProviderApi->providersIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

[**\PartScannerClient\Model\InlineResponse2007**](../Model/InlineResponse2007.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **providersIdPut**
> providersIdPut($body, $id)

обновление поставщика

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\ProviderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\ProviderRequest(); // \PartScannerClient\Model\ProviderRequest | 
$id = 56; // int | 

try {
    $apiInstance->providersIdPut($body, $id);
} catch (Exception $e) {
    echo 'Exception when calling ProviderApi->providersIdPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\ProviderRequest**](../Model/ProviderRequest.md)|  |
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **providersPost**
> \PartScannerClient\Model\SuccessCreateResponse providersPost($body)

создание поставщика

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\ProviderApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\ProviderRequest(); // \PartScannerClient\Model\ProviderRequest | 

try {
    $result = $apiInstance->providersPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProviderApi->providersPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\ProviderRequest**](../Model/ProviderRequest.md)|  |

### Return type

[**\PartScannerClient\Model\SuccessCreateResponse**](../Model/SuccessCreateResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

