# PartScannerClient\FtpConfigApi

All URIs are relative to *https://partscanner.ru/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**ftpConfigsGet**](FtpConfigApi.md#ftpconfigsget) | **GET** /ftp-configs | список настроек ftp серверов
[**ftpConfigsIdDelete**](FtpConfigApi.md#ftpconfigsiddelete) | **DELETE** /ftp-configs/{id} | удаление настройки
[**ftpConfigsIdGet**](FtpConfigApi.md#ftpconfigsidget) | **GET** /ftp-configs/{id} | настройка ftp сервера по id
[**ftpConfigsIdPut**](FtpConfigApi.md#ftpconfigsidput) | **PUT** /ftp-configs/{id} | обновление настройки
[**ftpConfigsPost**](FtpConfigApi.md#ftpconfigspost) | **POST** /ftp-configs | создание настроек ftp сервера

# **ftpConfigsGet**
> \PartScannerClient\Model\InlineResponse20017 ftpConfigsGet()

список настроек ftp серверов

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\FtpConfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->ftpConfigsGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FtpConfigApi->ftpConfigsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PartScannerClient\Model\InlineResponse20017**](../Model/InlineResponse20017.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **ftpConfigsIdDelete**
> ftpConfigsIdDelete($id)

удаление настройки

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\FtpConfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | 

try {
    $apiInstance->ftpConfigsIdDelete($id);
} catch (Exception $e) {
    echo 'Exception when calling FtpConfigApi->ftpConfigsIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **ftpConfigsIdGet**
> \PartScannerClient\Model\InlineResponse20018 ftpConfigsIdGet($id)

настройка ftp сервера по id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\FtpConfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | 

try {
    $result = $apiInstance->ftpConfigsIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FtpConfigApi->ftpConfigsIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

[**\PartScannerClient\Model\InlineResponse20018**](../Model/InlineResponse20018.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **ftpConfigsIdPut**
> ftpConfigsIdPut($body, $id)

обновление настройки

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\FtpConfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \PartScannerClient\Model\FtpConfigRequest(); // \PartScannerClient\Model\FtpConfigRequest | 
$id = 56; // int | 

try {
    $apiInstance->ftpConfigsIdPut($body, $id);
} catch (Exception $e) {
    echo 'Exception when calling FtpConfigApi->ftpConfigsIdPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\FtpConfigRequest**](../Model/FtpConfigRequest.md)|  |
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **ftpConfigsPost**
> \PartScannerClient\Model\SuccessCreateResponse ftpConfigsPost($body)

создание настроек ftp сервера

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\FtpConfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \PartScannerClient\Model\FtpConfigRequest(); // \PartScannerClient\Model\FtpConfigRequest | 

try {
    $result = $apiInstance->ftpConfigsPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FtpConfigApi->ftpConfigsPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\FtpConfigRequest**](../Model/FtpConfigRequest.md)|  |

### Return type

[**\PartScannerClient\Model\SuccessCreateResponse**](../Model/SuccessCreateResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

