# PartScannerClient\AssortmentApi

All URIs are relative to *https://partscanner.ru/v1*

Method | HTTP request | Description
------------- | ------------- | -------------
[**assortmentsGet**](AssortmentApi.md#assortmentsget) | **GET** /assortments | поиск ассортимента
[**assortmentsIdDelete**](AssortmentApi.md#assortmentsiddelete) | **DELETE** /assortments/{id} | удаление ассортимента
[**assortmentsIdGet**](AssortmentApi.md#assortmentsidget) | **GET** /assortments/{id} | получение ассортимента по id
[**assortmentsIdPut**](AssortmentApi.md#assortmentsidput) | **PUT** /assortments/{id} | обновление ассортимента
[**assortmentsPost**](AssortmentApi.md#assortmentspost) | **POST** /assortments | создание ассортимента

# **assortmentsGet**
> \PartScannerClient\Model\InlineResponse200 assortmentsGet($limit, $page, $filter_by_id, $sort_by_id, $include)

поиск ассортимента

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\AssortmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы
$filter_by_id = 56; // int | фильтр по ключу
$sort_by_id = "sort_by_id_example"; // string | сортировка по ключу (asc,desc)
$include = "include_example"; // string | include=pricelists

try {
    $result = $apiInstance->assortmentsGet($limit, $page, $filter_by_id, $sort_by_id, $include);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssortmentApi->assortmentsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| кол-во результатов | [optional]
 **page** | **int**| номер страницы | [optional]
 **filter_by_id** | **int**| фильтр по ключу | [optional]
 **sort_by_id** | **string**| сортировка по ключу (asc,desc) | [optional]
 **include** | **string**| include&#x3D;pricelists | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse200**](../Model/InlineResponse200.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **assortmentsIdDelete**
> assortmentsIdDelete($id)

удаление ассортимента

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\AssortmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | 

try {
    $apiInstance->assortmentsIdDelete($id);
} catch (Exception $e) {
    echo 'Exception when calling AssortmentApi->assortmentsIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **assortmentsIdGet**
> \PartScannerClient\Model\InlineResponse2001 assortmentsIdGet($id, $include)

получение ассортимента по id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\AssortmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | 
$include = "include_example"; // string | include=pricelists

try {
    $result = $apiInstance->assortmentsIdGet($id, $include);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssortmentApi->assortmentsIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |
 **include** | **string**| include&#x3D;pricelists | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse2001**](../Model/InlineResponse2001.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **assortmentsIdPut**
> assortmentsIdPut($body, $id)

обновление ассортимента

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\AssortmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \PartScannerClient\Model\AssortmentRequest(); // \PartScannerClient\Model\AssortmentRequest | 
$id = 56; // int | 

try {
    $apiInstance->assortmentsIdPut($body, $id);
} catch (Exception $e) {
    echo 'Exception when calling AssortmentApi->assortmentsIdPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\AssortmentRequest**](../Model/AssortmentRequest.md)|  |
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **assortmentsPost**
> \PartScannerClient\Model\SuccessCreateResponse assortmentsPost($body)

создание ассортимента

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\AssortmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \PartScannerClient\Model\AssortmentRequest(); // \PartScannerClient\Model\AssortmentRequest | 

try {
    $result = $apiInstance->assortmentsPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssortmentApi->assortmentsPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\AssortmentRequest**](../Model/AssortmentRequest.md)|  |

### Return type

[**\PartScannerClient\Model\SuccessCreateResponse**](../Model/SuccessCreateResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

