# PartScannerClient\FileApi

All URIs are relative to *https://virtserver.swaggerhub.com/dimaxz/partscanner/1.0.0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**filesEmailConnectPost**](FileApi.md#filesemailconnectpost) | **POST** /files/email/connect | проверка коннекта к почте
[**filesEmailLoadPost**](FileApi.md#filesemailloadpost) | **POST** /files/email/load | задание на загрузку файла с почты
[**filesFtpConnectPost**](FileApi.md#filesftpconnectpost) | **POST** /files/ftp/connect | тест подключения к ftp
[**filesFtpLoadPost**](FileApi.md#filesftploadpost) | **POST** /files/ftp/load | задание на скачу файла с ftp
[**filesGet**](FileApi.md#filesget) | **GET** /files | список файлов скаченных с источника
[**filesHashGet**](FileApi.md#fileshashget) | **GET** /files/{hash} | тип загрузки файла ассортимента
[**filesHashRawsGet**](FileApi.md#fileshashrawsget) | **GET** /files/{hash}/raws | предпросмотр содержимого загруженного файла
[**filesHashSourceGet**](FileApi.md#fileshashsourceget) | **GET** /files/{hash}/source | вывод содержимого файла как есть
[**filesHashStatusGet**](FileApi.md#fileshashstatusget) | **GET** /files/{hash}/status | состояние загрузки файла
[**filesLinkLoadPost**](FileApi.md#fileslinkloadpost) | **POST** /files/link/load | задание на скачу файла по ссылке
[**filesMoyskladConnectPost**](FileApi.md#filesmoyskladconnectpost) | **POST** /files/moysklad/connect | проверка коннекта к moysklad
[**filesMoyskladLoadPost**](FileApi.md#filesmoyskladloadpost) | **POST** /files/moysklad/load | задание на загрузку файла с почты

# **filesEmailConnectPost**
> \PartScannerClient\Model\ModelSuccess filesEmailConnectPost($body)

проверка коннекта к почте

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\MailConnectRequest(); // \PartScannerClient\Model\MailConnectRequest | 

try {
    $result = $apiInstance->filesEmailConnectPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesEmailConnectPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\MailConnectRequest**](../Model/MailConnectRequest.md)|  |

### Return type

[**\PartScannerClient\Model\ModelSuccess**](../Model/ModelSuccess.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesEmailLoadPost**
> \PartScannerClient\Model\SuccessCreateResponse filesEmailLoadPost($body)

задание на загрузку файла с почты

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\MailLoadRequest(); // \PartScannerClient\Model\MailLoadRequest | 

try {
    $result = $apiInstance->filesEmailLoadPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesEmailLoadPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\MailLoadRequest**](../Model/MailLoadRequest.md)|  |

### Return type

[**\PartScannerClient\Model\SuccessCreateResponse**](../Model/SuccessCreateResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesFtpConnectPost**
> \PartScannerClient\Model\ModelSuccess filesFtpConnectPost($body)

тест подключения к ftp

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\FtpConnectRequest(); // \PartScannerClient\Model\FtpConnectRequest | 

try {
    $result = $apiInstance->filesFtpConnectPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesFtpConnectPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\FtpConnectRequest**](../Model/FtpConnectRequest.md)|  |

### Return type

[**\PartScannerClient\Model\ModelSuccess**](../Model/ModelSuccess.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesFtpLoadPost**
> \PartScannerClient\Model\FileLoadingCreate filesFtpLoadPost($body)

задание на скачу файла с ftp

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\FtpLoadRequest(); // \PartScannerClient\Model\FtpLoadRequest | 

try {
    $result = $apiInstance->filesFtpLoadPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesFtpLoadPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\FtpLoadRequest**](../Model/FtpLoadRequest.md)|  |

### Return type

[**\PartScannerClient\Model\FileLoadingCreate**](../Model/FileLoadingCreate.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesGet**
> \PartScannerClient\Model\InlineResponse20023 filesGet($filter_by_hash, $limit, $page)

список файлов скаченных с источника

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$filter_by_hash = "filter_by_hash_example"; // string | фильтрация по hash
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы

try {
    $result = $apiInstance->filesGet($filter_by_hash, $limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **filter_by_hash** | **string**| фильтрация по hash | [optional]
 **limit** | **int**| кол-во результатов | [optional]
 **page** | **int**| номер страницы | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse20023**](../Model/InlineResponse20023.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesHashGet**
> \PartScannerClient\Model\InlineResponse20024 filesHashGet($hash)

тип загрузки файла ассортимента

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$hash = "hash_example"; // string | 

try {
    $result = $apiInstance->filesHashGet($hash);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesHashGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **hash** | **string**|  |

### Return type

[**\PartScannerClient\Model\InlineResponse20024**](../Model/InlineResponse20024.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesHashRawsGet**
> \PartScannerClient\Model\InlineResponse20014 filesHashRawsGet($hash, $limit, $page)

предпросмотр содержимого загруженного файла

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$hash = "hash_example"; // string | 
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы

try {
    $result = $apiInstance->filesHashRawsGet($hash, $limit, $page);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesHashRawsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **hash** | **string**|  |
 **limit** | **int**| кол-во результатов | [optional]
 **page** | **int**| номер страницы | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse20014**](../Model/InlineResponse20014.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesHashSourceGet**
> string filesHashSourceGet($hash)

вывод содержимого файла как есть

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$hash = "hash_example"; // string | 

try {
    $result = $apiInstance->filesHashSourceGet($hash);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesHashSourceGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **hash** | **string**|  |

### Return type

**string**

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/octet-stream

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesHashStatusGet**
> \PartScannerClient\Model\InlineResponse20025 filesHashStatusGet($hash)

состояние загрузки файла

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$hash = "hash_example"; // string | 

try {
    $result = $apiInstance->filesHashStatusGet($hash);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesHashStatusGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **hash** | **string**|  |

### Return type

[**\PartScannerClient\Model\InlineResponse20025**](../Model/InlineResponse20025.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesLinkLoadPost**
> \PartScannerClient\Model\FileLoadingCreate filesLinkLoadPost($body)

задание на скачу файла по ссылке

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\LinkLoadRequest(); // \PartScannerClient\Model\LinkLoadRequest | 

try {
    $result = $apiInstance->filesLinkLoadPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesLinkLoadPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\LinkLoadRequest**](../Model/LinkLoadRequest.md)|  |

### Return type

[**\PartScannerClient\Model\FileLoadingCreate**](../Model/FileLoadingCreate.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesMoyskladConnectPost**
> \PartScannerClient\Model\MoySkladModelSuccess filesMoyskladConnectPost($body)

проверка коннекта к moysklad

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\MySkladConnectRequest(); // \PartScannerClient\Model\MySkladConnectRequest | 

try {
    $result = $apiInstance->filesMoyskladConnectPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesMoyskladConnectPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\MySkladConnectRequest**](../Model/MySkladConnectRequest.md)|  |

### Return type

[**\PartScannerClient\Model\MoySkladModelSuccess**](../Model/MoySkladModelSuccess.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **filesMoyskladLoadPost**
> \PartScannerClient\Model\SuccessCreateResponse filesMoyskladLoadPost($body)

задание на загрузку файла с почты

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');
// Configure API key authorization: ApiKeyAuth
$config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKey('X-API-KEY', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = PartScannerClient\Configuration::getDefaultConfiguration()->setApiKeyPrefix('X-API-KEY', 'Bearer');

$apiInstance = new PartScannerClient\Api\FileApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \PartScannerClient\Model\MoySkladLoadRequest(); // \PartScannerClient\Model\MoySkladLoadRequest | 

try {
    $result = $apiInstance->filesMoyskladLoadPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FileApi->filesMoyskladLoadPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\MoySkladLoadRequest**](../Model/MoySkladLoadRequest.md)|  |

### Return type

[**\PartScannerClient\Model\SuccessCreateResponse**](../Model/SuccessCreateResponse.md)

### Authorization

[ApiKeyAuth](../../README.md#ApiKeyAuth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

