# PartScannerClient\ProjectApi

All URIs are relative to *https://virtserver.swaggerhub.com/dimaxz/partscanner/1.0.0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**projectsGet**](ProjectApi.md#projectsget) | **GET** /projects | получение проектов
[**projectsIdDelete**](ProjectApi.md#projectsiddelete) | **DELETE** /projects/{id} | удаление проекта
[**projectsIdGet**](ProjectApi.md#projectsidget) | **GET** /projects/{id} | получение проекта по id
[**projectsIdPut**](ProjectApi.md#projectsidput) | **PUT** /projects/{id} | обновление проекта
[**projectsPost**](ProjectApi.md#projectspost) | **POST** /projects | создание проекта

# **projectsGet**
> \PartScannerClient\Model\InlineResponse2004 projectsGet($limit, $page, $filter_by_id, $sort_by_id)

получение проектов

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\ProjectApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы
$filter_by_id = 56; // int | фильтр по ключу
$sort_by_id = "sort_by_id_example"; // string | сортировка по ключу (asc,desc)

try {
    $result = $apiInstance->projectsGet($limit, $page, $filter_by_id, $sort_by_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->projectsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| кол-во результатов | [optional]
 **page** | **int**| номер страницы | [optional]
 **filter_by_id** | **int**| фильтр по ключу | [optional]
 **sort_by_id** | **string**| сортировка по ключу (asc,desc) | [optional]

### Return type

[**\PartScannerClient\Model\InlineResponse2004**](../Model/InlineResponse2004.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **projectsIdDelete**
> projectsIdDelete($id)

удаление проекта

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\ProjectApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | 

try {
    $apiInstance->projectsIdDelete($id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->projectsIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **projectsIdGet**
> \PartScannerClient\Model\InlineResponse2005 projectsIdGet($id)

получение проекта по id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\ProjectApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | 

try {
    $result = $apiInstance->projectsIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->projectsIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

[**\PartScannerClient\Model\InlineResponse2005**](../Model/InlineResponse2005.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **projectsIdPut**
> projectsIdPut($body, $id)

обновление проекта

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\ProjectApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \PartScannerClient\Model\ProjectRequest(); // \PartScannerClient\Model\ProjectRequest | 
$id = 56; // int | 

try {
    $apiInstance->projectsIdPut($body, $id);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->projectsIdPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\ProjectRequest**](../Model/ProjectRequest.md)|  |
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **projectsPost**
> \PartScannerClient\Model\SuccessCreateResponse projectsPost($body)

создание проекта

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\ProjectApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \PartScannerClient\Model\ProjectRequest(); // \PartScannerClient\Model\ProjectRequest | 

try {
    $result = $apiInstance->projectsPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProjectApi->projectsPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\ProjectRequest**](../Model/ProjectRequest.md)|  |

### Return type

[**\PartScannerClient\Model\SuccessCreateResponse**](../Model/SuccessCreateResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

