# PartScannerClient\MailConfigApi

All URIs are relative to *https://virtserver.swaggerhub.com/dimaxz/partscanner/1.0.0*

Method | HTTP request | Description
------------- | ------------- | -------------
[**mailConfigsGet**](MailConfigApi.md#mailconfigsget) | **GET** /mail-configs | список настроек почтовых серверов
[**mailConfigsIdDelete**](MailConfigApi.md#mailconfigsiddelete) | **DELETE** /mail-configs/{id} | удаление настройки
[**mailConfigsIdGet**](MailConfigApi.md#mailconfigsidget) | **GET** /mail-configs/{id} | настройка почтового сервера по id
[**mailConfigsIdPut**](MailConfigApi.md#mailconfigsidput) | **PUT** /mail-configs/{id} | обновление настройки
[**mailConfigsPost**](MailConfigApi.md#mailconfigspost) | **POST** /mail-configs | создание настройки почтового сервера

# **mailConfigsGet**
> \PartScannerClient\Model\InlineResponse20014 mailConfigsGet()

список настроек почтовых серверов

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\MailConfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);

try {
    $result = $apiInstance->mailConfigsGet();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MailConfigApi->mailConfigsGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PartScannerClient\Model\InlineResponse20014**](../Model/InlineResponse20014.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **mailConfigsIdDelete**
> mailConfigsIdDelete($id)

удаление настройки

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\MailConfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | 

try {
    $apiInstance->mailConfigsIdDelete($id);
} catch (Exception $e) {
    echo 'Exception when calling MailConfigApi->mailConfigsIdDelete: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **mailConfigsIdGet**
> \PartScannerClient\Model\InlineResponse20015 mailConfigsIdGet($id)

настройка почтового сервера по id

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\MailConfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | 

try {
    $result = $apiInstance->mailConfigsIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MailConfigApi->mailConfigsIdGet: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **int**|  |

### Return type

[**\PartScannerClient\Model\InlineResponse20015**](../Model/InlineResponse20015.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **mailConfigsIdPut**
> mailConfigsIdPut($body, $id)

обновление настройки

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\MailConfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \PartScannerClient\Model\MailConfigRequest(); // \PartScannerClient\Model\MailConfigRequest | 
$id = 56; // int | 

try {
    $apiInstance->mailConfigsIdPut($body, $id);
} catch (Exception $e) {
    echo 'Exception when calling MailConfigApi->mailConfigsIdPut: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\MailConfigRequest**](../Model/MailConfigRequest.md)|  |
 **id** | **int**|  |

### Return type

void (empty response body)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **mailConfigsPost**
> \PartScannerClient\Model\SuccessCreateResponse mailConfigsPost($body)

создание настройки почтового сервера

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\MailConfigApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \PartScannerClient\Model\MailConfigRequest(); // \PartScannerClient\Model\MailConfigRequest | 

try {
    $result = $apiInstance->mailConfigsPost($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling MailConfigApi->mailConfigsPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PartScannerClient\Model\MailConfigRequest**](../Model/MailConfigRequest.md)|  |

### Return type

[**\PartScannerClient\Model\SuccessCreateResponse**](../Model/SuccessCreateResponse.md)

### Authorization

No authorization required

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

