# SwaggerClient-php
This is a partscanner API

This PHP package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.php.PhpClientCodegen

## Requirements

PHP 5.5 and later

## Installation & Usage
### Composer

To install the bindings via [Composer](http://getcomposer.org/), add the following to `composer.json`:

```
{
  "repositories": [
    {
      "type": "git",
      "url": "https://github.com/libraries/partscanner-client.git"
    }
  ],
  "require": {
    "libraries/partscanner-client": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
    require_once('/path/to/SwaggerClient-php/vendor/autoload.php');
```

## Tests

To run the unit tests:

```
composer install
./vendor/bin/phpunit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

$apiInstance = new PartScannerClient\Api\AssortmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$limit = 56; // int | кол-во результатов
$page = 56; // int | номер страницы
$filter_by_id = 56; // int | фильтр по ключу
$sort_by_id = "sort_by_id_example"; // string | сортировка по ключу (asc,desc)

try {
    $result = $apiInstance->assortmentsGet($limit, $page, $filter_by_id, $sort_by_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssortmentApi->assortmentsGet: ', $e->getMessage(), PHP_EOL;
}

$apiInstance = new PartScannerClient\Api\AssortmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | 

try {
    $apiInstance->assortmentsIdDelete($id);
} catch (Exception $e) {
    echo 'Exception when calling AssortmentApi->assortmentsIdDelete: ', $e->getMessage(), PHP_EOL;
}

$apiInstance = new PartScannerClient\Api\AssortmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$id = 56; // int | 

try {
    $result = $apiInstance->assortmentsIdGet($id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AssortmentApi->assortmentsIdGet: ', $e->getMessage(), PHP_EOL;
}

$apiInstance = new PartScannerClient\Api\AssortmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \PartScannerClient\Model\AssortmentRequest(); // \PartScannerClient\Model\AssortmentRequest | 
$id = 56; // int | 

try {
    $apiInstance->assortmentsIdPut($body, $id);
} catch (Exception $e) {
    echo 'Exception when calling AssortmentApi->assortmentsIdPut: ', $e->getMessage(), PHP_EOL;
}

$apiInstance = new PartScannerClient\Api\AssortmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client()
);
$body = new \PartScannerClient\Model\AssortmentRequest(); // \PartScannerClient\Model\AssortmentRequest | 

try {
    $apiInstance->assortmentsPost($body);
} catch (Exception $e) {
    echo 'Exception when calling AssortmentApi->assortmentsPost: ', $e->getMessage(), PHP_EOL;
}
?>
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AssortmentApi* | [**assortmentsGet**](docs/Api/AssortmentApi.md#assortmentsget) | **GET** /assortments | поиск ассортимента
*AssortmentApi* | [**assortmentsIdDelete**](docs/Api/AssortmentApi.md#assortmentsiddelete) | **DELETE** /assortments/{id} | удаление ассортимента
*AssortmentApi* | [**assortmentsIdGet**](docs/Api/AssortmentApi.md#assortmentsidget) | **GET** /assortments/{id} | получение ассортимента по id
*AssortmentApi* | [**assortmentsIdPut**](docs/Api/AssortmentApi.md#assortmentsidput) | **PUT** /assortments/{id} | обновление ассортимента
*AssortmentApi* | [**assortmentsPost**](docs/Api/AssortmentApi.md#assortmentspost) | **POST** /assortments | создание ассортимента
*CurrencyApi* | [**currenciesGet**](docs/Api/CurrencyApi.md#currenciesget) | **GET** /currencies | получение валют
*CurrencyApi* | [**currenciesIdGet**](docs/Api/CurrencyApi.md#currenciesidget) | **GET** /currencies/{id} | получение валюты по id
*FileApi* | [**filesEmailConnectPost**](docs/Api/FileApi.md#filesemailconnectpost) | **POST** /files/email/connect | проверка коннекта к почте
*FileApi* | [**filesEmailLoadPost**](docs/Api/FileApi.md#filesemailloadpost) | **POST** /files/email/load | задание на загрузку файла с почты
*FileApi* | [**filesFtpConnectPost**](docs/Api/FileApi.md#filesftpconnectpost) | **POST** /files/ftp/connect | тест подключения к ftp
*FileApi* | [**filesFtpLoadPost**](docs/Api/FileApi.md#filesftploadpost) | **POST** /files/ftp/load | задание на скачу файла с ftp
*FileApi* | [**filesGet**](docs/Api/FileApi.md#filesget) | **GET** /files | список файлов скаченных с источника
*FileApi* | [**filesHashGet**](docs/Api/FileApi.md#fileshashget) | **GET** /files/{hash} | тип загрузки файла ассортимента
*FileApi* | [**filesHashRawsGet**](docs/Api/FileApi.md#fileshashrawsget) | **GET** /files/{hash}/raws | предпросмотр содержимого загруженного файла
*FileApi* | [**filesHashSourceGet**](docs/Api/FileApi.md#fileshashsourceget) | **GET** /files/{hash}/source | вывод содержимого файла как есть
*FileApi* | [**filesHashStatusGet**](docs/Api/FileApi.md#fileshashstatusget) | **GET** /files/{hash}/status | состояние загрузки файла
*FileApi* | [**filesLinkLoadPost**](docs/Api/FileApi.md#fileslinkloadpost) | **POST** /files/link/load | задание на скачу файла по ссылке
*FtpConfigApi* | [**ftpConfigsGet**](docs/Api/FtpConfigApi.md#ftpconfigsget) | **GET** /ftp-configs | список настроек ftp серверов
*FtpConfigApi* | [**ftpConfigsIdDelete**](docs/Api/FtpConfigApi.md#ftpconfigsiddelete) | **DELETE** /ftp-configs/{id} | удаление настройки
*FtpConfigApi* | [**ftpConfigsIdGet**](docs/Api/FtpConfigApi.md#ftpconfigsidget) | **GET** /ftp-configs/{id} | настройка ftp сервера по id
*FtpConfigApi* | [**ftpConfigsIdPut**](docs/Api/FtpConfigApi.md#ftpconfigsidput) | **PUT** /ftp-configs/{id} | обновление настройки
*FtpConfigApi* | [**ftpConfigsPost**](docs/Api/FtpConfigApi.md#ftpconfigspost) | **POST** /ftp-configs | создание настроек ftp сервера
*MailConfigApi* | [**mailConfigsGet**](docs/Api/MailConfigApi.md#mailconfigsget) | **GET** /mail-configs | список настроек почтовых серверов
*MailConfigApi* | [**mailConfigsIdDelete**](docs/Api/MailConfigApi.md#mailconfigsiddelete) | **DELETE** /mail-configs/{id} | удаление настройки
*MailConfigApi* | [**mailConfigsIdGet**](docs/Api/MailConfigApi.md#mailconfigsidget) | **GET** /mail-configs/{id} | настройка почтового сервера по id
*MailConfigApi* | [**mailConfigsIdPut**](docs/Api/MailConfigApi.md#mailconfigsidput) | **PUT** /mail-configs/{id} | обновление настройки
*MailConfigApi* | [**mailConfigsPost**](docs/Api/MailConfigApi.md#mailconfigspost) | **POST** /mail-configs | создание настройки почтового сервера
*OtherApi* | [**assortmentTypesGet**](docs/Api/OtherApi.md#assortmenttypesget) | **GET** /assortment-types | тип ассортимента с перечнем колонок для разметки
*OtherApi* | [**uploadFileTypesGet**](docs/Api/OtherApi.md#uploadfiletypesget) | **GET** /upload-file-types | тип загрузки файла
*PriceListApi* | [**priceListsGet**](docs/Api/PriceListApi.md#pricelistsget) | **GET** /price-lists | получение прайс-листов
*PriceListApi* | [**priceListsIdDelete**](docs/Api/PriceListApi.md#pricelistsiddelete) | **DELETE** /price-lists/{id} | удаление объекта
*PriceListApi* | [**priceListsIdFileGet**](docs/Api/PriceListApi.md#pricelistsidfileget) | **GET** /price-lists/{id}/file | получение прайс-листа по id
*PriceListApi* | [**priceListsIdFileRawsGet**](docs/Api/PriceListApi.md#pricelistsidfilerawsget) | **GET** /price-lists/{id}/file/raws | содержимое файла прайс-листа согласно разметке
*PriceListApi* | [**priceListsIdGet**](docs/Api/PriceListApi.md#pricelistsidget) | **GET** /price-lists/{id} | получение прайс-листа по id
*PriceListApi* | [**priceListsIdLogsGet**](docs/Api/PriceListApi.md#pricelistsidlogsget) | **GET** /price-lists/{id}/logs | отчет работы прайс-листа
*PriceListApi* | [**priceListsIdPositionsGet**](docs/Api/PriceListApi.md#pricelistsidpositionsget) | **GET** /price-lists/{id}/positions | позиции прайс-листа
*PriceListApi* | [**priceListsIdPositionsReloadPut**](docs/Api/PriceListApi.md#pricelistsidpositionsreloadput) | **PUT** /price-lists/{id}/positions/reload | задание на обновление позиций прайс-листа из файла
*PriceListApi* | [**priceListsIdPut**](docs/Api/PriceListApi.md#pricelistsidput) | **PUT** /price-lists/{id} | обновление прайс-листа
*PriceListApi* | [**priceListsPost**](docs/Api/PriceListApi.md#pricelistspost) | **POST** /price-lists | создание прайс-листа
*ProjectApi* | [**projectsGet**](docs/Api/ProjectApi.md#projectsget) | **GET** /projects | получение проектов
*ProjectApi* | [**projectsIdDelete**](docs/Api/ProjectApi.md#projectsiddelete) | **DELETE** /projects/{id} | удаление проекта
*ProjectApi* | [**projectsIdGet**](docs/Api/ProjectApi.md#projectsidget) | **GET** /projects/{id} | получение проекта по id
*ProjectApi* | [**projectsIdPut**](docs/Api/ProjectApi.md#projectsidput) | **PUT** /projects/{id} | обновление проекта
*ProjectApi* | [**projectsPost**](docs/Api/ProjectApi.md#projectspost) | **POST** /projects | создание проекта
*ProviderApi* | [**providersGet**](docs/Api/ProviderApi.md#providersget) | **GET** /providers | получение поставщиков
*ProviderApi* | [**providersIdDelete**](docs/Api/ProviderApi.md#providersiddelete) | **DELETE** /providers/{id} | удаление объекта
*ProviderApi* | [**providersIdGet**](docs/Api/ProviderApi.md#providersidget) | **GET** /providers/{id} | получение поставщика по id
*ProviderApi* | [**providersIdPut**](docs/Api/ProviderApi.md#providersidput) | **PUT** /providers/{id} | обновление поставщика
*ProviderApi* | [**providersPost**](docs/Api/ProviderApi.md#providerspost) | **POST** /providers | создание поставщика

## Documentation For Models

 - [Assortment](docs/Model/Assortment.md)
 - [AssortmentAutoloadSettings](docs/Model/AssortmentAutoloadSettings.md)
 - [AssortmentFileMode](docs/Model/AssortmentFileMode.md)
 - [AssortmentRequest](docs/Model/AssortmentRequest.md)
 - [AssortmentRequestAutoloadSettings](docs/Model/AssortmentRequestAutoloadSettings.md)
 - [AssortmentType](docs/Model/AssortmentType.md)
 - [AssortmentTypeColumns](docs/Model/AssortmentTypeColumns.md)
 - [Currency](docs/Model/Currency.md)
 - [DateTime](docs/Model/DateTime.md)
 - [FileInfo](docs/Model/FileInfo.md)
 - [FileLoadingCreate](docs/Model/FileLoadingCreate.md)
 - [FileStatus](docs/Model/FileStatus.md)
 - [FtpConfig](docs/Model/FtpConfig.md)
 - [FtpConfigRequest](docs/Model/FtpConfigRequest.md)
 - [FtpConnectRequest](docs/Model/FtpConnectRequest.md)
 - [FtpLoadRequest](docs/Model/FtpLoadRequest.md)
 - [InlineResponse200](docs/Model/InlineResponse200.md)
 - [InlineResponse2001](docs/Model/InlineResponse2001.md)
 - [InlineResponse20010](docs/Model/InlineResponse20010.md)
 - [InlineResponse20011](docs/Model/InlineResponse20011.md)
 - [InlineResponse20012](docs/Model/InlineResponse20012.md)
 - [InlineResponse20013](docs/Model/InlineResponse20013.md)
 - [InlineResponse20014](docs/Model/InlineResponse20014.md)
 - [InlineResponse20015](docs/Model/InlineResponse20015.md)
 - [InlineResponse20016](docs/Model/InlineResponse20016.md)
 - [InlineResponse20017](docs/Model/InlineResponse20017.md)
 - [InlineResponse20018](docs/Model/InlineResponse20018.md)
 - [InlineResponse20019](docs/Model/InlineResponse20019.md)
 - [InlineResponse2002](docs/Model/InlineResponse2002.md)
 - [InlineResponse20020](docs/Model/InlineResponse20020.md)
 - [InlineResponse20021](docs/Model/InlineResponse20021.md)
 - [InlineResponse20022](docs/Model/InlineResponse20022.md)
 - [InlineResponse2003](docs/Model/InlineResponse2003.md)
 - [InlineResponse2004](docs/Model/InlineResponse2004.md)
 - [InlineResponse2005](docs/Model/InlineResponse2005.md)
 - [InlineResponse2006](docs/Model/InlineResponse2006.md)
 - [InlineResponse2007](docs/Model/InlineResponse2007.md)
 - [InlineResponse2008](docs/Model/InlineResponse2008.md)
 - [InlineResponse2009](docs/Model/InlineResponse2009.md)
 - [LinkLoadRequest](docs/Model/LinkLoadRequest.md)
 - [MailConfig](docs/Model/MailConfig.md)
 - [MailConfigRequest](docs/Model/MailConfigRequest.md)
 - [MailConnectRequest](docs/Model/MailConnectRequest.md)
 - [MailLoadRequest](docs/Model/MailLoadRequest.md)
 - [Meta](docs/Model/Meta.md)
 - [ModelSuccess](docs/Model/ModelSuccess.md)
 - [PriceList](docs/Model/PriceList.md)
 - [PriceListFile](docs/Model/PriceListFile.md)
 - [PriceListLog](docs/Model/PriceListLog.md)
 - [PriceListMarking](docs/Model/PriceListMarking.md)
 - [PriceListMarkingColumns](docs/Model/PriceListMarkingColumns.md)
 - [PriceListMarkingColumnsColumns](docs/Model/PriceListMarkingColumnsColumns.md)
 - [PriceListPosition](docs/Model/PriceListPosition.md)
 - [PriceListPriceUploadMode](docs/Model/PriceListPriceUploadMode.md)
 - [PriceListPriceUploadSettings](docs/Model/PriceListPriceUploadSettings.md)
 - [PriceListRequest](docs/Model/PriceListRequest.md)
 - [PriceListRequestMarking](docs/Model/PriceListRequestMarking.md)
 - [PriceListRequestMarkingColumns](docs/Model/PriceListRequestMarkingColumns.md)
 - [PriceListRequestUpload](docs/Model/PriceListRequestUpload.md)
 - [PriceListRequestUploadPriceUploadSettings](docs/Model/PriceListRequestUploadPriceUploadSettings.md)
 - [Project](docs/Model/Project.md)
 - [ProjectRequest](docs/Model/ProjectRequest.md)
 - [Provider](docs/Model/Provider.md)
 - [ProviderRequest](docs/Model/ProviderRequest.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author

info@studio-7.ru

