/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

APL.Grid = new function () {

    this.obj = null;

    this.setGridWidth = function () {
        if (APL.Grid.obj) {
            APL.Grid.obj.setGridWidth(jgrid_getsize_w());
        }

    };

    this.setGridHeight = function (hight_correct) {
        if (APL.Grid.obj) {
            hight_correct = !hight_correct ? 0 : hight_correct;
            APL.Grid.obj.setGridHeight(jgrid_getsize_h() + hight_correct);
        }
    };

    this.adaptiveSize = function () {
        APL.Grid.setGridWidth();
        APL.Grid.setGridHeight();
    };

    //переход по ссылке с добавлением id записи
    this.location = function (url, id) {
        if (!id) {
            var id = APL.Grid.obj.getGridParam('selrow');
        }

        if (!id) {
            APL.Window.alert('Для просмотра, необходимо выделить запись в таблице', 'Предупреждение');
            return false;
        }


        //в коки данные формы
        //APL.Grid.obj.getGridParam("id")
        jQuery.cookie('grid', JSON.stringify(APL.Grid.obj.getPostData()))

        //console.log(jQuery('#grid'))
        location.href = url + id;
    }



    //переход по ссылке с добавлением id записи с окном подтверждения
    this.action = function (t, t2, u) {
        var id = APL.Grid.obj.getGridParam('selrow');
        if (id && t2 > '') {
            return APL.Window.confirm(t2, u + id);
        } else if (id) {
            location.href = u + id;
            return;
        }
        APL.Window.alert(t, 'Предупреждение');
        return false;
    }

    this.multiaction = function (t, t2, u) {
        var ids = jQuery('#grid').getGridParam('selarrrow');

        var action = jQuery('#grid_action').find('select[name=action]').val();

        if (ids.length > 0 && action > '') {
            //console.log(ids);
            jConfirm(t2, 'Подтверждение', function (r) {
                if (r == true) {
                    jQuery('#grid_action').find('input[name=ids]').val(ids);
                    jQuery('#grid_action').submit();
                } else
                    return false;

            });
        } else if (action == '') {
            APL.Window.alert('Действие должно быть выбрано', 'Предупреждение');
        } else {
            APL.Window.alert(t, 'Предупреждение');
        }

        return false;
    }

    this.multiselect = function (t, t2) {
        var ids = jQuery('#grid').getGridParam('selarrrow');



        if (ids.length > 0) {
            //console.log(ids);
            jConfirm(t2, 'Подтверждение', function (r) {
                if (r == true) {
                    jQuery('#grid_action').find('input[name=ids]').val(ids);
                    jQuery('#grid_action').submit();
                } else
                    return false;

            });
        } else {
            APL.Window.alert(t, 'Предупреждение');
        }

        return false;
    }

    this.multiselectaction = function (t, t2, u) {
        var ids = jQuery('#grid').getGridParam('selarrrow');

        if (ids.length > 1) {
            if (ids.length > 1 && t2 > '') {
                return APL.Window.confirmSubmit(t2, u, ids, "form_action");
            } else
                return false;
        }
        APL.Window.alert(t, 'Предупреждение');
        return false;
    }

    /**
     *  Показываем скрытые состояния
     */
    this.viewStates = function (obj) {
        //показываем 
        if (jQuery(obj).val() == 'change_state' && jQuery('#grid_action').find('select[name=state]')) {
            jQuery('#grid_action').find('#state').show();
        }
        //скрытваем
        else if (jQuery('#grid_action').find('select[name=state]')) {
            jQuery('#grid_action').find('#state').hide();
        }
    };

    /**
     *  Создаем сервисную панель управления таблицей
     *  Каждая кнопка формируется в зависимости от настроек
     */
    this.create_buttons = function (_buttons) {

        var _i;

        //проход по кнопкам
        for (_i in _buttons) {

            // console.log('Создаем кнопки', _buttons[_i]);

            switch (_buttons[_i]) {


                //Обновление таблицы
                case 'reload':

                    jQuery('#grid_pager_left').append('<span id="i-reload" title="Обновить" class="icon"></span>');

                    //событие на клик
                    jQuery('#i-reload').click(function () {
                        APL.Grid.obj.trigger("reloadGrid");
                    });

                    break;

                    //Кнопка фильтра
                case 'search':
                    jQuery('#grid_pager_left').append('<span id="i-search" title="Фильтр" class="icon"></span>');

                    jQuery('#i-search').click(function () {
                        //APL.Grid.obj.filterToolbar();

                        APL.Grid.obj[0].toggleToolbar();

                        if (jQuery(this).hasClass('active')) {
                            APL.Grid.setGridHeight();
                        } else {
                            APL.Grid.setGridHeight(-38);
                        }

                        jQuery(this).toggleClass("active");

                    });

                    break;
            }

        }
    };

};


(function ($, sr) {

    // debouncing function from John Hann
    // http://unscriptable.com/index.php/2009/03/20/debouncing-javascript-methods/
    var debounce = function (func, threshold, execAsap) {
        var timeout;

        return function debounced() {
            var obj = this, args = arguments;
            function delayed() {
                if (!execAsap)
                    func.apply(obj, args);
                timeout = null;
            }
            ;

            if (timeout)
                clearTimeout(timeout);
            else if (execAsap)
                func.apply(obj, args);

            timeout = setTimeout(delayed, threshold || 100);
        };
    }
    // smartresize 
    jQuery.fn[sr] = function (fn) {
        return fn ? this.bind('resize', debounce(fn)) : this.trigger(sr);
    };

})(jQuery, 'smartresize');


//получение высоты области для таблицы
function jgrid_getsize_h() {
    var hw = jQuery(window).height();

    var hw_left = jQuery('.vernav2').height();
    var hp = jQuery('.topheader').height() + 17;

    //console.log('hp',hp);

    var hp2 = jQuery('.header').height() + 5;

    //console.log('hp2',hp2);

    hw_left = hw_left + hp + hp2;
    var hw = hw > hw_left ? hw : hw_left;

    //console.log('hw',hw);

    var hd = (jQuery('.pageheader').height() + 30);

    //console.log('hd',hd);

    if (jQuery('div').is('#toolbar') != false) {
        var tollbar = (jQuery('#toolbar').height() + 10);
    } else {
        var tollbar = 0;
    }

    var hb = hw - (hp + hp2 + hd) - (102 + tollbar);

    //console.log('hb',hb);

    return hb;
}

//получение ширины области для таблицы
function jgrid_getsize_w() {
    return (jQuery("#contentwrapper").width() - 10);
}








// usage:
//jQuery(window).smartresize(function(){
//  // code that takes it easy...
//});