<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 04.09.2020
 * Time: 13:43
 */

namespace Widgets\Jquery\Spinner;

use Widgets\TemplateInterface;
use Widgets\Widget;

class Spinner extends Widget
{

    protected $baseVersionLibrary = "jquery-1.7.min.js";

    /**
     * @var
     */
    protected $selector = '#spinner';

    protected $max = 100;

    protected $min = 0;

    public function __construct(\Widgets\TemplateInterface $template, $twig)
    {
        parent::__construct($template, $twig);
    }

    /**
     * @return int
     */
    public function getMin(): int
    {
        return $this->min;
    }

    /**
     * @param int $min
     * @return Spinner
     */
    public function setMin(int $min): Spinner
    {
        $this->min = $min;
        return $this;
    }


    /**
     * @return int
     */
    public function getMax(): int
    {
        return $this->max;
    }

    /**
     * @param int $max
     * @return Spinner
     */
    public function setMax(int $max): Spinner
    {
        $this->max = $max;
        return $this;
    }


    /**
     * @param mixed $selector
     * @return Spinner
     */
    public function setSelector($selector)
    {
        $this->selector = $selector;
        return $this;
    }


    protected function stableVersions(): array
    {
        return [
            "jquery-1.7.min.js"
        ];
    }

    function getJsLinks(): array
    {
        return [
            '/_diamond/widgets/assets/jquery/lib/' . $this->baseVersionLibrary,
            '/_diamond/widgets/assets/jquery/spinner/spinner2.js'
        ];
    }

    function getCssLinks(): array
    {
        return [];
    }


}