<?php

namespace Widgets\Jquery\Autocomplit;

use Twig\Environment;
use Widgets\Widget;

/**
 * Description of autocomplit
 *
 * @author Дмитрий
 */
class Autocomplit extends Widget
{

    protected $baseVersionLibrary = "jquery-2.2.4.min.js";

    protected function stableVersions(): array
    {
        return [
            "jquery-1.7.min.js"
        ];
    }


    /**
     * @return array
     */
    function getJsLinks(): array
    {
        return [
            '/_diamond/diamond-cms/assets/nifty/js/' . $this->baseVersionLibrary,
            '/_diamond/diamond-cms/assets/nifty/plugins/chosen/chosen.jquery.min.js'
        ];
    }

    /**
     * @return array
     */
    function getCssLinks(): array
    {
        return [
            '/_diamond/diamond-cms/assets/nifty/plugins/chosen/chosen.min.css'
        ];
    }


    /**
     * Эллемент для поиска
     * @var string
     */
    protected $find;

    /**
     * @var string
     */
    protected $placeholder_text = 'значения не выбраны';

    /**
     * @param string $find
     * @param \Widgets\TemplateInterface $template
     * @param Environment $twig
     */
    function __construct(string $find, \Widgets\TemplateInterface $template, Environment $twig)
    {
        parent::__construct($template, $twig);
        $this->setFind($find);
    }

    function getFind(): string
    {
        return $this->find;
    }

    function getPlaceholder_text(): string
    {
        return $this->placeholder_text;
    }

    function setFind(string $find)
    {
        $this->find = $find;
        return $this;
    }

    function setPlaceholder_text(string $placeholder_text)
    {
        $this->placeholder_text = $placeholder_text;
        return $this;
    }

}
