<?php

namespace Widgets\Jquery\ColorPicker;

use Twig\Environment;
use Twig_Environment;
use Widgets\TemplateInterface;
use Widgets\Widget;

class ColorPicker extends Widget
{
    protected $baseVersionLibrary = "jquery-1.7.min.js";

    /**
     * @return array
     */
    protected function stableVersions(): array
    {
        return [
          //  "jquery-1.7.min.js"
        ];
    }


    /**
     * @return array
     */
    function getJsLinks(): array
    {
        return array(
            //'/_diamond/widgets/assets/jquery/color/' . $this->baseVersionLibrary,
            //'/_diamond/widgets/assets/jquery/color/jquery.minicolors.js'
          //  '/_diamond/widgets/assets/jquery/lib/non-conflict.js',
            '/_diamond/diamond-cms/assets/nifty/js/jquery-2.2.4.min.js'
        );
    }

    /**
     * @return array
     */
    function getCssLinks(): array
    {
        return array(
           // '/_diamond/widgets/assets/jquery/color/jquery.minicolors.css',
            //'https://itsjavi.com/bootstrap-colorpicker/dist/css/bootstrap-colorpicker.css'
        );
    }


    /**
     * @var string
     */
    protected $id;

    /**
     * @param $id
     * @param TemplateInterface $template
     * @param Environment $twig
     */
    function __construct($id, TemplateInterface $template, Environment $twig)
    {
        parent::__construct($template, $twig);
        $this->setId($id);
    }

    /**
     * @return string
     */
    function getId(): string
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return $this
     */
    function setId(string $id)
    {
        $this->id = $id;
        return $this;
    }

}
