<?php

namespace Widgets\Jquery\Jmask;

class Jmask extends \Widgets\Widget
{

    /**
     * @var string
     */
    protected $baseVersionLibrary = "jquery-2.2.4.min.js";

    /**
     * @var string
     */
    protected $id;

    /**
     * @var string
     */
    protected $mask;

    protected function stableVersions(): array
    {
        return [
            "jquery-2.2.4.min.js",
            "jquery-1.9.1.min.js"
        ];
    }



    /**
     * @param string $id
     * @return $this
     */
    public function setId(string $id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @param string $mask
     * @return $this
     */
    public function setMask(string $mask)
    {
        $this->mask = $mask;
        return $this;
    }


    /**
     * @return array
     */
    function getJsLinks(): array
    {
        return [
            '/_diamond/diamond-cms/assets/nifty/js/' . $this->baseVersionLibrary,
            '/_diamond/widgets/assets/jquery/maskedinput/maskedinput-1.3.min.js'
        ];
    }

    /**
     * @return array
     */
    function getCssLinks(): array
    {
        return [];
    }


}