<?php

namespace Widgets;

use Core\Template\Template;
use Core\TwigAwareInterface;
use Core\TwigAwareTrait;
use Symfony\Component\HttpFoundation\Request;
use Twig_Environment;
use Widgets\Jquery\LazyLoad\LazyLoad;

/**
 * Description of TextEditorBuilder
 *
 * @author Dmitriy
 */
class WidgetBuilder implements TwigAwareInterface
{
    protected $twig;
    protected $template;
    protected $request;
    use TwigAwareTrait;

    /**
     * WidgetBuilder constructor.
     * @param Template $template
     * @param Request $request
     */
    function __construct(Template $template, Request $request)
    {
        $this->template = $template;
        $this->request  = $request;
    }

    /**
     * @param $selector
     * @return LazyLoad
     */
    public function buildLazyLoad($selector):LazyLoad
    {
        return (new LazyLoad($this->template,$this->twig))->setSelector($selector);
    }

}