<?php

namespace Widgets\Jquery\Tinymce;

use Widgets\Widget;

/**
 * Description of tinymce
 *
 * @author Дмитрий
 */
class Tinymce extends Widget
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $height = "400";

    /**
     * @var string
     */
    protected $width = '100%';
    protected $compact = false;
    protected $mini = false;
    protected $value;
    protected $baseVersionLibrary = "jquery-1.7.min.js";

    /**
     * @var string
     */
    protected $accessKey;
    
    /**
     * Tinymce constructor.
     * @param \Widgets\TemplateInterface $template
     * @param \Twig_Environment $twig
     * @param $name
     */
    public function __construct(\Widgets\TemplateInterface $template, \Twig_Environment $twig, $name)
    {
        parent::__construct($template, $twig);
        $this->setName($name);
    }

    /**
     * @return string
     */
    public function getAccessKey(): string
    {
        return $this->accessKey;
    }

    /**
     * @param string $accessKey
     * @return Tinymce
     */
    public function setAccessKey(string $accessKey): Tinymce
    {
        $this->accessKey = $accessKey;
        return $this;
    }

    public function getValue():string
    {
        return $this->value;
    }

    /**
     * @param $value
     * @return $this
     */
    public function setValue(?string $value)
    {
        $this->value = $value;
        return $this;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * @param int $height
     * @return $this
     */
    public function setHeight(string $height)
    {
        $this->height = $height;
        return $this;
    }

    /**
     * @param int $width
     * @return $this
     */
    public function setWidth(string $width)
    {
        $this->width = $width;
        return $this;
    }

    /**
     * @param bool $compact
     * @return $this
     */
    public function setCompact(bool $compact)
    {
        $this->compact = $compact;
        return $this;
    }

    /**
     * @param bool $mini
     * @return $this
     */
    public function setMini(bool $mini)
    {
        $this->mini = $mini;
        return $this;
    }

    /**
     * @return array
     */
    public function getCssLinks(): array
    {
        return [];
    }

    /**
     * @return array
     */
    public function getJsLinks(): array
    {
        return [
            '/_diamond/widgets/assets/jquery/lib/' . $this->baseVersionLibrary,
            '/_diamond/widgets/assets/jquery/tinymce/jquery.tinymce.js'
        ];
    }

    protected function stableVersions(): array
    {
        return [
            "jquery-1.7.min.js"
        ];
    }


}