<?php

namespace Widgets\Jquery\Autocomplit;

use Widgets\Widget;

/**
 * Description of autocomplit
 *
 * @author Дмитрий
 */
class Autocomplit extends Widget
{

    protected $baseVersionLibrary = "jquery-1.7.2.min.js";

    protected function stableVersions(): array
    {
        return [
            "jquery-1.7.2.min.js"
        ];
    }


    /**
     * @return array
     */
    function getJsLinks(): array
    {
        return [
            '/_diamond/widgets/assets/jquery/lib/' . $this->baseVersionLibrary,
            '/_diamond/widgets/assets/jquery/chosen/chosen.min.js'
        ];
    }

    /**
     * @return array
     */
    function getCssLinks(): array
    {
        return [
            '/_diamond/widgets/assets/jquery/chosen/chosen.css'
        ];
    }


    /**
     * Эллемент для поиска
     * @var string
     */
    protected $find;

    /**
     * @var string
     */
    protected $placeholder_text = 'значения не выбраны';

    /**
     * Autocomplit constructor.
     * @param string $find
     * @param \Widgets\TemplateInterface $template
     * @param \Twig_Environment $twig
     */
    function __construct(string $find, \Widgets\TemplateInterface $template, \Twig_Environment $twig)
    {
        parent::__construct($template, $twig);
        $this->setFind($find);
    }

    function getFind(): string
    {
        return $this->find;
    }

    function getPlaceholder_text(): string
    {
        return $this->placeholder_text;
    }

    function setFind(string $find)
    {
        $this->find = $find;
        return $this;
    }

    function setPlaceholder_text(string $placeholder_text)
    {
        $this->placeholder_text = $placeholder_text;
        return $this;
    }

}
