<?php

namespace Widgets\Jquery\DatePicker;

use Twig_Environment;
use Widgets\TemplateInterface;
use Widgets\Widget;


/**
 * Description of DatePicker
 *
 * @author Admin
 */
class DatePicker extends Widget
{

    /**
     * @var string
     */
    protected $selector;

    /**
     * @var string
     */
    protected $format = 'dd/mm/yy';

    protected $baseVersionLibrary = "jquery-1.7.2.min.js";

    protected function stableVersions(): array
    {
        return [
            "jquery-1.7.2.min.js"
        ];
    }


    function getJsLinks(): array
    {
        return array(
            //'/_diamond/widgets/assets/jquery/lib/' . $this->baseVersionLibrary,
            //'/_diamond/widgets/assets/jquery/datepicker/timepicker_plug/timepicker.js',
            //'/_diamond/widgets/assets/jquery/datepicker/i18n/ui.datepicker-ru.js'
        );
    }

    function getCssLinks(): array
    {
        return array(
            // '/_diamond/widgets/assets/jquery/datepicker/timepicker_plug/css/style.css',
           // '{css_template_path}plugins/jquery.ui.css'
        );
    }

    /**
     * DatePicker constructor.
     * @param string $selector
     * @param TemplateInterface $template
     * @param Twig_Environment $twig
     */
    public function __construct(string $selector, TemplateInterface $template, Twig_Environment $twig)
    {
        parent::__construct($template, $twig);
        $this->setSelector($selector);
    }

    /**
     * @return string
     */
    public function getSelector(): string
    {
        return $this->selector;
    }

    /**
     * @return string
     */
    public function getFormat(): string
    {
        return $this->format;
    }

    /**
     * @param string $selector
     * @return $this
     */
    public function setSelector(string $selector)
    {
        $this->selector = $selector;
        return $this;
    }

    /**
     * @param string $format
     * @return $this
     */
    public function setFormat(string $format)
    {
        $this->format = $format;
        return $this;
    }

}
