<?php
/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 04.09.2020
 * Time: 13:43
 */

namespace Widgets\Jquery\Spinner;

use Widgets\TemplateInterface;
use Widgets\Widget;

class Spinner extends Widget
{

    /**
     * @var
     */
    protected $selector = '#spinner';

    public function __construct(\Widgets\TemplateInterface $template, $twig)
    {
        parent::__construct($template, $twig);
    }

    /**
     * @param mixed $selector
     * @return Spinner
     */
    public function setSelector($selector)
    {
        $this->selector = $selector;
        return $this;
    }


    protected function stableVersions(): array
    {
        return [
            "jquery-1.7.2.min.js"
        ];
    }

    function getJsLinks(): array
    {
        return [
            '/_diamond/widgets/assets/jquery/lib/' . $this->baseVersionLibrary,
            '/_diamond/widgets/assets/jquery/spinner/spinner2.js'
        ];
    }

    function getCssLinks(): array
    {
        return [];
    }


}