<?php

namespace Widgets\Jquery\Jmask;

class Jmask extends \Widgets\Widget
{

    /**
     * @var string
     */
    protected $baseVersionLibrary = "jquery-1.7.2.min.js";

    /**
     * @var string
     */
    protected $id;

    /**
     * @var string
     */
    protected $mask;

    protected function stableVersions(): array
    {
        return [
            "jquery-1.7.2.min.js",
            "jquery-1.9.1.min.js"
        ];
    }



    /**
     * @param string $id
     * @return $this
     */
    public function setId(string $id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @param string $mask
     * @return $this
     */
    public function setMask(string $mask)
    {
        $this->mask = $mask;
        return $this;
    }


    /**
     * @return array
     */
    function getJsLinks(): array
    {
        return [
            '/_diamond/widgets/assets/jquery/lib/' . $this->baseVersionLibrary,
            '/_diamond/widgets/assets/jquery/maskedinput/maskedinput-1.3.min.js'
        ];
    }

    /**
     * @return array
     */
    function getCssLinks(): array
    {
        return [];
    }


}