<?php

namespace Widgets\Jquery\ColorPicker;

use Twig_Environment;
use Widgets\TemplateInterface;
use Widgets\Widget;

class ColorPicker extends Widget
{
    protected $baseVersionLibrary = "jquery-1.7.2.min.js";

    /**
     * @return array
     */
    protected function stableVersions(): array
    {
        return [
            "jquery-1.7.2.min.js"
        ];
    }


    /**
     * @return array
     */
    function getJsLinks(): array
    {
        return array(
            '/_diamond/widgets/assets/jquery/lib/' . $this->baseVersionLibrary,
            '/_diamond/widgets/assets/jquery/colorpicker/colorpicker.js'
        );
    }

    /**
     * @return array
     */
    function getCssLinks(): array
    {
        return array(
            '{css_template_path}plugins/colorpicker.css'
        );
    }


    /**
     * @var string
     */
    protected $id;

    /**
     * ColorPicker constructor.
     * @param $id
     * @param TemplateInterface $template
     * @param Twig_Environment $twig
     */
    function __construct($id, TemplateInterface $template, Twig_Environment $twig)
    {
        parent::__construct($template, $twig);
        $this->setId($id);
    }

    /**
     * @return string
     */
    function getId(): string
    {
        return $this->id;
    }

    /**
     * @param string $id
     * @return $this
     */
    function setId(string $id)
    {
        $this->id = $id;
        return $this;
    }

}
