<?php

namespace Widgets\Jquery\LazyLoad;

class LazyLoad extends \Widgets\Widget
{
    /**
     * @var string
     */
    protected $effect = 'fadeIn';

    /**
     * @var string
     */
    protected $selector = 'img';

    protected $baseVersionLibrary = "jquery.min.js";

    protected function stableVersions(): array
    {
        return [
            "jquery.min.js"
        ];
    }


    /**
     * @return array
     */
    public function getJsLinks(): array
    {
        return [
            '{js_path}jquery/lib/' . $this->baseVersionLibrary,
            '{js_path}jquery/lazyload/jquery.lazyload.js'
        ];
    }

    /**
     * @return array
     */
    public function getCssLinks(): array
    {
        return [];
    }


    /**
     * @return string
     */
    public function getEffect():string
    {
        return $this->effect;
    }

    /**
     * @return string
     */
    public function getSelector():string
    {
        return $this->selector;
    }

    /**
     * @param string $effect
     * @return $this
     */
    public function setEffect(string $effect)
    {
        $this->effect = $effect;
        return $this;
    }

    /**
     * @param string $selector
     * @return $this
     */
    public function setSelector(string $selector)
    {
        $this->selector = $selector;
        return $this;
    }


}
