<?php

namespace Widgets\Jquery\Jgrid;

use Widgets\TemplateInterface;

/**
 * Description of Jqgrid
 *
 * @author Dmitriy
 */
class Jqgrid extends \Widgets\Widget
{

    protected $columns = [];

    protected $customformat = [];

    protected $grid_name = 'grid';

    protected $grid_pager = 'grid_pager';

    protected $datatype = 'json';

    protected $url = '';

    protected $mtype = 'post';

    protected $sortname = '';

    protected $sortorder = 'desc';

    protected $rownum = 100;

    protected $viewrecords = true;

    protected $hidden = false;

    protected $autowidth = true;

    protected $loadui = 'block';

    protected $loadtext = 'загрузка..';

    protected $multiselect = false;

    protected $width = 700;

    protected $height = 300;

    protected $adaptivesize = true;

    protected $baseVersionLibrary = "jquery-1.7.2.min.js";

    /**
     * Jqgrid constructor.
     * @param string $template
     * @param string $twig
     */
    function __construct(TemplateInterface $template, \Twig\Environment $twig)
    {
        parent::__construct($template, $twig);

        $this->post['rows'] = input_post('rows');
        $this->post['page'] = input_post('page');

        $this->post['sidx'] = input_post('sidx');
        $this->post['sord'] = input_post('sord');
    }

    protected function stableVersions(): array
    {
        return [
            "jquery-1.7.2.min.js"
        ];
    }


    /**
     * @return array
     */
    function getJsLinks(): array
    {
        return array(
            '{js_path}jquery/lib/' . $this->baseVersionLibrary,
            '{js_path}jquery/jgrid/grid-locale-ru.js',
            '{js_path}jquery/jgrid/jquery-jqGrid-min.js'
        );
    }

    /**
     * @return array
     */
    function getCssLinks(): array
    {
        return array(
            '{js_path}jquery/jgrid/skin/ui.jqgrid.css',
            '{css_template_path}plugins/jqgrid.style.css'
        );
    }


    /**
     *
     * @param type $column
     * @return $this
     */
    public function addColumns(array $columns)
    {
        foreach ($columns as $column)
            $this->addColumn($column);

        return $this;
    }

    /**
     * add column
     * @param type $column
     */
    public function addColumn($column)
    {

        if (!isset($column['index']) && $field_name = $column['name']) {
            $column['index'] = $field_name;
        }

        if (isset($column['key']) && $column['key'] == true) {
            $this->key = $column['index'];
        }

        $this->sortname = empty($this->sortname) ? $this->key : $this->sortname;

        $this->addCustomFormat($column);

        $this->columns[] = $column;
    }

    public function getSortname(): string
    {
        return $this->sortname;
    }

    public function getSortorder(): string
    {
        return $this->sortorder;
    }

    public function setSortname(string $sortname)
    {
        $this->sortname = $sortname;
        return $this;
    }

    public function setSortorder(string $sortorder)
    {
        $this->sortorder = $sortorder;
        return $this;
    }

    /**
     *
     * @param bool $multiselect
     * @return $this
     */
    public function setMultiselect(bool $multiselect)
    {
        $this->multiselect = $multiselect;
        return $this;
    }

    /**
     *
     * @return type
     */
    public function getMultiselect(): bool
    {
        return $this->multiselect;
    }

    /**
     *
     * @param type $data
     */
    protected function addCustomFormat($data)
    {
        if (isset($data['customformat'])) {
            $this->customformat[$data['name']] = $data['customformat'];
        }
    }
}
