<?php

namespace Widgets;

use Core\Template\Template;
use Core\TwigAwareInterface;
use Symfony\Component\HttpFoundation\Request;
use Twig_Environment;
use Widgets\Jquery\LazyLoad\LazyLoad;

/**
 * Description of TextEditorBuilder
 *
 * @author Dmitriy
 */
class WidgetBuilder implements TwigAwareInterface
{
    protected $twig;
    protected $template;
    protected $request;

    public function setTwig(Twig_Environment $twig)
    {
        $this->twig = $twig;
        return $this;
    }

    function __construct(Template $template, Request $request)
    {
        $this->template = $template;
        $this->request  = $request;
    }

    public function buildLazyLoad($selector)
    {
        return (new LazyLoad($this->template,$this->twig))->setSelector($selector);
    }

}