<?php
namespace Widgets\Jquery\Jgrid;

/**
 * Description of Jqgrid
 *
 * @author Dmitriy
 */
class Jqgrid extends \Widgets\Widget{

    protected $columns = [];

    protected $customformat = [];

    protected $grid_name = 'grid';

    protected $grid_pager = 'grid_pager';

    protected $datatype = 'json';

    protected $url = '';

    protected $mtype = 'post';

    protected $sortname = '';

    protected $sortorder = 'desc';
    
    protected $rownum = 100;
    
    protected $viewrecords = true;
    
    protected $hidden = false;
    
    protected $autowidth = true;

    protected $loadui = 'block';

    protected $loadtext = 'загрузка..';

    protected $multiselect = false;    
    
    protected $width = 700;

    protected $height = 300;    

    protected $adaptivesize  = true;
	    
    function __construct($template,
			 $twig){
	parent::__construct($template, $twig);

	$this->post['rows']	 = input_post('rows');
	$this->post['page']	 = input_post('page');

	$this->post['sidx']	 = input_post('sidx');
	$this->post['sord']	 = input_post('sord');
    }

    /**
     * 
     * @return type
     */
    public function setCssLinks(){
	return array(
	    '{js_path}jquery/jgrid/skin/ui.jqgrid.css',
	    '{css_template_path}plugins/jqgrid.style.css'
	);
    }

    /**
     * 
     * @return type
     */
    public function setJsLinks(){
	return array(
	    '{js_path}jquery/lib/jquery-1.7.2.min.js',
	    '{js_path}jquery/jgrid/grid-locale-ru.js',
	    '{js_path}jquery/jgrid/jquery-jqGrid-min.js'
	);
    }

    /**
     * 
     * @param type $column
     * @return $this
     */
    function addColumns(array $columns){
	foreach($columns as $column)
	    $this->addColumn($column);
	
	return $this;
    }

    /**
     * add column
     * @param type $column
     */
    public function addColumn($column){

	if(!isset($column['index']) && $field_name = $column['name']){
	    $column['index'] = $field_name;
	}

	if(isset($column['key']) && $column['key'] == true){
	    $this->key = $column['index'];
	}

	$this->sortname = empty($this->sortname) ? $this->key : $this->sortname;

	$this->addCustomFormat($column);

	$this->columns[] = $column;
    }
    
    function getSortname() {
        return $this->sortname;
    }

    function getSortorder() {
        return $this->sortorder;
    }

    function setSortname($sortname) {
        $this->sortname = $sortname;
        return $this;
    }

    function setSortorder($sortorder) {
        $this->sortorder = $sortorder;
        return $this;
    }

    /**
     * 
     * @param bool $multiselect
     * @return $this
     */
    function setMultiselect(bool $multiselect)
    {
        $this->multiselect = $multiselect;
        return $this;
    }
    
    /**
     * 
     * @return type
     */
    function getMultiselect():bool
    {
        return $this->multiselect;
    }
    
    /**
     * 
     * @param type $data
     */
    protected function addCustomFormat($data){
	if(isset($data['customformat'])){
	    $this->customformat[$data['name']] = $data['customformat'];
	}
    }
}
