<?php

namespace Widgets\Jquery\Autocomplit;

use Widgets\Widget;

/**
 * Description of autocomplit
 *
 * @author Дмитрий
 */
class Autocomplit extends Widget {

    public function setJsLinks() {
        return [
            '{js_path}jquery/lib/jquery-1.7.2.min.js',
            '{js_path}jquery/chosen/chosen.min.js'
        ];
    }

    public function setCssLinks() {
        return [
            '{js_path}jquery/chosen/chosen.css'
        ];
    }

    /**
     * Эллемент для поиска
     *
     * @var type 
     */
    protected $find;

    /**
     * 
     * 
     * @var type 
     */
    protected  $placeholder_text = 'значения не выбраны';

    
    function __construct($find, \Widgets\TemplateInterface $template, \Twig_Environment $twig) {
        parent::__construct($template, $twig);
        $this->setFind($find);
    }

    function getFind() {
        return $this->find;
    }

    function getPlaceholder_text() {
        return $this->placeholder_text;
    }

    function setFind($find) {
        $this->find = $find;
        return $this;
    }

    function setPlaceholder_text($placeholder_text) {
        $this->placeholder_text = $placeholder_text;
        return $this;
    }

}
