<?php
namespace Widgets;

abstract class Widget{

    private $template;

    private $twig;
    
    function __construct(TemplateInterface $template, \Twig_Environment $twig){

	$this->template = $template;
	$this->twig	= $twig;
    }
    
    /**
     * Widget::ajax_query()
     * 
     * @return
     */
    public function ajax_query() {
    
        if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && !empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
            return TRUE;
        } else {
            return FALSE;
        }
   
    }
    
    abstract function setJsLinks();
	    
    abstract function setCssLinks();

    function Render($view = 'default'){
	
	$this->loadResourse();
	
	$ref = new \ReflectionClass($this);
	$tpl = (new \SplFileInfo($ref->getFileName()))->getPath();
	
	$this->twig->getLoader()->prependPath($tpl);
	
	$html = $this->twig->render($view . '.twig', $this->getParams());
	
	if(preg_match('~(<script type\=\"text\/javascript\">.*?<\/script>)~is', $html, $m)){
	    $html = str_replace($m[1], '', $html);
	    $this->template->addScript($m[1]);
	}
	
	return $html;	 
    }
 
    /**
     * Загрузка ресурсов
     * 
     * @return void
     */
    function loadResourse(){

	$this->template->addScriptLinks($this->setJsLinks());

	$this->template->addStyleLinks($this->setCssLinks());
    }

    protected function getUrlAjax(){
	$uri	 = uri_string();
	$url	 = $uri ;//. $this->config->item('url_suffix');
	return '/' . $url; //str_replace('admin/', '/_ajax/', $url);
    }

    /**
     * 
     * @return type
     */
    protected function getParams(){
	
	$class = new \ReflectionClass(get_class($this));
	
	$data = [];
	
	foreach($class->getProperties(\ReflectionProperty::IS_PROTECTED) as $prop){
	    $data[$prop->name] = $this->{$prop->name};
	}
	
	return $data;
    }
}
