<?php

namespace Widgets\Jquery\Tinymce;

use Widgets\Widget;

/**
 * Description of tinymce
 *
 * @author Дмитрий
 */
class Tinymce extends Widget
{
    protected $name;
    protected $height  = '500';
    protected $width   = '100';
    protected $compact = false;
    protected $mini    = false;
    protected $value;

    function __construct(\Widgets\TemplateInterface $template,
                         \Twig_Environment $twig, $name)
    {
        parent::__construct($template, $twig);
        $this->setName($name);
    }

    function getValue()
    {
        return $this->value;
    }

    function setValue($value)
    {
        $this->value = $value;
        return $this;
    }

    function setName($name)
    {
        $this->name = $name;
    }

    function setHeight($height)
    {
        $this->height = $height;
        return $this;
    }

    function setWidth($width)
    {
        $this->width = $width;
        return $this;
    }

    function setCompact($compact)
    {
        $this->compact = $compact;
        return $this;
    }

    function setMini($mini)
    {
        $this->mini = $mini;
        return $this;
    }

    public function setCssLinks()
    {

    }

    public function setJsLinks()
    {
        return [
            '{js_path}jquery/lib/jquery-1.7.2.min.js',
            '{js_path}jquery/tinymce/jquery.tinymce.js'
        ];
    }
}