<?php
namespace Widgets\Jquery\Jgrid;

use Widgets\Widget;

/**
 * YUI_editor
 *
 * @package Уральская сказка
 * @author dimaxz
 * @copyright 2013
 * @version $Id$
 * @access public
 */
class Jqgrid extends Widget{

    public $grid_name = 'grid';

    public $grid_pager = 'grid_pager';

    public $datatype = 'json';

    public $url = '';

    public $mtype = 'post';

    public $sortname = '';

    public $sortorder = 'desc';

    public $colnames = array();

    public $colmodel = array(
//		array(
//			'title'		=>	'№',
//			'name'		=>	'id',
//			'key'		=>	true,
//			'width'		=>	100,
//			//'hidden'	=>	true
//		),
//
//		array(
//			'title'		=>	'Наименование',
//			'name'		=>	'title',
//			'width'		=>	200
//		)
    );

    public $rownum = 100;

    public $rowlist = array(
	100,
	250,
	500,
	1000);

    public $caption = '';

    public $viewrecords = true;

    public $hidden = false;

    public $autowidth = true;

    public $loadui = 'block';

    public $loadtext = 'загрузка..';

    public $multiselect = false;

    public $postdata = array();



    private $model;

    protected $key;

    public $url_form = '';

    public $toolbar = true;

    public $toolbar_buttons = array();

    public $toolbar_actions = array();

    public $adaptivesize = true;

    public $width = 700;

    public $height = 300;

    /**
     * пост данные содержащие порядок сортировки, поле сортировки, кол-строк и т.д.
     *
     * @var type
     */
    protected $post = [
	    ];

    protected $summary = [
	    ];

    protected $summary_result = [
	    ];

    public function setCssLinks(){
	return array(
	    '{js_path}jquery/jgrid/skin/ui.jqgrid.css',
	    '{css_template_path}plugins/jqgrid.style.css'
	);
    }

    public function setJsLinks(){
	return array(
	    '{js_path}jquery/lib/jquery-1.7.2.min.js',
	    '{js_path}jquery/jgrid/grid-locale-ru.js',
	    '{js_path}jquery/jgrid/jquery-jqGrid-min.js'
	);
    }

    function __construct($template,
			 $twig){
	parent::__construct($template, $twig);

	$this->post['rows']	 = input_post('rows');
	$this->post['page']	 = input_post('page');

	$this->post['sidx']	 = input_post('sidx');
	$this->post['sord']	 = input_post('sord');
    }

    public function setSummary(array $summary){
	$this->summary = $summary;
    }

    public function addModel(\Core\Model $model){
	$this->model = $model;
    }

    public function addColumns($columns){
	foreach($columns as $column){
	    $this->addColumn($column);
	}
	//__var_dump($this->colmodel);
    }

    public function addColumn($column){

	if(!isset($column['title']) && is_object($this->model)){
	    $column['title'] = $this->findTitleInModel($column['name']);
	}

	if(isset($column['key']) && $column['key'] == true){
	    $this->key = $column['name'];

	    $this->sortname = empty($this->sortname) ? $this->key : $this->sortname;
	}

	$this->addCustomFormat($column);

	$this->colmodel[] = $column;
    }

    private function findTitleInModel($name){
	if(isset($this->model->validate)){
	    foreach($this->model->validate as $validate){
		if($validate['field'] == $name && !empty($validate['label'])){
		    return $validate['label'];
		}
	    }
	}
	return $name;
    }

    /**
     * Инициализация виджета
     *
     * @param type $param
     */
    public function init($param = array()){

	//отправка данные если аякс
	if($this->ajax_query() == TRUE){
	    setAjaxStream($this->sendData());
	    return;
	}


	set_bookmark('last_table');

	$this->url = $this->getUrlAjax();

	parent::init($param);

	//доп. подготовка переменных-----------------------------------------------
	$this->addOption('colmodel', $this->prepOptionColModel());
	$this->addOption('postData', $this->prepOptionPostData());


	$this->addOption('colnames', implode("','", $this->colnames));
	$this->addOption('rowlist', implode(",", $this->rowlist));

	if(!empty($this->caption)){
	    $this->addOption('caption', "caption:'{$this->caption}',");
	}

	if(!empty($this->url_form)){
	    $this->addOption('onclick_href',
		      "ondblClickRow:function(rowid){
					location.href = '" . $this->url_form . '?id=' . "' + rowid
				}"
	    );
	} else{
	    $this->addOption('onclick_href', '');
	}

	if($this->adaptivesize == TRUE){
	    $this->addOption('adaptivesize',
		      "
//адаптация таблицы под размер экрана
APL.Grid.adaptiveSize();
jQuery(window).smartresize(function(){
	APL.Grid.adaptiveSize();
});");
	}

	$this->addOption('viewrecords', $this->prepOptionBool('viewrecords'));
	$this->addOption('hidden', $this->prepOptionBool('hidden'));
	$this->addOption('autowidth', $this->prepOptionBool('autowidth'));
	$this->addOption('multiselect', $this->prepOptionBool('multiselect'));

	if(count($this->summary) > 0){
	    $this->addOption('conf.footerSumm',
		      'footerrow : true,userDataOnFooter : true,');
	} else{
	    $this->addOption('conf.footerSumm', '');
	}

	//-------------------------------------------------------------------------
	//добавления основного скрипта
	$this->addScript('

		jQuery(window).load(function() {

		APL.Grid.obj = jQuery("#{grid_name}").jqGrid({

		pagerpos: "right",
		recordpos: "left",
		datatype:   "{datatype}",
		url:        "{url}",
		mtype:      "{mtype}",
		colNames:   [\'{colnames}\'],
		colModel:   [{colmodel}],
		rowNum:     {rownum},
		rowList:    [{rowlist}],
		pager:      "#{grid_pager}",
		sortorder:  "{sortorder}",
		sortname:   "{sortname}",
		shrinkToFit:true,
		autowidth:true,
		scrollOffset:25,
		multiboxonly:true,
		hoverrows:false,
		forceFit:false,
//		cellLayout:7,
			

		{caption}

		viewrecords: {viewrecords},

		//height: 	{height},

		hiddengrid:	{hidden},
		//autowidth:	{autowidth},
		width:{width},
                height:{height},
		loadui:		"{loadui}",
		loadtext:	"{loadtext}",
		multiselect: {multiselect},
		postData: {postData},

		recordpos: \'right\',
		pagerpos: \'center\',
		//footerrow : true,
        //userDataOnFooter : true,
		buttons:[\'reload\',\'filter\'],

		{conf.footerSumm}
		{onclick_href}

		}).jqGrid(\'filterToolbar\',{
			//searchOperators:true
		});

		APL.Grid.obj[0].toggleToolbar();

			{adaptivesize}
			//APL.Grid.adaptiveSize();

			APL.Grid.create_buttons([\'reload\',\'search\']);//

		});');

	if($this->toolbar == true){
	    $this->addHtml($this->getToolbarHtml());
	}

	$this->addHtml('<table id="{grid_name}"></table><div id="{grid_pager}"></div>');

	return parent::render();
    }

    /**
     * Подготовка данных для рендеринга свойства
     */
    private function prepOptionColModel(){
	$colmodel = '';

	foreach($this->colmodel as $k => $v){

	    $this->colnames[$k] = $v['title'];

	    $colmodel .= "{" . "\r\n" .
		    "name:'" . $v['name'] . "'," . "\r\n" .
		    "index:'" . (isset($v['index']) ? $v['index'] : $v['name']) . "'," . "\r\n";

	    $v['nospan'] = true; //временно заглушили из за бага в Опере

	    if(!isset($v['nospan']))
		$colmodel .= "formatter:function(e){e = e>''?e:'';return '<span>'+e+'</span>';}," . "\r\n";

	    if(isset($v['width']))
		$colmodel .= "width:" . $v['width'] . "," . "\r\n";

	    if(isset($v['align']))
		$colmodel .= "align:'" . $v['align'] . "'," . "\r\n";

	    if(isset($v['search']) && $v['search'] === FALSE)
		$colmodel .= "search: false ," . "\r\n";

	    if(isset($v['stype']) && $v['stype'] == 'select' && isset($v['editoptions'])){
		$colmodel .= "stype:'select', editoptions:{value:\"{$v['editoptions']}\"}," . "\r\n";
	    }

	    if(isset($v['sortable']) && $v['sortable'] === FALSE)
		$colmodel .= "sortable: false ," . "\r\n";

	    if(isset($v['hidden']) && $v['hidden'] == TRUE)
		$colmodel .= "hidden:true" . "," . "\r\n";

	    if(isset($v['key']) && $v['key'] == TRUE)
		$colmodel .= "key:true" . "," . "\r\n";

	    $colmodel = substr($colmodel, 0, -3);

	    $colmodel .= "}" . "," . "\r\n";
	}

	return substr($colmodel, 0, -3);
    }

    /**
     * подготовка пост данных
     */
    private function prepOptionPostData(){
	$txt = '';
	if(count($this->postdata) > 0){
	    foreach($this->postdata as $k => $v)
		$txt .= "$k:'$v',";
	}

	return $txt = '{' . rtrim($txt, ',') . '}';
    }

    private function sendData(){

	$this->applyFilter($this->model);

	$count = $this->getCount();

	$rows	 = $this->post['rows'];
	$page	 = $this->post['page'];

	if($count > 0){
	    $total = ceil($count / $rows);
	} else{
	    $total = 0;
	}
	if($page > $total)
	    $page = $total;

	//формируем данные
	$responce		 = array();
	$responce['page']	 = $page;
	$responce['total']	 = $total;
	$responce['records']	 = $count;
	//Получаем данные
	$responce['rows']	 = $this->getRows();

	if(count($this->summary) > 0){
	    foreach($this->summary as $summ_field){
		$responce['userdata'][$summ_field] = number_format($this->summary_result[$summ_field],
						     2, '.', ' ');
	    }
	}

	return json_encode($responce);
    }

    /**
     * кол-во записей
     *
     * @return type
     */
    protected function getCount(){
	return $this->model->count_whit_filters(); //$this->model->count_all();
    }

    protected function getRows(){

	$model = $this->model;

	if(isset($this->post['page']) && isset($this->post['rows'])){
	    $model = $model->limit($this->post['rows'],
			    ($this->post['page'] - 1) * $this->post['rows']);
	} else{
	    $model = $model->limit($this->post['rows']);
	}

	if(isset($this->post['sidx']) && isset($this->post['sord'])){
	    $model->order_by($this->post['sidx'], $this->post['sord']);
	} else{
	    $model->order_by($this->sortname, $this->sortorder);
	}


	$rows = $model->get_all();

	$line = array();

	foreach($this->colmodel as $k => $column){
	    $line[] = '$this->prepareRow($row,\'' . $column['name'] . '\') '; //
	}

	$this->line = '$_rows[$i] = array( \'id\' => $this->prepareFirstRow($row),  \'cell\' => array(' . "\r\n" . implode(',' . "\r\n",
														    $line) . '));';

	//__var_dump($this->group_rows);

	return $this->extractRows($rows);
    }

    protected function applyFilter($model){

	$filter = array();

	foreach($this->colmodel as $column){

	    if(input_post($column['name'])){
		$filter[$column['name']] = input_post($column['name']);
	    }
	}
	//__var_dump($filter);
	if(count($filter) > 0){
	    $model->addFilter($filter, 'like_after');
	}
    }

    protected function extractRows($rows){

	$_rows = array();
	//__var_dump($this->line);

	$i = 0;

	if(count($rows) > 0){
	    foreach($rows as $row){
		if(!empty($row[$this->model->primary_key])){
		    eval($this->line);

		    $i++;
		}
	    }
	}
	//__var_dump($_rows);
	return $_rows;
    }

    protected function prepareRow($row,
				  $field){

	$result = !isset($row[$field]) ? '&nbsp;' : $row[$field];

	if(isset($this->customformat[$field])){
	    $result = call_user_func_array(array(
		$this->customformat[$field][1],
		$this->customformat[$field][0]),
				    array(
		array(
		    'result' => $result,
		    'row'	 => $row
		),
		false));
	}

	return $result;
    }

    protected function prepareFirstRow($row){
	return $row[$this->key];
    }

    protected function addCustomFormat($data){
	if(isset($data['customformat'])){
	    $this->customformat[$data['name']] = $data['customformat'];
	}
    }

    /**
     * Генерация элементов управления
     *
     * @return
     */
    protected function getToolBarHtml(){
	$html = '<div id="toolbar" class="tableoptions"><div class="action">';

	foreach($this->toolbar_actions as $button){
	    $html .= $button;
	}


	$html .= '</div><div class="buttons">';

	foreach($this->toolbar_buttons as $button => $access){
	    if($access != false){
		switch($button){
		    case 'add':
			$html .= '<button title="table2" onclick="location.href=\'' . adaptive_url(array(
				    'fn' => 'add'
				)) . '\'" class="deletebutton radius3">Добавить</button>';
			break;

		    case 'edit':
			$html .= '<button title="table2" onclick="APL.Grid.location(\'' . $this->url_form . '?id=\')" class="deletebutton radius3">Открыть</button>';
			break;

		    case 'delete':
			$html	 .= '<button title="table2" onclick="APL.Grid.action(\'Необходимо выбрать запись для удаления\',\'Удалить выбранную запись?\',\'' . $this->url_form . '?fn=delete&id=\');" class="deletebutton radius3">Удалить</button>';
			break;
		    default:
			$html	 .= $access;
			break;
		}
		$html .= ' &nbsp;';
	    }
	}

	$html .= '</div></div>';


	return $html;
    }

    function addToolBarButton($id,
			      $p){
	$p['class']			 = 'radius3';
	$this->toolbar_buttons[$id]	 = form_button($p);
    }

    function addToolBarAction($id,
			      $html){
	$this->toolbar_actions[$id] = $html;
    }
}
