<?php

namespace Shop\Infrastructure\Models\Product\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\Position\Map\PositionTableMap;
use Shop\Infrastructure\Models\Product\Product;
use Shop\Infrastructure\Models\Product\ProductQuery;


/**
 * This class defines the structure of the 'shop_products' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class ProductTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.Product.Map.ProductTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_products';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\Product\\Product';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.Product.Product';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 22;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 22;

    /**
     * the column name for the id field
     */
    public const COL_ID = 'shop_products.id';

    /**
     * the column name for the title field
     */
    public const COL_TITLE = 'shop_products.title';

    /**
     * the column name for the desc field
     */
    public const COL_DESC = 'shop_products.desc';

    /**
     * the column name for the short_desc field
     */
    public const COL_SHORT_DESC = 'shop_products.short_desc';

    /**
     * the column name for the article field
     */
    public const COL_ARTICLE = 'shop_products.article';

    /**
     * the column name for the price field
     */
    public const COL_PRICE = 'shop_products.price';

    /**
     * the column name for the weight field
     */
    public const COL_WEIGHT = 'shop_products.weight';

    /**
     * the column name for the img field
     */
    public const COL_IMG = 'shop_products.img';

    /**
     * the column name for the special field
     */
    public const COL_SPECIAL = 'shop_products.special';

    /**
     * the column name for the active field
     */
    public const COL_ACTIVE = 'shop_products.active';

    /**
     * the column name for the mt_title field
     */
    public const COL_MT_TITLE = 'shop_products.mt_title';

    /**
     * the column name for the mt_description field
     */
    public const COL_MT_DESCRIPTION = 'shop_products.mt_description';

    /**
     * the column name for the mt_keywords field
     */
    public const COL_MT_KEYWORDS = 'shop_products.mt_keywords';

    /**
     * the column name for the remains field
     */
    public const COL_REMAINS = 'shop_products.remains';

    /**
     * the column name for the udate field
     */
    public const COL_UDATE = 'shop_products.udate';

    /**
     * the column name for the cdate field
     */
    public const COL_CDATE = 'shop_products.cdate';

    /**
     * the column name for the pdate field
     */
    public const COL_PDATE = 'shop_products.pdate';

    /**
     * the column name for the ref field
     */
    public const COL_REF = 'shop_products.ref';

    /**
     * the column name for the min_quality field
     */
    public const COL_MIN_QUALITY = 'shop_products.min_quality';

    /**
     * the column name for the seazon field
     */
    public const COL_SEAZON = 'shop_products.seazon';

    /**
     * the column name for the category_id field
     */
    public const COL_CATEGORY_ID = 'shop_products.category_id';

    /**
     * the column name for the brand_id field
     */
    public const COL_BRAND_ID = 'shop_products.brand_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Id', 'Title', 'Desc', 'ShortDesc', 'Article', 'Price', 'Weight', 'Img', 'Special', 'Active', 'MtTitle', 'MtDescription', 'MtKeywords', 'Remains', 'dateUpdate', 'dateCreate', 'datePublic', 'Ref', 'MinQuality', 'Seazon', 'CategoryId', 'BrandId', ],
        self::TYPE_CAMELNAME     => ['id', 'title', 'desc', 'shortDesc', 'article', 'price', 'weight', 'img', 'special', 'active', 'mtTitle', 'mtDescription', 'mtKeywords', 'remains', 'dateUpdate', 'dateCreate', 'datePublic', 'ref', 'minQuality', 'seazon', 'categoryId', 'brandId', ],
        self::TYPE_COLNAME       => [ProductTableMap::COL_ID, ProductTableMap::COL_TITLE, ProductTableMap::COL_DESC, ProductTableMap::COL_SHORT_DESC, ProductTableMap::COL_ARTICLE, ProductTableMap::COL_PRICE, ProductTableMap::COL_WEIGHT, ProductTableMap::COL_IMG, ProductTableMap::COL_SPECIAL, ProductTableMap::COL_ACTIVE, ProductTableMap::COL_MT_TITLE, ProductTableMap::COL_MT_DESCRIPTION, ProductTableMap::COL_MT_KEYWORDS, ProductTableMap::COL_REMAINS, ProductTableMap::COL_UDATE, ProductTableMap::COL_CDATE, ProductTableMap::COL_PDATE, ProductTableMap::COL_REF, ProductTableMap::COL_MIN_QUALITY, ProductTableMap::COL_SEAZON, ProductTableMap::COL_CATEGORY_ID, ProductTableMap::COL_BRAND_ID, ],
        self::TYPE_FIELDNAME     => ['id', 'title', 'desc', 'short_desc', 'article', 'price', 'weight', 'img', 'special', 'active', 'mt_title', 'mt_description', 'mt_keywords', 'remains', 'udate', 'cdate', 'pdate', 'ref', 'min_quality', 'seazon', 'category_id', 'brand_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Id' => 0, 'Title' => 1, 'Desc' => 2, 'ShortDesc' => 3, 'Article' => 4, 'Price' => 5, 'Weight' => 6, 'Img' => 7, 'Special' => 8, 'Active' => 9, 'MtTitle' => 10, 'MtDescription' => 11, 'MtKeywords' => 12, 'Remains' => 13, 'dateUpdate' => 14, 'dateCreate' => 15, 'datePublic' => 16, 'Ref' => 17, 'MinQuality' => 18, 'Seazon' => 19, 'CategoryId' => 20, 'BrandId' => 21, ],
        self::TYPE_CAMELNAME     => ['id' => 0, 'title' => 1, 'desc' => 2, 'shortDesc' => 3, 'article' => 4, 'price' => 5, 'weight' => 6, 'img' => 7, 'special' => 8, 'active' => 9, 'mtTitle' => 10, 'mtDescription' => 11, 'mtKeywords' => 12, 'remains' => 13, 'dateUpdate' => 14, 'dateCreate' => 15, 'datePublic' => 16, 'ref' => 17, 'minQuality' => 18, 'seazon' => 19, 'categoryId' => 20, 'brandId' => 21, ],
        self::TYPE_COLNAME       => [ProductTableMap::COL_ID => 0, ProductTableMap::COL_TITLE => 1, ProductTableMap::COL_DESC => 2, ProductTableMap::COL_SHORT_DESC => 3, ProductTableMap::COL_ARTICLE => 4, ProductTableMap::COL_PRICE => 5, ProductTableMap::COL_WEIGHT => 6, ProductTableMap::COL_IMG => 7, ProductTableMap::COL_SPECIAL => 8, ProductTableMap::COL_ACTIVE => 9, ProductTableMap::COL_MT_TITLE => 10, ProductTableMap::COL_MT_DESCRIPTION => 11, ProductTableMap::COL_MT_KEYWORDS => 12, ProductTableMap::COL_REMAINS => 13, ProductTableMap::COL_UDATE => 14, ProductTableMap::COL_CDATE => 15, ProductTableMap::COL_PDATE => 16, ProductTableMap::COL_REF => 17, ProductTableMap::COL_MIN_QUALITY => 18, ProductTableMap::COL_SEAZON => 19, ProductTableMap::COL_CATEGORY_ID => 20, ProductTableMap::COL_BRAND_ID => 21, ],
        self::TYPE_FIELDNAME     => ['id' => 0, 'title' => 1, 'desc' => 2, 'short_desc' => 3, 'article' => 4, 'price' => 5, 'weight' => 6, 'img' => 7, 'special' => 8, 'active' => 9, 'mt_title' => 10, 'mt_description' => 11, 'mt_keywords' => 12, 'remains' => 13, 'udate' => 14, 'cdate' => 15, 'pdate' => 16, 'ref' => 17, 'min_quality' => 18, 'seazon' => 19, 'category_id' => 20, 'brand_id' => 21, ],
        self::TYPE_NUM           => [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Id' => 'ID',
        'Product.Id' => 'ID',
        'id' => 'ID',
        'product.id' => 'ID',
        'ProductTableMap::COL_ID' => 'ID',
        'COL_ID' => 'ID',
        'shop_products.id' => 'ID',
        'Title' => 'TITLE',
        'Product.Title' => 'TITLE',
        'title' => 'TITLE',
        'product.title' => 'TITLE',
        'ProductTableMap::COL_TITLE' => 'TITLE',
        'COL_TITLE' => 'TITLE',
        'shop_products.title' => 'TITLE',
        'Desc' => 'DESC',
        'Product.Desc' => 'DESC',
        'desc' => 'DESC',
        'product.desc' => 'DESC',
        'ProductTableMap::COL_DESC' => 'DESC',
        'COL_DESC' => 'DESC',
        'shop_products.desc' => 'DESC',
        'ShortDesc' => 'SHORT_DESC',
        'Product.ShortDesc' => 'SHORT_DESC',
        'shortDesc' => 'SHORT_DESC',
        'product.shortDesc' => 'SHORT_DESC',
        'ProductTableMap::COL_SHORT_DESC' => 'SHORT_DESC',
        'COL_SHORT_DESC' => 'SHORT_DESC',
        'short_desc' => 'SHORT_DESC',
        'shop_products.short_desc' => 'SHORT_DESC',
        'Article' => 'ARTICLE',
        'Product.Article' => 'ARTICLE',
        'article' => 'ARTICLE',
        'product.article' => 'ARTICLE',
        'ProductTableMap::COL_ARTICLE' => 'ARTICLE',
        'COL_ARTICLE' => 'ARTICLE',
        'shop_products.article' => 'ARTICLE',
        'Price' => 'PRICE',
        'Product.Price' => 'PRICE',
        'price' => 'PRICE',
        'product.price' => 'PRICE',
        'ProductTableMap::COL_PRICE' => 'PRICE',
        'COL_PRICE' => 'PRICE',
        'shop_products.price' => 'PRICE',
        'Weight' => 'WEIGHT',
        'Product.Weight' => 'WEIGHT',
        'weight' => 'WEIGHT',
        'product.weight' => 'WEIGHT',
        'ProductTableMap::COL_WEIGHT' => 'WEIGHT',
        'COL_WEIGHT' => 'WEIGHT',
        'shop_products.weight' => 'WEIGHT',
        'Img' => 'IMG',
        'Product.Img' => 'IMG',
        'img' => 'IMG',
        'product.img' => 'IMG',
        'ProductTableMap::COL_IMG' => 'IMG',
        'COL_IMG' => 'IMG',
        'shop_products.img' => 'IMG',
        'Special' => 'SPECIAL',
        'Product.Special' => 'SPECIAL',
        'special' => 'SPECIAL',
        'product.special' => 'SPECIAL',
        'ProductTableMap::COL_SPECIAL' => 'SPECIAL',
        'COL_SPECIAL' => 'SPECIAL',
        'shop_products.special' => 'SPECIAL',
        'Active' => 'ACTIVE',
        'Product.Active' => 'ACTIVE',
        'active' => 'ACTIVE',
        'product.active' => 'ACTIVE',
        'ProductTableMap::COL_ACTIVE' => 'ACTIVE',
        'COL_ACTIVE' => 'ACTIVE',
        'shop_products.active' => 'ACTIVE',
        'MtTitle' => 'MT_TITLE',
        'Product.MtTitle' => 'MT_TITLE',
        'mtTitle' => 'MT_TITLE',
        'product.mtTitle' => 'MT_TITLE',
        'ProductTableMap::COL_MT_TITLE' => 'MT_TITLE',
        'COL_MT_TITLE' => 'MT_TITLE',
        'mt_title' => 'MT_TITLE',
        'shop_products.mt_title' => 'MT_TITLE',
        'MtDescription' => 'MT_DESCRIPTION',
        'Product.MtDescription' => 'MT_DESCRIPTION',
        'mtDescription' => 'MT_DESCRIPTION',
        'product.mtDescription' => 'MT_DESCRIPTION',
        'ProductTableMap::COL_MT_DESCRIPTION' => 'MT_DESCRIPTION',
        'COL_MT_DESCRIPTION' => 'MT_DESCRIPTION',
        'mt_description' => 'MT_DESCRIPTION',
        'shop_products.mt_description' => 'MT_DESCRIPTION',
        'MtKeywords' => 'MT_KEYWORDS',
        'Product.MtKeywords' => 'MT_KEYWORDS',
        'mtKeywords' => 'MT_KEYWORDS',
        'product.mtKeywords' => 'MT_KEYWORDS',
        'ProductTableMap::COL_MT_KEYWORDS' => 'MT_KEYWORDS',
        'COL_MT_KEYWORDS' => 'MT_KEYWORDS',
        'mt_keywords' => 'MT_KEYWORDS',
        'shop_products.mt_keywords' => 'MT_KEYWORDS',
        'Remains' => 'REMAINS',
        'Product.Remains' => 'REMAINS',
        'remains' => 'REMAINS',
        'product.remains' => 'REMAINS',
        'ProductTableMap::COL_REMAINS' => 'REMAINS',
        'COL_REMAINS' => 'REMAINS',
        'shop_products.remains' => 'REMAINS',
        'dateUpdate' => 'UDATE',
        'Product.dateUpdate' => 'UDATE',
        'product.dateUpdate' => 'UDATE',
        'ProductTableMap::COL_UDATE' => 'UDATE',
        'COL_UDATE' => 'UDATE',
        'udate' => 'UDATE',
        'shop_products.udate' => 'UDATE',
        'dateCreate' => 'CDATE',
        'Product.dateCreate' => 'CDATE',
        'product.dateCreate' => 'CDATE',
        'ProductTableMap::COL_CDATE' => 'CDATE',
        'COL_CDATE' => 'CDATE',
        'cdate' => 'CDATE',
        'shop_products.cdate' => 'CDATE',
        'datePublic' => 'PDATE',
        'Product.datePublic' => 'PDATE',
        'product.datePublic' => 'PDATE',
        'ProductTableMap::COL_PDATE' => 'PDATE',
        'COL_PDATE' => 'PDATE',
        'pdate' => 'PDATE',
        'shop_products.pdate' => 'PDATE',
        'Ref' => 'REF',
        'Product.Ref' => 'REF',
        'ref' => 'REF',
        'product.ref' => 'REF',
        'ProductTableMap::COL_REF' => 'REF',
        'COL_REF' => 'REF',
        'shop_products.ref' => 'REF',
        'MinQuality' => 'MIN_QUALITY',
        'Product.MinQuality' => 'MIN_QUALITY',
        'minQuality' => 'MIN_QUALITY',
        'product.minQuality' => 'MIN_QUALITY',
        'ProductTableMap::COL_MIN_QUALITY' => 'MIN_QUALITY',
        'COL_MIN_QUALITY' => 'MIN_QUALITY',
        'min_quality' => 'MIN_QUALITY',
        'shop_products.min_quality' => 'MIN_QUALITY',
        'Seazon' => 'SEAZON',
        'Product.Seazon' => 'SEAZON',
        'seazon' => 'SEAZON',
        'product.seazon' => 'SEAZON',
        'ProductTableMap::COL_SEAZON' => 'SEAZON',
        'COL_SEAZON' => 'SEAZON',
        'shop_products.seazon' => 'SEAZON',
        'CategoryId' => 'CATEGORY_ID',
        'Product.CategoryId' => 'CATEGORY_ID',
        'categoryId' => 'CATEGORY_ID',
        'product.categoryId' => 'CATEGORY_ID',
        'ProductTableMap::COL_CATEGORY_ID' => 'CATEGORY_ID',
        'COL_CATEGORY_ID' => 'CATEGORY_ID',
        'category_id' => 'CATEGORY_ID',
        'shop_products.category_id' => 'CATEGORY_ID',
        'BrandId' => 'BRAND_ID',
        'Product.BrandId' => 'BRAND_ID',
        'brandId' => 'BRAND_ID',
        'product.brandId' => 'BRAND_ID',
        'ProductTableMap::COL_BRAND_ID' => 'BRAND_ID',
        'COL_BRAND_ID' => 'BRAND_ID',
        'brand_id' => 'BRAND_ID',
        'shop_products.brand_id' => 'BRAND_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_products');
        $this->setPhpName('Product');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\Product\\Product');
        $this->setPackage('Shop.Infrastructure.Models.Product');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('title', 'Title', 'VARCHAR', true, 255, null);
        $this->addColumn('desc', 'Desc', 'LONGVARCHAR', false, null, null);
        $this->addColumn('short_desc', 'ShortDesc', 'VARCHAR', false, 255, null);
        $this->addColumn('article', 'Article', 'VARCHAR', false, 120, null);
        $this->addColumn('price', 'Price', 'DECIMAL', false, 19, null);
        $this->addColumn('weight', 'Weight', 'DECIMAL', false, 19, null);
        $this->addColumn('img', 'Img', 'VARCHAR', false, 255, null);
        $this->addColumn('special', 'Special', 'CHAR', true, null, 'N');
        $this->addColumn('active', 'Active', 'CHAR', true, null, 'Y');
        $this->addColumn('mt_title', 'MtTitle', 'VARCHAR', false, 255, null);
        $this->addColumn('mt_description', 'MtDescription', 'LONGVARCHAR', false, null, null);
        $this->addColumn('mt_keywords', 'MtKeywords', 'LONGVARCHAR', false, null, null);
        $this->addColumn('remains', 'Remains', 'CHAR', false, 5, null);
        $this->addColumn('udate', 'dateUpdate', 'TIMESTAMP', false, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('cdate', 'dateCreate', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('pdate', 'datePublic', 'TIMESTAMP', false, null, null);
        $this->addColumn('ref', 'Ref', 'INTEGER', false, null, null);
        $this->addColumn('min_quality', 'MinQuality', 'VARCHAR', false, 10, null);
        $this->addColumn('seazon', 'Seazon', 'VARCHAR', false, 50, null);
        $this->addForeignKey('category_id', 'CategoryId', 'INTEGER', 'shop_categories', 'id', true, null, null);
        $this->addForeignKey('brand_id', 'BrandId', 'INTEGER', 'shop_brands', 'id', true, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Category', '\\Shop\\Infrastructure\\Models\\Category\\Category', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':category_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Brand', '\\Shop\\Infrastructure\\Models\\Brand\\Brand', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':brand_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('ShopProductGroupsRel', '\\Shop\\Infrastructure\\Models\\ShopProductGroupsRel\\ShopProductGroupsRel', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), null, null, 'ShopProductGroupsRels', false);
        $this->addRelation('Position', '\\Shop\\Infrastructure\\Models\\Position\\Position', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), 'CASCADE', null, 'Positions', false);
        $this->addRelation('ProductHitSale', '\\Shop\\Infrastructure\\Models\\ProductHitSale\\ProductHitSale', RelationMap::ONE_TO_ONE, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('ProductSuperPrice', '\\Shop\\Infrastructure\\Models\\ProductSuperPrice\\ProductSuperPrice', RelationMap::ONE_TO_ONE, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('DraftProduct', '\\Shop\\Infrastructure\\Models\\DraftProduct\\DraftProduct', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':product_id',
    1 => ':id',
  ),
), null, null, 'DraftProducts', false);
        $this->addRelation('ProductGroup', '\\Shop\\Infrastructure\\Models\\ProductGroup\\ProductGroup', RelationMap::MANY_TO_MANY, array(), null, null, 'ProductGroups');
    }

    /**
     * Method to invalidate the instance pool of all tables related to shop_products     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool(): void
    {
        // Invalidate objects in related instance pools,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        PositionTableMap::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? ProductTableMap::CLASS_DEFAULT : ProductTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (Product object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = ProductTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = ProductTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + ProductTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = ProductTableMap::OM_CLASS;
            /** @var Product $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            ProductTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = ProductTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = ProductTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Product $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                ProductTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(ProductTableMap::COL_ID);
            $criteria->addSelectColumn(ProductTableMap::COL_TITLE);
            $criteria->addSelectColumn(ProductTableMap::COL_DESC);
            $criteria->addSelectColumn(ProductTableMap::COL_SHORT_DESC);
            $criteria->addSelectColumn(ProductTableMap::COL_ARTICLE);
            $criteria->addSelectColumn(ProductTableMap::COL_PRICE);
            $criteria->addSelectColumn(ProductTableMap::COL_WEIGHT);
            $criteria->addSelectColumn(ProductTableMap::COL_IMG);
            $criteria->addSelectColumn(ProductTableMap::COL_SPECIAL);
            $criteria->addSelectColumn(ProductTableMap::COL_ACTIVE);
            $criteria->addSelectColumn(ProductTableMap::COL_MT_TITLE);
            $criteria->addSelectColumn(ProductTableMap::COL_MT_DESCRIPTION);
            $criteria->addSelectColumn(ProductTableMap::COL_MT_KEYWORDS);
            $criteria->addSelectColumn(ProductTableMap::COL_REMAINS);
            $criteria->addSelectColumn(ProductTableMap::COL_UDATE);
            $criteria->addSelectColumn(ProductTableMap::COL_CDATE);
            $criteria->addSelectColumn(ProductTableMap::COL_PDATE);
            $criteria->addSelectColumn(ProductTableMap::COL_REF);
            $criteria->addSelectColumn(ProductTableMap::COL_MIN_QUALITY);
            $criteria->addSelectColumn(ProductTableMap::COL_SEAZON);
            $criteria->addSelectColumn(ProductTableMap::COL_CATEGORY_ID);
            $criteria->addSelectColumn(ProductTableMap::COL_BRAND_ID);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.title');
            $criteria->addSelectColumn($alias . '.desc');
            $criteria->addSelectColumn($alias . '.short_desc');
            $criteria->addSelectColumn($alias . '.article');
            $criteria->addSelectColumn($alias . '.price');
            $criteria->addSelectColumn($alias . '.weight');
            $criteria->addSelectColumn($alias . '.img');
            $criteria->addSelectColumn($alias . '.special');
            $criteria->addSelectColumn($alias . '.active');
            $criteria->addSelectColumn($alias . '.mt_title');
            $criteria->addSelectColumn($alias . '.mt_description');
            $criteria->addSelectColumn($alias . '.mt_keywords');
            $criteria->addSelectColumn($alias . '.remains');
            $criteria->addSelectColumn($alias . '.udate');
            $criteria->addSelectColumn($alias . '.cdate');
            $criteria->addSelectColumn($alias . '.pdate');
            $criteria->addSelectColumn($alias . '.ref');
            $criteria->addSelectColumn($alias . '.min_quality');
            $criteria->addSelectColumn($alias . '.seazon');
            $criteria->addSelectColumn($alias . '.category_id');
            $criteria->addSelectColumn($alias . '.brand_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(ProductTableMap::COL_ID);
            $criteria->removeSelectColumn(ProductTableMap::COL_TITLE);
            $criteria->removeSelectColumn(ProductTableMap::COL_DESC);
            $criteria->removeSelectColumn(ProductTableMap::COL_SHORT_DESC);
            $criteria->removeSelectColumn(ProductTableMap::COL_ARTICLE);
            $criteria->removeSelectColumn(ProductTableMap::COL_PRICE);
            $criteria->removeSelectColumn(ProductTableMap::COL_WEIGHT);
            $criteria->removeSelectColumn(ProductTableMap::COL_IMG);
            $criteria->removeSelectColumn(ProductTableMap::COL_SPECIAL);
            $criteria->removeSelectColumn(ProductTableMap::COL_ACTIVE);
            $criteria->removeSelectColumn(ProductTableMap::COL_MT_TITLE);
            $criteria->removeSelectColumn(ProductTableMap::COL_MT_DESCRIPTION);
            $criteria->removeSelectColumn(ProductTableMap::COL_MT_KEYWORDS);
            $criteria->removeSelectColumn(ProductTableMap::COL_REMAINS);
            $criteria->removeSelectColumn(ProductTableMap::COL_UDATE);
            $criteria->removeSelectColumn(ProductTableMap::COL_CDATE);
            $criteria->removeSelectColumn(ProductTableMap::COL_PDATE);
            $criteria->removeSelectColumn(ProductTableMap::COL_REF);
            $criteria->removeSelectColumn(ProductTableMap::COL_MIN_QUALITY);
            $criteria->removeSelectColumn(ProductTableMap::COL_SEAZON);
            $criteria->removeSelectColumn(ProductTableMap::COL_CATEGORY_ID);
            $criteria->removeSelectColumn(ProductTableMap::COL_BRAND_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.id');
            $criteria->removeSelectColumn($alias . '.title');
            $criteria->removeSelectColumn($alias . '.desc');
            $criteria->removeSelectColumn($alias . '.short_desc');
            $criteria->removeSelectColumn($alias . '.article');
            $criteria->removeSelectColumn($alias . '.price');
            $criteria->removeSelectColumn($alias . '.weight');
            $criteria->removeSelectColumn($alias . '.img');
            $criteria->removeSelectColumn($alias . '.special');
            $criteria->removeSelectColumn($alias . '.active');
            $criteria->removeSelectColumn($alias . '.mt_title');
            $criteria->removeSelectColumn($alias . '.mt_description');
            $criteria->removeSelectColumn($alias . '.mt_keywords');
            $criteria->removeSelectColumn($alias . '.remains');
            $criteria->removeSelectColumn($alias . '.udate');
            $criteria->removeSelectColumn($alias . '.cdate');
            $criteria->removeSelectColumn($alias . '.pdate');
            $criteria->removeSelectColumn($alias . '.ref');
            $criteria->removeSelectColumn($alias . '.min_quality');
            $criteria->removeSelectColumn($alias . '.seazon');
            $criteria->removeSelectColumn($alias . '.category_id');
            $criteria->removeSelectColumn($alias . '.brand_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(ProductTableMap::DATABASE_NAME)->getTable(ProductTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a Product or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or Product object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\Product\Product) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(ProductTableMap::DATABASE_NAME);
            $criteria->add(ProductTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = ProductQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            ProductTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                ProductTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_products table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return ProductQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Product or Criteria object.
     *
     * @param mixed $criteria Criteria or Product object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ProductTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Product object
        }


        // Set the correct dbName
        $query = ProductQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
