<?php


namespace Shop\Application\Bonus;

use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Shop\Infrastructure\Repositories\Score\ScoreRepository;

class BonusService
{
    protected $scoreRepository;

    public function __construct(ScoreRepository $scoreRepository)
    {
        $this->scoreRepository = $scoreRepository;
    }

    /**
     * @param CustomerEntityInterface $customer
     * @return float
     */
    public function calculateByCustomer(CustomerEntityInterface $customer): float
    {
        $score = $this->scoreRepository->getSumByCustomerId($customer->getId());
        return $score;
    }
}