<?php


namespace Shop\Presentation\Modules\AdminClientsLite;


use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\Form\Control\MenuItemWindowSelect;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Shop\Presentation\Modules\AdminClients\AdminClients;
use Shop\Presentation\Modules\Traits\FormatterTrait;

class AdminClientsLite extends AdminClients
{
    use FormatterTrait;

    protected function prepareColumns(DataTableEngine $table): void
    {
        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setSorted(true)
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'ФИО'))->setWidth(15, true)
            )
            ->addColumn(
                (new ColumnTable('email', 'E-mail/Логин'))
                    ->setSorted(true)
            )
            ->addColumn(
                (new ColumnTable('phone', 'Телефон'))->setWidth(10, true)
            )
            ->addColumn(
                (new ColumnTable('registred', 'Дата регистрации'))
                    ->setFormat($this, 'formatcDate')
            )
            ->addColumn(
                (new ColumnTable('groupId', 'Группа'))
                    ->setFormat($this, 'formatGroup')
            )
            ->addColumn(
                (new ColumnTable('address', 'Адрес'))
                    ->setFormat($this, 'formatAddress')
            )
            ->addColumn(
                (new ColumnTable('stockId', 'Офис/Менеджер'))
                    ->setFormat($this, 'formatOffice')
            )
            ->addColumn(
                (new ColumnTable('access', 'Доступ'))
                    ->setFormat($this, 'formatAccess')
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(120)
                    ->setFormat($this, 'formatActions')
            );
    }

    public function formatActions(CustomerEntityInterface $customer, array $items = []): string
    {
        $items = [];
        $items[] = new MenuItemWindowSelect($customer->getName(), 'customerId', $customer->getId());
        return parent::formatActions($customer, $items);
    }
}