<?php


namespace Shop\Presentation\Exceptions;


use Throwable;

class ManagerNotSetException extends \Exception
{

    protected $shopId;

    public function __construct(int $shopId)
    {
        $this->shopId = $shopId;
        parent::__construct(sprintf("manager for shop %s, not set", $shopId));
    }

    /**
     * @return int
     */
    public function getShopId(): int
    {
        return $this->shopId;
    }


}