<?php

namespace Shop\Presentation;

use Core\Application\Loader;
use Diamond\Application\Mailing\RecipientsHandlerInterface;
use Shop\Infrastructure\Repositories\Customer\CustomerCriteria;
use Shop\Infrastructure\Repositories\Customer\CustomerRepository;

class CustomersOnlyAuthRecipients implements RecipientsHandlerInterface
{
    public function getName(): string
    {
        return 'Магазин / Авторизованные клиенты';
    }

    public function getMails(): array
    {
        $di = Loader::getInstance()->load('DI');
        /** @var CustomerRepository $userRepository */
        $userRepository = $di->get(CustomerRepository::class);
        $userCollection = $userRepository->findByCriteria(CustomerCriteria::create()->setFilterByOnlyAyth(true));
        $emails = [];
        foreach ($userCollection as $user){
            $emails[] = $user->getEmail();
        }
        return $emails;
    }

}