<?php


namespace Shop\Infrastructure\Repositories\Country;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Country\Contracts\CountryCriteriaInterface;

class CountryCriteria extends AbstractCriteria implements CountryCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $filterByCode;

    /**
     * @var string|null
     */
    protected $searchByName;

    public static function create()
    {
        return new self();
    }

    /**
     * @return string|null
     */
    public function getFilterByCode(): ?string
    {
        return $this->filterByCode;
    }

    /**
     * @param string|null $filterByCode
     * @return CountryCriteria
     */
    public function setFilterByCode(?string $filterByCode): CountryCriteria
    {
        $this->filterByCode = $filterByCode;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return CountryCriteria
     */
    public function setSearchByName(?string $searchByName): CountryCriteria
    {
        $this->searchByName = $searchByName;
        return $this;
    }
}