<?php

namespace Shop\Infrastructure\Models\Customer\Base;

use \DateTime;
use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Propel\Runtime\Util\PropelDateTime;
use Shop\Infrastructure\Models\Basket\Basket;
use Shop\Infrastructure\Models\Basket\BasketQuery;
use Shop\Infrastructure\Models\City\City;
use Shop\Infrastructure\Models\City\CityQuery;
use Shop\Infrastructure\Models\Customer\Customer as ChildCustomer;
use Shop\Infrastructure\Models\Customer\CustomerQuery as ChildCustomerQuery;
use Shop\Infrastructure\Models\CustomerGroup\CustomerGroup;
use Shop\Infrastructure\Models\CustomerGroup\CustomerGroupQuery;
use Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLogin;
use Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLoginQuery;
use Shop\Infrastructure\Models\Customer\Map\CustomerTableMap;
use Shop\Infrastructure\Models\DraftProduct\DraftProduct;
use Shop\Infrastructure\Models\DraftProduct\DraftProductQuery;
use Shop\Infrastructure\Models\DraftProduct\Base\DraftProduct as BaseDraftProduct;
use Shop\Infrastructure\Models\DraftProduct\Map\DraftProductTableMap;
use Shop\Infrastructure\Models\FastLink\FastLink;
use Shop\Infrastructure\Models\FastLink\FastLinkQuery;
use Shop\Infrastructure\Models\FastLink\Base\FastLink as BaseFastLink;
use Shop\Infrastructure\Models\FastLink\Map\FastLinkTableMap;
use Shop\Infrastructure\Models\Manager\Manager;
use Shop\Infrastructure\Models\Manager\ManagerQuery;
use Shop\Infrastructure\Models\Order\Order;
use Shop\Infrastructure\Models\Order\OrderQuery;
use Shop\Infrastructure\Models\Order\Base\Order as BaseOrder;
use Shop\Infrastructure\Models\Order\Map\OrderTableMap;
use Shop\Infrastructure\Models\Provider\Provider;
use Shop\Infrastructure\Models\Provider\ProviderQuery;
use Shop\Infrastructure\Models\Provider\Base\Provider as BaseProvider;
use Shop\Infrastructure\Models\Provider\Map\ProviderTableMap;
use Shop\Infrastructure\Models\Score\Score;
use Shop\Infrastructure\Models\Score\ScoreQuery;
use Shop\Infrastructure\Models\Score\Base\Score as BaseScore;
use Shop\Infrastructure\Models\Score\Map\ScoreTableMap;
use Shop\Infrastructure\Models\Shop\Shop;
use Shop\Infrastructure\Models\Shop\ShopQuery;
use Shop\Infrastructure\Models\Shop\Base\Shop as BaseShop;
use Shop\Infrastructure\Models\Shop\Map\ShopTableMap;

/**
 * Base class that represents a row from the 'shop_customer' table.
 *
 *
 *
 * @package    propel.generator.Shop.Infrastructure.Models.Customer.Base
 */
abstract class Customer implements ActiveRecordInterface
{
    /**
     * TableMap class name
     *
     * @var string
     */
    public const TABLE_MAP = '\\Shop\\Infrastructure\\Models\\Customer\\Map\\CustomerTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var bool
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var bool
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = [];

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = [];

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the name field.
     *
     * @var        string
     */
    protected $name;

    /**
     * The value for the email field.
     *
     * @var        string
     */
    protected $email;

    /**
     * The value for the password field.
     *
     * @var        string|null
     */
    protected $password;

    /**
     * The value for the phone field.
     *
     * @var        string
     */
    protected $phone;

    /**
     * The value for the registred field.
     *
     * Note: this column has a database default value of: (expression) CURRENT_TIMESTAMP
     * @var        DateTime
     */
    protected $registred;

    /**
     * The value for the lastauth field.
     *
     * @var        DateTime|null
     */
    protected $lastauth;

    /**
     * The value for the blocked field.
     *
     * Note: this column has a database default value of: 'N'
     * @var        string|null
     */
    protected $blocked;

    /**
     * The value for the notify_type field.
     *
     * Note: this column has a database default value of: 'sms_email'
     * @var        string|null
     */
    protected $notify_type;

    /**
     * The value for the delete field.
     *
     * Note: this column has a database default value of: 0
     * @var        int|null
     */
    protected $delete;

    /**
     * The value for the discount field.
     *
     * @var        string|null
     */
    protected $discount;

    /**
     * The value for the inn field.
     *
     * @var        string|null
     */
    protected $inn;

    /**
     * The value for the ogrn field.
     *
     * @var        string|null
     */
    protected $ogrn;

    /**
     * The value for the info_hidden field.
     *
     * @var        string|null
     */
    protected $info_hidden;

    /**
     * The value for the group_id field.
     *
     * @var        int
     */
    protected $group_id;

    /**
     * The value for the city_id field.
     *
     * @var        int
     */
    protected $city_id;

    /**
     * The value for the manager_id field.
     *
     * @var        int
     */
    protected $manager_id;

    /**
     * The value for the notify_order field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string|null
     */
    protected $notify_order;

    /**
     * The value for the notify_news field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string|null
     */
    protected $notify_news;

    /**
     * The value for the notify_products field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string|null
     */
    protected $notify_products;

    /**
     * @var        CustomerGroup
     */
    protected $aCustomerGroup;

    /**
     * @var        City
     */
    protected $aCustomerCity;

    /**
     * @var        Manager
     */
    protected $aManager;

    /**
     * @var        CustomerSocialLogin one-to-one related CustomerSocialLogin object
     */
    protected $singleCustomerSocialLogin;

    /**
     * @var        Basket one-to-one related Basket object
     */
    protected $singleBasket;

    /**
     * @var        ObjectCollection|Shop[] Collection to store aggregation of Shop objects.
     * @phpstan-var ObjectCollection&\Traversable<Shop> Collection to store aggregation of Shop objects.
     */
    protected $collShops;
    protected $collShopsPartial;

    /**
     * @var        ObjectCollection|Order[] Collection to store aggregation of Order objects.
     * @phpstan-var ObjectCollection&\Traversable<Order> Collection to store aggregation of Order objects.
     */
    protected $collOrdersRelatedByCustomerId;
    protected $collOrdersRelatedByCustomerIdPartial;

    /**
     * @var        ObjectCollection|Order[] Collection to store aggregation of Order objects.
     * @phpstan-var ObjectCollection&\Traversable<Order> Collection to store aggregation of Order objects.
     */
    protected $collOrdersRelatedByContractorId;
    protected $collOrdersRelatedByContractorIdPartial;

    /**
     * @var        ObjectCollection|FastLink[] Collection to store aggregation of FastLink objects.
     * @phpstan-var ObjectCollection&\Traversable<FastLink> Collection to store aggregation of FastLink objects.
     */
    protected $collFastLinksRelatedByOwnerCustomerId;
    protected $collFastLinksRelatedByOwnerCustomerIdPartial;

    /**
     * @var        FastLink one-to-one related FastLink object
     */
    protected $singleFastLinkRelatedByCode;

    /**
     * @var        ObjectCollection|Provider[] Collection to store aggregation of Provider objects.
     * @phpstan-var ObjectCollection&\Traversable<Provider> Collection to store aggregation of Provider objects.
     */
    protected $collProviders;
    protected $collProvidersPartial;

    /**
     * @var        ObjectCollection|Score[] Collection to store aggregation of Score objects.
     * @phpstan-var ObjectCollection&\Traversable<Score> Collection to store aggregation of Score objects.
     */
    protected $collScores;
    protected $collScoresPartial;

    /**
     * @var        ObjectCollection|DraftProduct[] Collection to store aggregation of DraftProduct objects.
     * @phpstan-var ObjectCollection&\Traversable<DraftProduct> Collection to store aggregation of DraftProduct objects.
     */
    protected $collDraftProducts;
    protected $collDraftProductsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var bool
     */
    protected $alreadyInSave = false;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Shop[]
     * @phpstan-var ObjectCollection&\Traversable<Shop>
     */
    protected $shopsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Order[]
     * @phpstan-var ObjectCollection&\Traversable<Order>
     */
    protected $ordersRelatedByCustomerIdScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Order[]
     * @phpstan-var ObjectCollection&\Traversable<Order>
     */
    protected $ordersRelatedByContractorIdScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|FastLink[]
     * @phpstan-var ObjectCollection&\Traversable<FastLink>
     */
    protected $fastLinksRelatedByOwnerCustomerIdScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Provider[]
     * @phpstan-var ObjectCollection&\Traversable<Provider>
     */
    protected $providersScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Score[]
     * @phpstan-var ObjectCollection&\Traversable<Score>
     */
    protected $scoresScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|DraftProduct[]
     * @phpstan-var ObjectCollection&\Traversable<DraftProduct>
     */
    protected $draftProductsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues(): void
    {
        $this->blocked = 'N';
        $this->notify_type = 'sms_email';
        $this->delete = 0;
        $this->notify_order = 'Y';
        $this->notify_news = 'Y';
        $this->notify_products = 'Y';
    }

    /**
     * Initializes internal state of Shop\Infrastructure\Models\Customer\Base\Customer object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return bool True if the object has been modified.
     */
    public function isModified(): bool
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param string $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return bool True if $col has been modified.
     */
    public function isColumnModified(string $col): bool
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns(): array
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return bool True, if the object has never been persisted.
     */
    public function isNew(): bool
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param bool $b the state of the object.
     */
    public function setNew(bool $b): void
    {
        $this->new = $b;
    }

    /**
     * Whether this object has been deleted.
     * @return bool The deleted state of this object.
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param bool $b The deleted state of this object.
     * @return void
     */
    public function setDeleted(bool $b): void
    {
        $this->deleted = $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified(?string $col = null): void
    {
        if (null !== $col) {
            unset($this->modifiedColumns[$col]);
        } else {
            $this->modifiedColumns = [];
        }
    }

    /**
     * Compares this with another <code>Customer</code> instance.  If
     * <code>obj</code> is an instance of <code>Customer</code>, delegates to
     * <code>equals(Customer)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param mixed $obj The object to compare to.
     * @return bool Whether equal to the object specified.
     */
    public function equals($obj): bool
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns(): array
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return bool
     */
    public function hasVirtualColumn(string $name): bool
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return mixed
     *
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getVirtualColumn(string $name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of nonexistent virtual column `%s`.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @param mixed $value The value to give to the virtual column
     *
     * @return $this The current object, for fluid interface
     */
    public function setVirtualColumn(string $name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param string $msg
     * @param int $priority One of the Propel::LOG_* logging levels
     * @return void
     */
    protected function log(string $msg, int $priority = Propel::LOG_INFO): void
    {
        Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param \Propel\Runtime\Parser\AbstractParser|string $parser An AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME, TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM. Defaults to TableMap::TYPE_PHPNAME.
     * @return string The exported data
     */
    public function exportTo($parser, bool $includeLazyLoadColumns = true, string $keyType = TableMap::TYPE_PHPNAME): string
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray($keyType, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     *
     * @return array<string>
     */
    public function __sleep(): array
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [name] column value.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Get the [email] column value.
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Get the [password] column value.
     *
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Get the [phone] column value.
     *
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * Get the [optionally formatted] temporal [registred] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime Formatted date/time value as string or DateTime object (if format is NULL), and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime : string)
     */
    public function getRegistred($format = null)
    {
        if ($format === null) {
            return $this->registred;
        } else {
            return $this->registred instanceof \DateTimeInterface ? $this->registred->format($format) : null;
        }
    }

    /**
     * Get the [optionally formatted] temporal [lastauth] column value.
     *
     *
     * @param string|null $format The date/time format string (either date()-style or strftime()-style).
     *   If format is NULL, then the raw DateTime object will be returned.
     *
     * @return string|DateTime|null Formatted date/time value as string or DateTime object (if format is NULL), NULL if column is NULL, and 0 if column value is 0000-00-00 00:00:00.
     *
     * @throws \Propel\Runtime\Exception\PropelException - if unable to parse/validate the date/time value.
     *
     * @psalm-return ($format is null ? DateTime|null : string|null)
     */
    public function getLastauth($format = null)
    {
        if ($format === null) {
            return $this->lastauth;
        } else {
            return $this->lastauth instanceof \DateTimeInterface ? $this->lastauth->format($format) : null;
        }
    }

    /**
     * Get the [blocked] column value.
     *
     * @return string|null
     */
    public function getBlocked()
    {
        return $this->blocked;
    }

    /**
     * Get the [notify_type] column value.
     *
     * @return string|null
     */
    public function getNotifyType()
    {
        return $this->notify_type;
    }

    /**
     * Get the [delete] column value.
     *
     * @return int|null
     */
    public function getDelete()
    {
        return $this->delete;
    }

    /**
     * Get the [discount] column value.
     *
     * @return string|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }

    /**
     * Get the [inn] column value.
     *
     * @return string|null
     */
    public function getInn()
    {
        return $this->inn;
    }

    /**
     * Get the [ogrn] column value.
     *
     * @return string|null
     */
    public function getOgrn()
    {
        return $this->ogrn;
    }

    /**
     * Get the [info_hidden] column value.
     *
     * @return string|null
     */
    public function getInfoHidden()
    {
        return $this->info_hidden;
    }

    /**
     * Get the [group_id] column value.
     *
     * @return int
     */
    public function getGroupId()
    {
        return $this->group_id;
    }

    /**
     * Get the [city_id] column value.
     *
     * @return int
     */
    public function getCityId()
    {
        return $this->city_id;
    }

    /**
     * Get the [manager_id] column value.
     *
     * @return int
     */
    public function getManagerId()
    {
        return $this->manager_id;
    }

    /**
     * Get the [notify_order] column value.
     *
     * @return string|null
     */
    public function getNotifyOrder()
    {
        return $this->notify_order;
    }

    /**
     * Get the [notify_news] column value.
     *
     * @return string|null
     */
    public function getNotifyNews()
    {
        return $this->notify_news;
    }

    /**
     * Get the [notify_products] column value.
     *
     * @return string|null
     */
    public function getNotifyProducts()
    {
        return $this->notify_products;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[CustomerTableMap::COL_ID] = true;
        }

        return $this;
    }

    /**
     * Set the value of [name] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setName($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->name !== $v) {
            $this->name = $v;
            $this->modifiedColumns[CustomerTableMap::COL_NAME] = true;
        }

        return $this;
    }

    /**
     * Set the value of [email] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setEmail($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->email !== $v) {
            $this->email = $v;
            $this->modifiedColumns[CustomerTableMap::COL_EMAIL] = true;
        }

        return $this;
    }

    /**
     * Set the value of [password] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setPassword($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->password !== $v) {
            $this->password = $v;
            $this->modifiedColumns[CustomerTableMap::COL_PASSWORD] = true;
        }

        return $this;
    }

    /**
     * Set the value of [phone] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setPhone($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->phone !== $v) {
            $this->phone = $v;
            $this->modifiedColumns[CustomerTableMap::COL_PHONE] = true;
        }

        return $this;
    }

    /**
     * Sets the value of [registred] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setRegistred($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->registred !== null || $dt !== null) {
            if ($this->registred === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->registred->format("Y-m-d H:i:s.u")) {
                $this->registred = $dt === null ? null : clone $dt;
                $this->modifiedColumns[CustomerTableMap::COL_REGISTRED] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Sets the value of [lastauth] column to a normalized version of the date/time value specified.
     *
     * @param string|integer|\DateTimeInterface|null $v string, integer (timestamp), or \DateTimeInterface value.
     *               Empty strings are treated as NULL.
     * @return $this The current object (for fluent API support)
     */
    public function setLastauth($v)
    {
        $dt = PropelDateTime::newInstance($v, null, 'DateTime');
        if ($this->lastauth !== null || $dt !== null) {
            if ($this->lastauth === null || $dt === null || $dt->format("Y-m-d H:i:s.u") !== $this->lastauth->format("Y-m-d H:i:s.u")) {
                $this->lastauth = $dt === null ? null : clone $dt;
                $this->modifiedColumns[CustomerTableMap::COL_LASTAUTH] = true;
            }
        } // if either are not null

        return $this;
    }

    /**
     * Set the value of [blocked] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setBlocked($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->blocked !== $v) {
            $this->blocked = $v;
            $this->modifiedColumns[CustomerTableMap::COL_BLOCKED] = true;
        }

        return $this;
    }

    /**
     * Set the value of [notify_type] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setNotifyType($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notify_type !== $v) {
            $this->notify_type = $v;
            $this->modifiedColumns[CustomerTableMap::COL_NOTIFY_TYPE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [delete] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setDelete($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->delete !== $v) {
            $this->delete = $v;
            $this->modifiedColumns[CustomerTableMap::COL_DELETE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [discount] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setDiscount($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->discount !== $v) {
            $this->discount = $v;
            $this->modifiedColumns[CustomerTableMap::COL_DISCOUNT] = true;
        }

        return $this;
    }

    /**
     * Set the value of [inn] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setInn($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->inn !== $v) {
            $this->inn = $v;
            $this->modifiedColumns[CustomerTableMap::COL_INN] = true;
        }

        return $this;
    }

    /**
     * Set the value of [ogrn] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setOgrn($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->ogrn !== $v) {
            $this->ogrn = $v;
            $this->modifiedColumns[CustomerTableMap::COL_OGRN] = true;
        }

        return $this;
    }

    /**
     * Set the value of [info_hidden] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setInfoHidden($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->info_hidden !== $v) {
            $this->info_hidden = $v;
            $this->modifiedColumns[CustomerTableMap::COL_INFO_HIDDEN] = true;
        }

        return $this;
    }

    /**
     * Set the value of [group_id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setGroupId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->group_id !== $v) {
            $this->group_id = $v;
            $this->modifiedColumns[CustomerTableMap::COL_GROUP_ID] = true;
        }

        if ($this->aCustomerGroup !== null && $this->aCustomerGroup->getId() !== $v) {
            $this->aCustomerGroup = null;
        }

        return $this;
    }

    /**
     * Set the value of [city_id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setCityId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->city_id !== $v) {
            $this->city_id = $v;
            $this->modifiedColumns[CustomerTableMap::COL_CITY_ID] = true;
        }

        if ($this->aCustomerCity !== null && $this->aCustomerCity->getId() !== $v) {
            $this->aCustomerCity = null;
        }

        return $this;
    }

    /**
     * Set the value of [manager_id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setManagerId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->manager_id !== $v) {
            $this->manager_id = $v;
            $this->modifiedColumns[CustomerTableMap::COL_MANAGER_ID] = true;
        }

        if ($this->aManager !== null && $this->aManager->getId() !== $v) {
            $this->aManager = null;
        }

        return $this;
    }

    /**
     * Set the value of [notify_order] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setNotifyOrder($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notify_order !== $v) {
            $this->notify_order = $v;
            $this->modifiedColumns[CustomerTableMap::COL_NOTIFY_ORDER] = true;
        }

        return $this;
    }

    /**
     * Set the value of [notify_news] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setNotifyNews($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notify_news !== $v) {
            $this->notify_news = $v;
            $this->modifiedColumns[CustomerTableMap::COL_NOTIFY_NEWS] = true;
        }

        return $this;
    }

    /**
     * Set the value of [notify_products] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setNotifyProducts($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->notify_products !== $v) {
            $this->notify_products = $v;
            $this->modifiedColumns[CustomerTableMap::COL_NOTIFY_PRODUCTS] = true;
        }

        return $this;
    }

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return bool Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues(): bool
    {
            if ($this->blocked !== 'N') {
                return false;
            }

            if ($this->notify_type !== 'sms_email') {
                return false;
            }

            if ($this->delete !== 0) {
                return false;
            }

            if ($this->notify_order !== 'Y') {
                return false;
            }

            if ($this->notify_news !== 'Y') {
                return false;
            }

            if ($this->notify_products !== 'Y') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    }

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by DataFetcher->fetch().
     * @param int $startcol 0-based offset column which indicates which resultset column to start with.
     * @param bool $rehydrate Whether this object is being re-hydrated from the database.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int next starting column
     * @throws \Propel\Runtime\Exception\PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate(array $row, int $startcol = 0, bool $rehydrate = false, string $indexType = TableMap::TYPE_NUM): int
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : CustomerTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : CustomerTableMap::translateFieldName('Name', TableMap::TYPE_PHPNAME, $indexType)];
            $this->name = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : CustomerTableMap::translateFieldName('Email', TableMap::TYPE_PHPNAME, $indexType)];
            $this->email = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : CustomerTableMap::translateFieldName('Password', TableMap::TYPE_PHPNAME, $indexType)];
            $this->password = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : CustomerTableMap::translateFieldName('Phone', TableMap::TYPE_PHPNAME, $indexType)];
            $this->phone = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : CustomerTableMap::translateFieldName('Registred', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->registred = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : CustomerTableMap::translateFieldName('Lastauth', TableMap::TYPE_PHPNAME, $indexType)];
            if ($col === '0000-00-00 00:00:00') {
                $col = null;
            }
            $this->lastauth = (null !== $col) ? PropelDateTime::newInstance($col, null, 'DateTime') : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : CustomerTableMap::translateFieldName('Blocked', TableMap::TYPE_PHPNAME, $indexType)];
            $this->blocked = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : CustomerTableMap::translateFieldName('NotifyType', TableMap::TYPE_PHPNAME, $indexType)];
            $this->notify_type = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : CustomerTableMap::translateFieldName('Delete', TableMap::TYPE_PHPNAME, $indexType)];
            $this->delete = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : CustomerTableMap::translateFieldName('Discount', TableMap::TYPE_PHPNAME, $indexType)];
            $this->discount = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 11 + $startcol : CustomerTableMap::translateFieldName('Inn', TableMap::TYPE_PHPNAME, $indexType)];
            $this->inn = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 12 + $startcol : CustomerTableMap::translateFieldName('Ogrn', TableMap::TYPE_PHPNAME, $indexType)];
            $this->ogrn = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 13 + $startcol : CustomerTableMap::translateFieldName('InfoHidden', TableMap::TYPE_PHPNAME, $indexType)];
            $this->info_hidden = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 14 + $startcol : CustomerTableMap::translateFieldName('GroupId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->group_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 15 + $startcol : CustomerTableMap::translateFieldName('CityId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->city_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 16 + $startcol : CustomerTableMap::translateFieldName('ManagerId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->manager_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 17 + $startcol : CustomerTableMap::translateFieldName('NotifyOrder', TableMap::TYPE_PHPNAME, $indexType)];
            $this->notify_order = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 18 + $startcol : CustomerTableMap::translateFieldName('NotifyNews', TableMap::TYPE_PHPNAME, $indexType)];
            $this->notify_news = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 19 + $startcol : CustomerTableMap::translateFieldName('NotifyProducts', TableMap::TYPE_PHPNAME, $indexType)];
            $this->notify_products = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 20; // 20 = CustomerTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Shop\\Infrastructure\\Models\\Customer\\Customer'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function ensureConsistency(): void
    {
        if ($this->aCustomerGroup !== null && $this->group_id !== $this->aCustomerGroup->getId()) {
            $this->aCustomerGroup = null;
        }
        if ($this->aCustomerCity !== null && $this->city_id !== $this->aCustomerCity->getId()) {
            $this->aCustomerCity = null;
        }
        if ($this->aManager !== null && $this->manager_id !== $this->aManager->getId()) {
            $this->aManager = null;
        }
    }

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param bool $deep (optional) Whether to also de-associated any related objects.
     * @param ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload(bool $deep = false, ?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(CustomerTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildCustomerQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aCustomerGroup = null;
            $this->aCustomerCity = null;
            $this->aManager = null;
            $this->singleCustomerSocialLogin = null;

            $this->singleBasket = null;

            $this->collShops = null;

            $this->collOrdersRelatedByCustomerId = null;

            $this->collOrdersRelatedByContractorId = null;

            $this->collFastLinksRelatedByOwnerCustomerId = null;

            $this->singleFastLinkRelatedByCode = null;

            $this->collProviders = null;

            $this->collScores = null;

            $this->collDraftProducts = null;

        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param ConnectionInterface $con
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     * @see Customer::setDeleted()
     * @see Customer::isDeleted()
     */
    public function delete(?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildCustomerQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    public function save(?ConnectionInterface $con = null): int
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                CustomerTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con): int
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aCustomerGroup !== null) {
                if ($this->aCustomerGroup->isModified() || $this->aCustomerGroup->isNew()) {
                    $affectedRows += $this->aCustomerGroup->save($con);
                }
                $this->setCustomerGroup($this->aCustomerGroup);
            }

            if ($this->aCustomerCity !== null) {
                if ($this->aCustomerCity->isModified() || $this->aCustomerCity->isNew()) {
                    $affectedRows += $this->aCustomerCity->save($con);
                }
                $this->setCustomerCity($this->aCustomerCity);
            }

            if ($this->aManager !== null) {
                if ($this->aManager->isModified() || $this->aManager->isNew()) {
                    $affectedRows += $this->aManager->save($con);
                }
                $this->setManager($this->aManager);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->singleCustomerSocialLogin !== null) {
                if (!$this->singleCustomerSocialLogin->isDeleted() && ($this->singleCustomerSocialLogin->isNew() || $this->singleCustomerSocialLogin->isModified())) {
                    $affectedRows += $this->singleCustomerSocialLogin->save($con);
                }
            }

            if ($this->singleBasket !== null) {
                if (!$this->singleBasket->isDeleted() && ($this->singleBasket->isNew() || $this->singleBasket->isModified())) {
                    $affectedRows += $this->singleBasket->save($con);
                }
            }

            if ($this->shopsScheduledForDeletion !== null) {
                if (!$this->shopsScheduledForDeletion->isEmpty()) {
                    foreach ($this->shopsScheduledForDeletion as $shop) {
                        // need to save related object because we set the relation to null
                        $shop->save($con);
                    }
                    $this->shopsScheduledForDeletion = null;
                }
            }

            if ($this->collShops !== null) {
                foreach ($this->collShops as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->ordersRelatedByCustomerIdScheduledForDeletion !== null) {
                if (!$this->ordersRelatedByCustomerIdScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\Order\OrderQuery::create()
                        ->filterByPrimaryKeys($this->ordersRelatedByCustomerIdScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->ordersRelatedByCustomerIdScheduledForDeletion = null;
                }
            }

            if ($this->collOrdersRelatedByCustomerId !== null) {
                foreach ($this->collOrdersRelatedByCustomerId as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->ordersRelatedByContractorIdScheduledForDeletion !== null) {
                if (!$this->ordersRelatedByContractorIdScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\Order\OrderQuery::create()
                        ->filterByPrimaryKeys($this->ordersRelatedByContractorIdScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->ordersRelatedByContractorIdScheduledForDeletion = null;
                }
            }

            if ($this->collOrdersRelatedByContractorId !== null) {
                foreach ($this->collOrdersRelatedByContractorId as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion !== null) {
                if (!$this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\FastLink\FastLinkQuery::create()
                        ->filterByPrimaryKeys($this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion = null;
                }
            }

            if ($this->collFastLinksRelatedByOwnerCustomerId !== null) {
                foreach ($this->collFastLinksRelatedByOwnerCustomerId as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->singleFastLinkRelatedByCode !== null) {
                if (!$this->singleFastLinkRelatedByCode->isDeleted() && ($this->singleFastLinkRelatedByCode->isNew() || $this->singleFastLinkRelatedByCode->isModified())) {
                    $affectedRows += $this->singleFastLinkRelatedByCode->save($con);
                }
            }

            if ($this->providersScheduledForDeletion !== null) {
                if (!$this->providersScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\Provider\ProviderQuery::create()
                        ->filterByPrimaryKeys($this->providersScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->providersScheduledForDeletion = null;
                }
            }

            if ($this->collProviders !== null) {
                foreach ($this->collProviders as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->scoresScheduledForDeletion !== null) {
                if (!$this->scoresScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\Score\ScoreQuery::create()
                        ->filterByPrimaryKeys($this->scoresScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->scoresScheduledForDeletion = null;
                }
            }

            if ($this->collScores !== null) {
                foreach ($this->collScores as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->draftProductsScheduledForDeletion !== null) {
                if (!$this->draftProductsScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\DraftProduct\DraftProductQuery::create()
                        ->filterByPrimaryKeys($this->draftProductsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->draftProductsScheduledForDeletion = null;
                }
            }

            if ($this->collDraftProducts !== null) {
                foreach ($this->collDraftProducts as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    }

    /**
     * Insert the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con): void
    {
        $modifiedColumns = [];
        $index = 0;

        $this->modifiedColumns[CustomerTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . CustomerTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(CustomerTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NAME)) {
            $modifiedColumns[':p' . $index++]  = '`name`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_EMAIL)) {
            $modifiedColumns[':p' . $index++]  = '`email`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_PASSWORD)) {
            $modifiedColumns[':p' . $index++]  = '`password`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_PHONE)) {
            $modifiedColumns[':p' . $index++]  = '`phone`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_REGISTRED)) {
            $modifiedColumns[':p' . $index++]  = '`registred`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_LASTAUTH)) {
            $modifiedColumns[':p' . $index++]  = '`lastauth`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_BLOCKED)) {
            $modifiedColumns[':p' . $index++]  = '`blocked`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_TYPE)) {
            $modifiedColumns[':p' . $index++]  = '`notify_type`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_DELETE)) {
            $modifiedColumns[':p' . $index++]  = '`delete`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_DISCOUNT)) {
            $modifiedColumns[':p' . $index++]  = '`discount`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_INN)) {
            $modifiedColumns[':p' . $index++]  = '`inn`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_OGRN)) {
            $modifiedColumns[':p' . $index++]  = '`ogrn`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_INFO_HIDDEN)) {
            $modifiedColumns[':p' . $index++]  = '`info_hidden`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_GROUP_ID)) {
            $modifiedColumns[':p' . $index++]  = '`group_id`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_CITY_ID)) {
            $modifiedColumns[':p' . $index++]  = '`city_id`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_MANAGER_ID)) {
            $modifiedColumns[':p' . $index++]  = '`manager_id`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_ORDER)) {
            $modifiedColumns[':p' . $index++]  = '`notify_order`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_NEWS)) {
            $modifiedColumns[':p' . $index++]  = '`notify_news`';
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_PRODUCTS)) {
            $modifiedColumns[':p' . $index++]  = '`notify_products`';
        }

        $sql = sprintf(
            'INSERT INTO `shop_customer` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`name`':
                        $stmt->bindValue($identifier, $this->name, PDO::PARAM_STR);
                        break;
                    case '`email`':
                        $stmt->bindValue($identifier, $this->email, PDO::PARAM_STR);
                        break;
                    case '`password`':
                        $stmt->bindValue($identifier, $this->password, PDO::PARAM_STR);
                        break;
                    case '`phone`':
                        $stmt->bindValue($identifier, $this->phone, PDO::PARAM_STR);
                        break;
                    case '`registred`':
                        $stmt->bindValue($identifier, $this->registred ? $this->registred->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`lastauth`':
                        $stmt->bindValue($identifier, $this->lastauth ? $this->lastauth->format("Y-m-d H:i:s.u") : null, PDO::PARAM_STR);
                        break;
                    case '`blocked`':
                        $stmt->bindValue($identifier, $this->blocked, PDO::PARAM_STR);
                        break;
                    case '`notify_type`':
                        $stmt->bindValue($identifier, $this->notify_type, PDO::PARAM_STR);
                        break;
                    case '`delete`':
                        $stmt->bindValue($identifier, $this->delete, PDO::PARAM_INT);
                        break;
                    case '`discount`':
                        $stmt->bindValue($identifier, $this->discount, PDO::PARAM_STR);
                        break;
                    case '`inn`':
                        $stmt->bindValue($identifier, $this->inn, PDO::PARAM_STR);
                        break;
                    case '`ogrn`':
                        $stmt->bindValue($identifier, $this->ogrn, PDO::PARAM_STR);
                        break;
                    case '`info_hidden`':
                        $stmt->bindValue($identifier, $this->info_hidden, PDO::PARAM_STR);
                        break;
                    case '`group_id`':
                        $stmt->bindValue($identifier, $this->group_id, PDO::PARAM_INT);
                        break;
                    case '`city_id`':
                        $stmt->bindValue($identifier, $this->city_id, PDO::PARAM_INT);
                        break;
                    case '`manager_id`':
                        $stmt->bindValue($identifier, $this->manager_id, PDO::PARAM_INT);
                        break;
                    case '`notify_order`':
                        $stmt->bindValue($identifier, $this->notify_order, PDO::PARAM_STR);
                        break;
                    case '`notify_news`':
                        $stmt->bindValue($identifier, $this->notify_news, PDO::PARAM_STR);
                        break;
                    case '`notify_products`':
                        $stmt->bindValue($identifier, $this->notify_products, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @return int Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con): int
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName(string $name, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = CustomerTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos Position in XML schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition(int $pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();

            case 1:
                return $this->getName();

            case 2:
                return $this->getEmail();

            case 3:
                return $this->getPassword();

            case 4:
                return $this->getPhone();

            case 5:
                return $this->getRegistred();

            case 6:
                return $this->getLastauth();

            case 7:
                return $this->getBlocked();

            case 8:
                return $this->getNotifyType();

            case 9:
                return $this->getDelete();

            case 10:
                return $this->getDiscount();

            case 11:
                return $this->getInn();

            case 12:
                return $this->getOgrn();

            case 13:
                return $this->getInfoHidden();

            case 14:
                return $this->getGroupId();

            case 15:
                return $this->getCityId();

            case 16:
                return $this->getManagerId();

            case 17:
                return $this->getNotifyOrder();

            case 18:
                return $this->getNotifyNews();

            case 19:
                return $this->getNotifyProducts();

            default:
                return null;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param bool $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array An associative array containing the field names (as keys) and field values
     */
    public function toArray(string $keyType = TableMap::TYPE_PHPNAME, bool $includeLazyLoadColumns = true, array $alreadyDumpedObjects = [], bool $includeForeignObjects = false): array
    {
        if (isset($alreadyDumpedObjects['Customer'][$this->hashCode()])) {
            return ['*RECURSION*'];
        }
        $alreadyDumpedObjects['Customer'][$this->hashCode()] = true;
        $keys = CustomerTableMap::getFieldNames($keyType);
        $result = [
            $keys[0] => $this->getId(),
            $keys[1] => $this->getName(),
            $keys[2] => $this->getEmail(),
            $keys[3] => $this->getPassword(),
            $keys[4] => $this->getPhone(),
            $keys[5] => $this->getRegistred(),
            $keys[6] => $this->getLastauth(),
            $keys[7] => $this->getBlocked(),
            $keys[8] => $this->getNotifyType(),
            $keys[9] => $this->getDelete(),
            $keys[10] => $this->getDiscount(),
            $keys[11] => $this->getInn(),
            $keys[12] => $this->getOgrn(),
            $keys[13] => $this->getInfoHidden(),
            $keys[14] => $this->getGroupId(),
            $keys[15] => $this->getCityId(),
            $keys[16] => $this->getManagerId(),
            $keys[17] => $this->getNotifyOrder(),
            $keys[18] => $this->getNotifyNews(),
            $keys[19] => $this->getNotifyProducts(),
        ];
        if ($result[$keys[5]] instanceof \DateTimeInterface) {
            $result[$keys[5]] = $result[$keys[5]]->format('Y-m-d H:i:s.u');
        }

        if ($result[$keys[6]] instanceof \DateTimeInterface) {
            $result[$keys[6]] = $result[$keys[6]]->format('Y-m-d H:i:s.u');
        }

        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aCustomerGroup) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'customerGroup';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_customer_groups';
                        break;
                    default:
                        $key = 'CustomerGroup';
                }

                $result[$key] = $this->aCustomerGroup->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aCustomerCity) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'city';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_cities';
                        break;
                    default:
                        $key = 'CustomerCity';
                }

                $result[$key] = $this->aCustomerCity->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aManager) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'manager';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_managers';
                        break;
                    default:
                        $key = 'Manager';
                }

                $result[$key] = $this->aManager->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->singleCustomerSocialLogin) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'customerSocialLogin';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_customer_social_logins';
                        break;
                    default:
                        $key = 'CustomerSocialLogin';
                }

                $result[$key] = $this->singleCustomerSocialLogin->toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, true);
            }
            if (null !== $this->singleBasket) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'basket';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_basket';
                        break;
                    default:
                        $key = 'Basket';
                }

                $result[$key] = $this->singleBasket->toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, true);
            }
            if (null !== $this->collShops) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'shops';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_shopss';
                        break;
                    default:
                        $key = 'Shops';
                }

                $result[$key] = $this->collShops->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collOrdersRelatedByCustomerId) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'orders';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_orderss';
                        break;
                    default:
                        $key = 'Orders';
                }

                $result[$key] = $this->collOrdersRelatedByCustomerId->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collOrdersRelatedByContractorId) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'orders';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_orderss';
                        break;
                    default:
                        $key = 'Orders';
                }

                $result[$key] = $this->collOrdersRelatedByContractorId->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collFastLinksRelatedByOwnerCustomerId) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'fastLinks';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_fastlinkss';
                        break;
                    default:
                        $key = 'FastLinks';
                }

                $result[$key] = $this->collFastLinksRelatedByOwnerCustomerId->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->singleFastLinkRelatedByCode) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'fastLink';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_fastlinks';
                        break;
                    default:
                        $key = 'FastLink';
                }

                $result[$key] = $this->singleFastLinkRelatedByCode->toArray($keyType, $includeLazyLoadColumns, $alreadyDumpedObjects, true);
            }
            if (null !== $this->collProviders) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'providers';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_providerss';
                        break;
                    default:
                        $key = 'Providers';
                }

                $result[$key] = $this->collProviders->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collScores) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'scores';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_scoress';
                        break;
                    default:
                        $key = 'Scores';
                }

                $result[$key] = $this->collScores->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collDraftProducts) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'draftProducts';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_product_draftss';
                        break;
                    default:
                        $key = 'DraftProducts';
                }

                $result[$key] = $this->collDraftProducts->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this
     */
    public function setByName(string $name, $value, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = CustomerTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        $this->setByPosition($pos, $value);

        return $this;
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return $this
     */
    public function setByPosition(int $pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setName($value);
                break;
            case 2:
                $this->setEmail($value);
                break;
            case 3:
                $this->setPassword($value);
                break;
            case 4:
                $this->setPhone($value);
                break;
            case 5:
                $this->setRegistred($value);
                break;
            case 6:
                $this->setLastauth($value);
                break;
            case 7:
                $this->setBlocked($value);
                break;
            case 8:
                $this->setNotifyType($value);
                break;
            case 9:
                $this->setDelete($value);
                break;
            case 10:
                $this->setDiscount($value);
                break;
            case 11:
                $this->setInn($value);
                break;
            case 12:
                $this->setOgrn($value);
                break;
            case 13:
                $this->setInfoHidden($value);
                break;
            case 14:
                $this->setGroupId($value);
                break;
            case 15:
                $this->setCityId($value);
                break;
            case 16:
                $this->setManagerId($value);
                break;
            case 17:
                $this->setNotifyOrder($value);
                break;
            case 18:
                $this->setNotifyNews($value);
                break;
            case 19:
                $this->setNotifyProducts($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param array $arr An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return $this
     */
    public function fromArray(array $arr, string $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = CustomerTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setName($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setEmail($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setPassword($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setPhone($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setRegistred($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setLastauth($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setBlocked($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setNotifyType($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setDelete($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setDiscount($arr[$keys[10]]);
        }
        if (array_key_exists($keys[11], $arr)) {
            $this->setInn($arr[$keys[11]]);
        }
        if (array_key_exists($keys[12], $arr)) {
            $this->setOgrn($arr[$keys[12]]);
        }
        if (array_key_exists($keys[13], $arr)) {
            $this->setInfoHidden($arr[$keys[13]]);
        }
        if (array_key_exists($keys[14], $arr)) {
            $this->setGroupId($arr[$keys[14]]);
        }
        if (array_key_exists($keys[15], $arr)) {
            $this->setCityId($arr[$keys[15]]);
        }
        if (array_key_exists($keys[16], $arr)) {
            $this->setManagerId($arr[$keys[16]]);
        }
        if (array_key_exists($keys[17], $arr)) {
            $this->setNotifyOrder($arr[$keys[17]]);
        }
        if (array_key_exists($keys[18], $arr)) {
            $this->setNotifyNews($arr[$keys[18]]);
        }
        if (array_key_exists($keys[19], $arr)) {
            $this->setNotifyProducts($arr[$keys[19]]);
        }

        return $this;
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this The current object, for fluid interface
     */
    public function importFrom($parser, string $data, string $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria(): Criteria
    {
        $criteria = new Criteria(CustomerTableMap::DATABASE_NAME);

        if ($this->isColumnModified(CustomerTableMap::COL_ID)) {
            $criteria->add(CustomerTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NAME)) {
            $criteria->add(CustomerTableMap::COL_NAME, $this->name);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_EMAIL)) {
            $criteria->add(CustomerTableMap::COL_EMAIL, $this->email);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_PASSWORD)) {
            $criteria->add(CustomerTableMap::COL_PASSWORD, $this->password);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_PHONE)) {
            $criteria->add(CustomerTableMap::COL_PHONE, $this->phone);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_REGISTRED)) {
            $criteria->add(CustomerTableMap::COL_REGISTRED, $this->registred);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_LASTAUTH)) {
            $criteria->add(CustomerTableMap::COL_LASTAUTH, $this->lastauth);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_BLOCKED)) {
            $criteria->add(CustomerTableMap::COL_BLOCKED, $this->blocked);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_TYPE)) {
            $criteria->add(CustomerTableMap::COL_NOTIFY_TYPE, $this->notify_type);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_DELETE)) {
            $criteria->add(CustomerTableMap::COL_DELETE, $this->delete);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_DISCOUNT)) {
            $criteria->add(CustomerTableMap::COL_DISCOUNT, $this->discount);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_INN)) {
            $criteria->add(CustomerTableMap::COL_INN, $this->inn);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_OGRN)) {
            $criteria->add(CustomerTableMap::COL_OGRN, $this->ogrn);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_INFO_HIDDEN)) {
            $criteria->add(CustomerTableMap::COL_INFO_HIDDEN, $this->info_hidden);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_GROUP_ID)) {
            $criteria->add(CustomerTableMap::COL_GROUP_ID, $this->group_id);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_CITY_ID)) {
            $criteria->add(CustomerTableMap::COL_CITY_ID, $this->city_id);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_MANAGER_ID)) {
            $criteria->add(CustomerTableMap::COL_MANAGER_ID, $this->manager_id);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_ORDER)) {
            $criteria->add(CustomerTableMap::COL_NOTIFY_ORDER, $this->notify_order);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_NEWS)) {
            $criteria->add(CustomerTableMap::COL_NOTIFY_NEWS, $this->notify_news);
        }
        if ($this->isColumnModified(CustomerTableMap::COL_NOTIFY_PRODUCTS)) {
            $criteria->add(CustomerTableMap::COL_NOTIFY_PRODUCTS, $this->notify_products);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria(): Criteria
    {
        $criteria = ChildCustomerQuery::create();
        $criteria->add(CustomerTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int|string Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param int|null $key Primary key.
     * @return void
     */
    public function setPrimaryKey(?int $key = null): void
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     *
     * @return bool
     */
    public function isPrimaryKeyNull(): bool
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of \Shop\Infrastructure\Models\Customer\Customer (or compatible) type.
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param bool $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function copyInto(object $copyObj, bool $deepCopy = false, bool $makeNew = true): void
    {
        $copyObj->setName($this->getName());
        $copyObj->setEmail($this->getEmail());
        $copyObj->setPassword($this->getPassword());
        $copyObj->setPhone($this->getPhone());
        $copyObj->setRegistred($this->getRegistred());
        $copyObj->setLastauth($this->getLastauth());
        $copyObj->setBlocked($this->getBlocked());
        $copyObj->setNotifyType($this->getNotifyType());
        $copyObj->setDelete($this->getDelete());
        $copyObj->setDiscount($this->getDiscount());
        $copyObj->setInn($this->getInn());
        $copyObj->setOgrn($this->getOgrn());
        $copyObj->setInfoHidden($this->getInfoHidden());
        $copyObj->setGroupId($this->getGroupId());
        $copyObj->setCityId($this->getCityId());
        $copyObj->setManagerId($this->getManagerId());
        $copyObj->setNotifyOrder($this->getNotifyOrder());
        $copyObj->setNotifyNews($this->getNotifyNews());
        $copyObj->setNotifyProducts($this->getNotifyProducts());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            $relObj = $this->getCustomerSocialLogin();
            if ($relObj) {
                $copyObj->setCustomerSocialLogin($relObj->copy($deepCopy));
            }

            $relObj = $this->getBasket();
            if ($relObj) {
                $copyObj->setBasket($relObj->copy($deepCopy));
            }

            foreach ($this->getShops() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addShop($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getOrdersRelatedByCustomerId() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addOrderRelatedByCustomerId($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getOrdersRelatedByContractorId() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addOrderRelatedByContractorId($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getFastLinksRelatedByOwnerCustomerId() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addFastLinkRelatedByOwnerCustomerId($relObj->copy($deepCopy));
                }
            }

            $relObj = $this->getFastLinkRelatedByCode();
            if ($relObj) {
                $copyObj->setFastLinkRelatedByCode($relObj->copy($deepCopy));
            }

            foreach ($this->getProviders() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProvider($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getScores() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addScore($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getDraftProducts() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addDraftProduct($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Shop\Infrastructure\Models\Customer\Customer Clone of current object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function copy(bool $deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a CustomerGroup object.
     *
     * @param CustomerGroup $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setCustomerGroup(CustomerGroup $v = null)
    {
        if ($v === null) {
            $this->setGroupId(NULL);
        } else {
            $this->setGroupId($v->getId());
        }

        $this->aCustomerGroup = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the CustomerGroup object, it will not be re-added.
        if ($v !== null) {
            $v->addCustomer($this);
        }


        return $this;
    }


    /**
     * Get the associated CustomerGroup object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return CustomerGroup The associated CustomerGroup object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getCustomerGroup(?ConnectionInterface $con = null)
    {
        if ($this->aCustomerGroup === null && ($this->group_id != 0)) {
            $this->aCustomerGroup = CustomerGroupQuery::create()->findPk($this->group_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCustomerGroup->addCustomers($this);
             */
        }

        return $this->aCustomerGroup;
    }

    /**
     * Declares an association between this object and a City object.
     *
     * @param City $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setCustomerCity(City $v = null)
    {
        if ($v === null) {
            $this->setCityId(NULL);
        } else {
            $this->setCityId($v->getId());
        }

        $this->aCustomerCity = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the City object, it will not be re-added.
        if ($v !== null) {
            $v->addCustomer($this);
        }


        return $this;
    }


    /**
     * Get the associated City object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return City The associated City object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getCustomerCity(?ConnectionInterface $con = null)
    {
        if ($this->aCustomerCity === null && ($this->city_id != 0)) {
            $this->aCustomerCity = CityQuery::create()->findPk($this->city_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCustomerCity->addCustomers($this);
             */
        }

        return $this->aCustomerCity;
    }

    /**
     * Declares an association between this object and a Manager object.
     *
     * @param Manager $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setManager(Manager $v = null)
    {
        if ($v === null) {
            $this->setManagerId(NULL);
        } else {
            $this->setManagerId($v->getId());
        }

        $this->aManager = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Manager object, it will not be re-added.
        if ($v !== null) {
            $v->addCustomer($this);
        }


        return $this;
    }


    /**
     * Get the associated Manager object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return Manager The associated Manager object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getManager(?ConnectionInterface $con = null)
    {
        if ($this->aManager === null && ($this->manager_id != 0)) {
            $this->aManager = ManagerQuery::create()->findPk($this->manager_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aManager->addCustomers($this);
             */
        }

        return $this->aManager;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName): void
    {
        if ('Shop' === $relationName) {
            $this->initShops();
            return;
        }
        if ('OrderRelatedByCustomerId' === $relationName) {
            $this->initOrdersRelatedByCustomerId();
            return;
        }
        if ('OrderRelatedByContractorId' === $relationName) {
            $this->initOrdersRelatedByContractorId();
            return;
        }
        if ('FastLinkRelatedByOwnerCustomerId' === $relationName) {
            $this->initFastLinksRelatedByOwnerCustomerId();
            return;
        }
        if ('Provider' === $relationName) {
            $this->initProviders();
            return;
        }
        if ('Score' === $relationName) {
            $this->initScores();
            return;
        }
        if ('DraftProduct' === $relationName) {
            $this->initDraftProducts();
            return;
        }
    }

    /**
     * Gets a single CustomerSocialLogin object, which is related to this object by a one-to-one relationship.
     *
     * @param ConnectionInterface $con optional connection object
     * @return CustomerSocialLogin|null
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getCustomerSocialLogin(?ConnectionInterface $con = null)
    {

        if ($this->singleCustomerSocialLogin === null && !$this->isNew()) {
            $this->singleCustomerSocialLogin = CustomerSocialLoginQuery::create()->findPk($this->getPrimaryKey(), $con);
        }

        return $this->singleCustomerSocialLogin;
    }

    /**
     * Sets a single CustomerSocialLogin object as related to this object by a one-to-one relationship.
     *
     * @param CustomerSocialLogin $v CustomerSocialLogin
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setCustomerSocialLogin(CustomerSocialLogin $v = null)
    {
        $this->singleCustomerSocialLogin = $v;

        // Make sure that that the passed-in CustomerSocialLogin isn't already associated with this object
        if ($v !== null && $v->getCustomer(null, false) === null) {
            $v->setCustomer($this);
        }

        return $this;
    }

    /**
     * Gets a single Basket object, which is related to this object by a one-to-one relationship.
     *
     * @param ConnectionInterface $con optional connection object
     * @return Basket|null
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getBasket(?ConnectionInterface $con = null)
    {

        if ($this->singleBasket === null && !$this->isNew()) {
            $this->singleBasket = BasketQuery::create()->findPk($this->getPrimaryKey(), $con);
        }

        return $this->singleBasket;
    }

    /**
     * Sets a single Basket object as related to this object by a one-to-one relationship.
     *
     * @param Basket $v Basket
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setBasket(Basket $v = null)
    {
        $this->singleBasket = $v;

        // Make sure that that the passed-in Basket isn't already associated with this object
        if ($v !== null && $v->getCustomer(null, false) === null) {
            $v->setCustomer($this);
        }

        return $this;
    }

    /**
     * Clears out the collShops collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addShops()
     */
    public function clearShops()
    {
        $this->collShops = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collShops collection loaded partially.
     *
     * @return void
     */
    public function resetPartialShops($v = true): void
    {
        $this->collShopsPartial = $v;
    }

    /**
     * Initializes the collShops collection.
     *
     * By default this just sets the collShops collection to an empty array (like clearcollShops());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initShops(bool $overrideExisting = true): void
    {
        if (null !== $this->collShops && !$overrideExisting) {
            return;
        }

        $collectionClassName = ShopTableMap::getTableMap()->getCollectionClassName();

        $this->collShops = new $collectionClassName;
        $this->collShops->setModel('\Shop\Infrastructure\Models\Shop\Shop');
    }

    /**
     * Gets an array of Shop objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCustomer is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Shop[] List of Shop objects
     * @phpstan-return ObjectCollection&\Traversable<Shop> List of Shop objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getShops(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collShopsPartial && !$this->isNew();
        if (null === $this->collShops || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collShops) {
                    $this->initShops();
                } else {
                    $collectionClassName = ShopTableMap::getTableMap()->getCollectionClassName();

                    $collShops = new $collectionClassName;
                    $collShops->setModel('\Shop\Infrastructure\Models\Shop\Shop');

                    return $collShops;
                }
            } else {
                $collShops = ShopQuery::create(null, $criteria)
                    ->filterByContractor($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collShopsPartial && count($collShops)) {
                        $this->initShops(false);

                        foreach ($collShops as $obj) {
                            if (false == $this->collShops->contains($obj)) {
                                $this->collShops->append($obj);
                            }
                        }

                        $this->collShopsPartial = true;
                    }

                    return $collShops;
                }

                if ($partial && $this->collShops) {
                    foreach ($this->collShops as $obj) {
                        if ($obj->isNew()) {
                            $collShops[] = $obj;
                        }
                    }
                }

                $this->collShops = $collShops;
                $this->collShopsPartial = false;
            }
        }

        return $this->collShops;
    }

    /**
     * Sets a collection of Shop objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $shops A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setShops(Collection $shops, ?ConnectionInterface $con = null)
    {
        /** @var Shop[] $shopsToDelete */
        $shopsToDelete = $this->getShops(new Criteria(), $con)->diff($shops);


        $this->shopsScheduledForDeletion = $shopsToDelete;

        foreach ($shopsToDelete as $shopRemoved) {
            $shopRemoved->setContractor(null);
        }

        $this->collShops = null;
        foreach ($shops as $shop) {
            $this->addShop($shop);
        }

        $this->collShops = $shops;
        $this->collShopsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseShop objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseShop objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countShops(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collShopsPartial && !$this->isNew();
        if (null === $this->collShops || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collShops) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getShops());
            }

            $query = ShopQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByContractor($this)
                ->count($con);
        }

        return count($this->collShops);
    }

    /**
     * Method called to associate a Shop object to this object
     * through the Shop foreign key attribute.
     *
     * @param Shop $l Shop
     * @return $this The current object (for fluent API support)
     */
    public function addShop(Shop $l)
    {
        if ($this->collShops === null) {
            $this->initShops();
            $this->collShopsPartial = true;
        }

        if (!$this->collShops->contains($l)) {
            $this->doAddShop($l);

            if ($this->shopsScheduledForDeletion and $this->shopsScheduledForDeletion->contains($l)) {
                $this->shopsScheduledForDeletion->remove($this->shopsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Shop $shop The Shop object to add.
     */
    protected function doAddShop(Shop $shop): void
    {
        $this->collShops[]= $shop;
        $shop->setContractor($this);
    }

    /**
     * @param Shop $shop The Shop object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeShop(Shop $shop)
    {
        if ($this->getShops()->contains($shop)) {
            $pos = $this->collShops->search($shop);
            $this->collShops->remove($pos);
            if (null === $this->shopsScheduledForDeletion) {
                $this->shopsScheduledForDeletion = clone $this->collShops;
                $this->shopsScheduledForDeletion->clear();
            }
            $this->shopsScheduledForDeletion[]= $shop;
            $shop->setContractor(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related Shops from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Shop[] List of Shop objects
     * @phpstan-return ObjectCollection&\Traversable<Shop}> List of Shop objects
     */
    public function getShopsJoinParentShop(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ShopQuery::create(null, $criteria);
        $query->joinWith('ParentShop', $joinBehavior);

        return $this->getShops($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related Shops from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Shop[] List of Shop objects
     * @phpstan-return ObjectCollection&\Traversable<Shop}> List of Shop objects
     */
    public function getShopsJoinDomain(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ShopQuery::create(null, $criteria);
        $query->joinWith('Domain', $joinBehavior);

        return $this->getShops($query, $con);
    }

    /**
     * Clears out the collOrdersRelatedByCustomerId collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addOrdersRelatedByCustomerId()
     */
    public function clearOrdersRelatedByCustomerId()
    {
        $this->collOrdersRelatedByCustomerId = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collOrdersRelatedByCustomerId collection loaded partially.
     *
     * @return void
     */
    public function resetPartialOrdersRelatedByCustomerId($v = true): void
    {
        $this->collOrdersRelatedByCustomerIdPartial = $v;
    }

    /**
     * Initializes the collOrdersRelatedByCustomerId collection.
     *
     * By default this just sets the collOrdersRelatedByCustomerId collection to an empty array (like clearcollOrdersRelatedByCustomerId());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initOrdersRelatedByCustomerId(bool $overrideExisting = true): void
    {
        if (null !== $this->collOrdersRelatedByCustomerId && !$overrideExisting) {
            return;
        }

        $collectionClassName = OrderTableMap::getTableMap()->getCollectionClassName();

        $this->collOrdersRelatedByCustomerId = new $collectionClassName;
        $this->collOrdersRelatedByCustomerId->setModel('\Shop\Infrastructure\Models\Order\Order');
    }

    /**
     * Gets an array of Order objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCustomer is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Order[] List of Order objects
     * @phpstan-return ObjectCollection&\Traversable<Order> List of Order objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getOrdersRelatedByCustomerId(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collOrdersRelatedByCustomerIdPartial && !$this->isNew();
        if (null === $this->collOrdersRelatedByCustomerId || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collOrdersRelatedByCustomerId) {
                    $this->initOrdersRelatedByCustomerId();
                } else {
                    $collectionClassName = OrderTableMap::getTableMap()->getCollectionClassName();

                    $collOrdersRelatedByCustomerId = new $collectionClassName;
                    $collOrdersRelatedByCustomerId->setModel('\Shop\Infrastructure\Models\Order\Order');

                    return $collOrdersRelatedByCustomerId;
                }
            } else {
                $collOrdersRelatedByCustomerId = OrderQuery::create(null, $criteria)
                    ->filterByCustomer($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collOrdersRelatedByCustomerIdPartial && count($collOrdersRelatedByCustomerId)) {
                        $this->initOrdersRelatedByCustomerId(false);

                        foreach ($collOrdersRelatedByCustomerId as $obj) {
                            if (false == $this->collOrdersRelatedByCustomerId->contains($obj)) {
                                $this->collOrdersRelatedByCustomerId->append($obj);
                            }
                        }

                        $this->collOrdersRelatedByCustomerIdPartial = true;
                    }

                    return $collOrdersRelatedByCustomerId;
                }

                if ($partial && $this->collOrdersRelatedByCustomerId) {
                    foreach ($this->collOrdersRelatedByCustomerId as $obj) {
                        if ($obj->isNew()) {
                            $collOrdersRelatedByCustomerId[] = $obj;
                        }
                    }
                }

                $this->collOrdersRelatedByCustomerId = $collOrdersRelatedByCustomerId;
                $this->collOrdersRelatedByCustomerIdPartial = false;
            }
        }

        return $this->collOrdersRelatedByCustomerId;
    }

    /**
     * Sets a collection of Order objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $ordersRelatedByCustomerId A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setOrdersRelatedByCustomerId(Collection $ordersRelatedByCustomerId, ?ConnectionInterface $con = null)
    {
        /** @var Order[] $ordersRelatedByCustomerIdToDelete */
        $ordersRelatedByCustomerIdToDelete = $this->getOrdersRelatedByCustomerId(new Criteria(), $con)->diff($ordersRelatedByCustomerId);


        $this->ordersRelatedByCustomerIdScheduledForDeletion = $ordersRelatedByCustomerIdToDelete;

        foreach ($ordersRelatedByCustomerIdToDelete as $orderRelatedByCustomerIdRemoved) {
            $orderRelatedByCustomerIdRemoved->setCustomer(null);
        }

        $this->collOrdersRelatedByCustomerId = null;
        foreach ($ordersRelatedByCustomerId as $orderRelatedByCustomerId) {
            $this->addOrderRelatedByCustomerId($orderRelatedByCustomerId);
        }

        $this->collOrdersRelatedByCustomerId = $ordersRelatedByCustomerId;
        $this->collOrdersRelatedByCustomerIdPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseOrder objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseOrder objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countOrdersRelatedByCustomerId(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collOrdersRelatedByCustomerIdPartial && !$this->isNew();
        if (null === $this->collOrdersRelatedByCustomerId || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collOrdersRelatedByCustomerId) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getOrdersRelatedByCustomerId());
            }

            $query = OrderQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByCustomer($this)
                ->count($con);
        }

        return count($this->collOrdersRelatedByCustomerId);
    }

    /**
     * Method called to associate a Order object to this object
     * through the Order foreign key attribute.
     *
     * @param Order $l Order
     * @return $this The current object (for fluent API support)
     */
    public function addOrderRelatedByCustomerId(Order $l)
    {
        if ($this->collOrdersRelatedByCustomerId === null) {
            $this->initOrdersRelatedByCustomerId();
            $this->collOrdersRelatedByCustomerIdPartial = true;
        }

        if (!$this->collOrdersRelatedByCustomerId->contains($l)) {
            $this->doAddOrderRelatedByCustomerId($l);

            if ($this->ordersRelatedByCustomerIdScheduledForDeletion and $this->ordersRelatedByCustomerIdScheduledForDeletion->contains($l)) {
                $this->ordersRelatedByCustomerIdScheduledForDeletion->remove($this->ordersRelatedByCustomerIdScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Order $orderRelatedByCustomerId The Order object to add.
     */
    protected function doAddOrderRelatedByCustomerId(Order $orderRelatedByCustomerId): void
    {
        $this->collOrdersRelatedByCustomerId[]= $orderRelatedByCustomerId;
        $orderRelatedByCustomerId->setCustomer($this);
    }

    /**
     * @param Order $orderRelatedByCustomerId The Order object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeOrderRelatedByCustomerId(Order $orderRelatedByCustomerId)
    {
        if ($this->getOrdersRelatedByCustomerId()->contains($orderRelatedByCustomerId)) {
            $pos = $this->collOrdersRelatedByCustomerId->search($orderRelatedByCustomerId);
            $this->collOrdersRelatedByCustomerId->remove($pos);
            if (null === $this->ordersRelatedByCustomerIdScheduledForDeletion) {
                $this->ordersRelatedByCustomerIdScheduledForDeletion = clone $this->collOrdersRelatedByCustomerId;
                $this->ordersRelatedByCustomerIdScheduledForDeletion->clear();
            }
            $this->ordersRelatedByCustomerIdScheduledForDeletion[]= clone $orderRelatedByCustomerId;
            $orderRelatedByCustomerId->setCustomer(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related OrdersRelatedByCustomerId from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     * @phpstan-return ObjectCollection&\Traversable<Order}> List of Order objects
     */
    public function getOrdersRelatedByCustomerIdJoinType(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Type', $joinBehavior);

        return $this->getOrdersRelatedByCustomerId($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related OrdersRelatedByCustomerId from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     * @phpstan-return ObjectCollection&\Traversable<Order}> List of Order objects
     */
    public function getOrdersRelatedByCustomerIdJoinPayment(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Payment', $joinBehavior);

        return $this->getOrdersRelatedByCustomerId($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related OrdersRelatedByCustomerId from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     * @phpstan-return ObjectCollection&\Traversable<Order}> List of Order objects
     */
    public function getOrdersRelatedByCustomerIdJoinState(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('State', $joinBehavior);

        return $this->getOrdersRelatedByCustomerId($query, $con);
    }

    /**
     * Clears out the collOrdersRelatedByContractorId collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addOrdersRelatedByContractorId()
     */
    public function clearOrdersRelatedByContractorId()
    {
        $this->collOrdersRelatedByContractorId = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collOrdersRelatedByContractorId collection loaded partially.
     *
     * @return void
     */
    public function resetPartialOrdersRelatedByContractorId($v = true): void
    {
        $this->collOrdersRelatedByContractorIdPartial = $v;
    }

    /**
     * Initializes the collOrdersRelatedByContractorId collection.
     *
     * By default this just sets the collOrdersRelatedByContractorId collection to an empty array (like clearcollOrdersRelatedByContractorId());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initOrdersRelatedByContractorId(bool $overrideExisting = true): void
    {
        if (null !== $this->collOrdersRelatedByContractorId && !$overrideExisting) {
            return;
        }

        $collectionClassName = OrderTableMap::getTableMap()->getCollectionClassName();

        $this->collOrdersRelatedByContractorId = new $collectionClassName;
        $this->collOrdersRelatedByContractorId->setModel('\Shop\Infrastructure\Models\Order\Order');
    }

    /**
     * Gets an array of Order objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCustomer is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Order[] List of Order objects
     * @phpstan-return ObjectCollection&\Traversable<Order> List of Order objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getOrdersRelatedByContractorId(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collOrdersRelatedByContractorIdPartial && !$this->isNew();
        if (null === $this->collOrdersRelatedByContractorId || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collOrdersRelatedByContractorId) {
                    $this->initOrdersRelatedByContractorId();
                } else {
                    $collectionClassName = OrderTableMap::getTableMap()->getCollectionClassName();

                    $collOrdersRelatedByContractorId = new $collectionClassName;
                    $collOrdersRelatedByContractorId->setModel('\Shop\Infrastructure\Models\Order\Order');

                    return $collOrdersRelatedByContractorId;
                }
            } else {
                $collOrdersRelatedByContractorId = OrderQuery::create(null, $criteria)
                    ->filterByContractor($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collOrdersRelatedByContractorIdPartial && count($collOrdersRelatedByContractorId)) {
                        $this->initOrdersRelatedByContractorId(false);

                        foreach ($collOrdersRelatedByContractorId as $obj) {
                            if (false == $this->collOrdersRelatedByContractorId->contains($obj)) {
                                $this->collOrdersRelatedByContractorId->append($obj);
                            }
                        }

                        $this->collOrdersRelatedByContractorIdPartial = true;
                    }

                    return $collOrdersRelatedByContractorId;
                }

                if ($partial && $this->collOrdersRelatedByContractorId) {
                    foreach ($this->collOrdersRelatedByContractorId as $obj) {
                        if ($obj->isNew()) {
                            $collOrdersRelatedByContractorId[] = $obj;
                        }
                    }
                }

                $this->collOrdersRelatedByContractorId = $collOrdersRelatedByContractorId;
                $this->collOrdersRelatedByContractorIdPartial = false;
            }
        }

        return $this->collOrdersRelatedByContractorId;
    }

    /**
     * Sets a collection of Order objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $ordersRelatedByContractorId A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setOrdersRelatedByContractorId(Collection $ordersRelatedByContractorId, ?ConnectionInterface $con = null)
    {
        /** @var Order[] $ordersRelatedByContractorIdToDelete */
        $ordersRelatedByContractorIdToDelete = $this->getOrdersRelatedByContractorId(new Criteria(), $con)->diff($ordersRelatedByContractorId);


        $this->ordersRelatedByContractorIdScheduledForDeletion = $ordersRelatedByContractorIdToDelete;

        foreach ($ordersRelatedByContractorIdToDelete as $orderRelatedByContractorIdRemoved) {
            $orderRelatedByContractorIdRemoved->setContractor(null);
        }

        $this->collOrdersRelatedByContractorId = null;
        foreach ($ordersRelatedByContractorId as $orderRelatedByContractorId) {
            $this->addOrderRelatedByContractorId($orderRelatedByContractorId);
        }

        $this->collOrdersRelatedByContractorId = $ordersRelatedByContractorId;
        $this->collOrdersRelatedByContractorIdPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseOrder objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseOrder objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countOrdersRelatedByContractorId(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collOrdersRelatedByContractorIdPartial && !$this->isNew();
        if (null === $this->collOrdersRelatedByContractorId || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collOrdersRelatedByContractorId) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getOrdersRelatedByContractorId());
            }

            $query = OrderQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByContractor($this)
                ->count($con);
        }

        return count($this->collOrdersRelatedByContractorId);
    }

    /**
     * Method called to associate a Order object to this object
     * through the Order foreign key attribute.
     *
     * @param Order $l Order
     * @return $this The current object (for fluent API support)
     */
    public function addOrderRelatedByContractorId(Order $l)
    {
        if ($this->collOrdersRelatedByContractorId === null) {
            $this->initOrdersRelatedByContractorId();
            $this->collOrdersRelatedByContractorIdPartial = true;
        }

        if (!$this->collOrdersRelatedByContractorId->contains($l)) {
            $this->doAddOrderRelatedByContractorId($l);

            if ($this->ordersRelatedByContractorIdScheduledForDeletion and $this->ordersRelatedByContractorIdScheduledForDeletion->contains($l)) {
                $this->ordersRelatedByContractorIdScheduledForDeletion->remove($this->ordersRelatedByContractorIdScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Order $orderRelatedByContractorId The Order object to add.
     */
    protected function doAddOrderRelatedByContractorId(Order $orderRelatedByContractorId): void
    {
        $this->collOrdersRelatedByContractorId[]= $orderRelatedByContractorId;
        $orderRelatedByContractorId->setContractor($this);
    }

    /**
     * @param Order $orderRelatedByContractorId The Order object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeOrderRelatedByContractorId(Order $orderRelatedByContractorId)
    {
        if ($this->getOrdersRelatedByContractorId()->contains($orderRelatedByContractorId)) {
            $pos = $this->collOrdersRelatedByContractorId->search($orderRelatedByContractorId);
            $this->collOrdersRelatedByContractorId->remove($pos);
            if (null === $this->ordersRelatedByContractorIdScheduledForDeletion) {
                $this->ordersRelatedByContractorIdScheduledForDeletion = clone $this->collOrdersRelatedByContractorId;
                $this->ordersRelatedByContractorIdScheduledForDeletion->clear();
            }
            $this->ordersRelatedByContractorIdScheduledForDeletion[]= clone $orderRelatedByContractorId;
            $orderRelatedByContractorId->setContractor(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related OrdersRelatedByContractorId from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     * @phpstan-return ObjectCollection&\Traversable<Order}> List of Order objects
     */
    public function getOrdersRelatedByContractorIdJoinType(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Type', $joinBehavior);

        return $this->getOrdersRelatedByContractorId($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related OrdersRelatedByContractorId from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     * @phpstan-return ObjectCollection&\Traversable<Order}> List of Order objects
     */
    public function getOrdersRelatedByContractorIdJoinPayment(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('Payment', $joinBehavior);

        return $this->getOrdersRelatedByContractorId($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related OrdersRelatedByContractorId from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Order[] List of Order objects
     * @phpstan-return ObjectCollection&\Traversable<Order}> List of Order objects
     */
    public function getOrdersRelatedByContractorIdJoinState(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = OrderQuery::create(null, $criteria);
        $query->joinWith('State', $joinBehavior);

        return $this->getOrdersRelatedByContractorId($query, $con);
    }

    /**
     * Clears out the collFastLinksRelatedByOwnerCustomerId collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addFastLinksRelatedByOwnerCustomerId()
     */
    public function clearFastLinksRelatedByOwnerCustomerId()
    {
        $this->collFastLinksRelatedByOwnerCustomerId = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collFastLinksRelatedByOwnerCustomerId collection loaded partially.
     *
     * @return void
     */
    public function resetPartialFastLinksRelatedByOwnerCustomerId($v = true): void
    {
        $this->collFastLinksRelatedByOwnerCustomerIdPartial = $v;
    }

    /**
     * Initializes the collFastLinksRelatedByOwnerCustomerId collection.
     *
     * By default this just sets the collFastLinksRelatedByOwnerCustomerId collection to an empty array (like clearcollFastLinksRelatedByOwnerCustomerId());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initFastLinksRelatedByOwnerCustomerId(bool $overrideExisting = true): void
    {
        if (null !== $this->collFastLinksRelatedByOwnerCustomerId && !$overrideExisting) {
            return;
        }

        $collectionClassName = FastLinkTableMap::getTableMap()->getCollectionClassName();

        $this->collFastLinksRelatedByOwnerCustomerId = new $collectionClassName;
        $this->collFastLinksRelatedByOwnerCustomerId->setModel('\Shop\Infrastructure\Models\FastLink\FastLink');
    }

    /**
     * Gets an array of FastLink objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCustomer is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|FastLink[] List of FastLink objects
     * @phpstan-return ObjectCollection&\Traversable<FastLink> List of FastLink objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getFastLinksRelatedByOwnerCustomerId(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collFastLinksRelatedByOwnerCustomerIdPartial && !$this->isNew();
        if (null === $this->collFastLinksRelatedByOwnerCustomerId || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collFastLinksRelatedByOwnerCustomerId) {
                    $this->initFastLinksRelatedByOwnerCustomerId();
                } else {
                    $collectionClassName = FastLinkTableMap::getTableMap()->getCollectionClassName();

                    $collFastLinksRelatedByOwnerCustomerId = new $collectionClassName;
                    $collFastLinksRelatedByOwnerCustomerId->setModel('\Shop\Infrastructure\Models\FastLink\FastLink');

                    return $collFastLinksRelatedByOwnerCustomerId;
                }
            } else {
                $collFastLinksRelatedByOwnerCustomerId = FastLinkQuery::create(null, $criteria)
                    ->filterByOwnerCustomer($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collFastLinksRelatedByOwnerCustomerIdPartial && count($collFastLinksRelatedByOwnerCustomerId)) {
                        $this->initFastLinksRelatedByOwnerCustomerId(false);

                        foreach ($collFastLinksRelatedByOwnerCustomerId as $obj) {
                            if (false == $this->collFastLinksRelatedByOwnerCustomerId->contains($obj)) {
                                $this->collFastLinksRelatedByOwnerCustomerId->append($obj);
                            }
                        }

                        $this->collFastLinksRelatedByOwnerCustomerIdPartial = true;
                    }

                    return $collFastLinksRelatedByOwnerCustomerId;
                }

                if ($partial && $this->collFastLinksRelatedByOwnerCustomerId) {
                    foreach ($this->collFastLinksRelatedByOwnerCustomerId as $obj) {
                        if ($obj->isNew()) {
                            $collFastLinksRelatedByOwnerCustomerId[] = $obj;
                        }
                    }
                }

                $this->collFastLinksRelatedByOwnerCustomerId = $collFastLinksRelatedByOwnerCustomerId;
                $this->collFastLinksRelatedByOwnerCustomerIdPartial = false;
            }
        }

        return $this->collFastLinksRelatedByOwnerCustomerId;
    }

    /**
     * Sets a collection of FastLink objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $fastLinksRelatedByOwnerCustomerId A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setFastLinksRelatedByOwnerCustomerId(Collection $fastLinksRelatedByOwnerCustomerId, ?ConnectionInterface $con = null)
    {
        /** @var FastLink[] $fastLinksRelatedByOwnerCustomerIdToDelete */
        $fastLinksRelatedByOwnerCustomerIdToDelete = $this->getFastLinksRelatedByOwnerCustomerId(new Criteria(), $con)->diff($fastLinksRelatedByOwnerCustomerId);


        $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion = $fastLinksRelatedByOwnerCustomerIdToDelete;

        foreach ($fastLinksRelatedByOwnerCustomerIdToDelete as $fastLinkRelatedByOwnerCustomerIdRemoved) {
            $fastLinkRelatedByOwnerCustomerIdRemoved->setOwnerCustomer(null);
        }

        $this->collFastLinksRelatedByOwnerCustomerId = null;
        foreach ($fastLinksRelatedByOwnerCustomerId as $fastLinkRelatedByOwnerCustomerId) {
            $this->addFastLinkRelatedByOwnerCustomerId($fastLinkRelatedByOwnerCustomerId);
        }

        $this->collFastLinksRelatedByOwnerCustomerId = $fastLinksRelatedByOwnerCustomerId;
        $this->collFastLinksRelatedByOwnerCustomerIdPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseFastLink objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseFastLink objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countFastLinksRelatedByOwnerCustomerId(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collFastLinksRelatedByOwnerCustomerIdPartial && !$this->isNew();
        if (null === $this->collFastLinksRelatedByOwnerCustomerId || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collFastLinksRelatedByOwnerCustomerId) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getFastLinksRelatedByOwnerCustomerId());
            }

            $query = FastLinkQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByOwnerCustomer($this)
                ->count($con);
        }

        return count($this->collFastLinksRelatedByOwnerCustomerId);
    }

    /**
     * Method called to associate a FastLink object to this object
     * through the FastLink foreign key attribute.
     *
     * @param FastLink $l FastLink
     * @return $this The current object (for fluent API support)
     */
    public function addFastLinkRelatedByOwnerCustomerId(FastLink $l)
    {
        if ($this->collFastLinksRelatedByOwnerCustomerId === null) {
            $this->initFastLinksRelatedByOwnerCustomerId();
            $this->collFastLinksRelatedByOwnerCustomerIdPartial = true;
        }

        if (!$this->collFastLinksRelatedByOwnerCustomerId->contains($l)) {
            $this->doAddFastLinkRelatedByOwnerCustomerId($l);

            if ($this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion and $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->contains($l)) {
                $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->remove($this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param FastLink $fastLinkRelatedByOwnerCustomerId The FastLink object to add.
     */
    protected function doAddFastLinkRelatedByOwnerCustomerId(FastLink $fastLinkRelatedByOwnerCustomerId): void
    {
        $this->collFastLinksRelatedByOwnerCustomerId[]= $fastLinkRelatedByOwnerCustomerId;
        $fastLinkRelatedByOwnerCustomerId->setOwnerCustomer($this);
    }

    /**
     * @param FastLink $fastLinkRelatedByOwnerCustomerId The FastLink object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeFastLinkRelatedByOwnerCustomerId(FastLink $fastLinkRelatedByOwnerCustomerId)
    {
        if ($this->getFastLinksRelatedByOwnerCustomerId()->contains($fastLinkRelatedByOwnerCustomerId)) {
            $pos = $this->collFastLinksRelatedByOwnerCustomerId->search($fastLinkRelatedByOwnerCustomerId);
            $this->collFastLinksRelatedByOwnerCustomerId->remove($pos);
            if (null === $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion) {
                $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion = clone $this->collFastLinksRelatedByOwnerCustomerId;
                $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion->clear();
            }
            $this->fastLinksRelatedByOwnerCustomerIdScheduledForDeletion[]= clone $fastLinkRelatedByOwnerCustomerId;
            $fastLinkRelatedByOwnerCustomerId->setOwnerCustomer(null);
        }

        return $this;
    }

    /**
     * Gets a single FastLink object, which is related to this object by a one-to-one relationship.
     *
     * @param ConnectionInterface $con optional connection object
     * @return FastLink|null
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getFastLinkRelatedByCode(?ConnectionInterface $con = null)
    {

        if ($this->singleFastLinkRelatedByCode === null && !$this->isNew()) {
            $this->singleFastLinkRelatedByCode = FastLinkQuery::create()->findPk($this->getPrimaryKey(), $con);
        }

        return $this->singleFastLinkRelatedByCode;
    }

    /**
     * Sets a single FastLink object as related to this object by a one-to-one relationship.
     *
     * @param FastLink $v FastLink
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setFastLinkRelatedByCode(FastLink $v = null)
    {
        $this->singleFastLinkRelatedByCode = $v;

        // Make sure that that the passed-in FastLink isn't already associated with this object
        if ($v !== null && $v->getCustomer(null, false) === null) {
            $v->setCustomer($this);
        }

        return $this;
    }

    /**
     * Clears out the collProviders collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addProviders()
     */
    public function clearProviders()
    {
        $this->collProviders = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collProviders collection loaded partially.
     *
     * @return void
     */
    public function resetPartialProviders($v = true): void
    {
        $this->collProvidersPartial = $v;
    }

    /**
     * Initializes the collProviders collection.
     *
     * By default this just sets the collProviders collection to an empty array (like clearcollProviders());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProviders(bool $overrideExisting = true): void
    {
        if (null !== $this->collProviders && !$overrideExisting) {
            return;
        }

        $collectionClassName = ProviderTableMap::getTableMap()->getCollectionClassName();

        $this->collProviders = new $collectionClassName;
        $this->collProviders->setModel('\Shop\Infrastructure\Models\Provider\Provider');
    }

    /**
     * Gets an array of Provider objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCustomer is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Provider[] List of Provider objects
     * @phpstan-return ObjectCollection&\Traversable<Provider> List of Provider objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getProviders(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collProvidersPartial && !$this->isNew();
        if (null === $this->collProviders || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collProviders) {
                    $this->initProviders();
                } else {
                    $collectionClassName = ProviderTableMap::getTableMap()->getCollectionClassName();

                    $collProviders = new $collectionClassName;
                    $collProviders->setModel('\Shop\Infrastructure\Models\Provider\Provider');

                    return $collProviders;
                }
            } else {
                $collProviders = ProviderQuery::create(null, $criteria)
                    ->filterByContractor($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collProvidersPartial && count($collProviders)) {
                        $this->initProviders(false);

                        foreach ($collProviders as $obj) {
                            if (false == $this->collProviders->contains($obj)) {
                                $this->collProviders->append($obj);
                            }
                        }

                        $this->collProvidersPartial = true;
                    }

                    return $collProviders;
                }

                if ($partial && $this->collProviders) {
                    foreach ($this->collProviders as $obj) {
                        if ($obj->isNew()) {
                            $collProviders[] = $obj;
                        }
                    }
                }

                $this->collProviders = $collProviders;
                $this->collProvidersPartial = false;
            }
        }

        return $this->collProviders;
    }

    /**
     * Sets a collection of Provider objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $providers A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setProviders(Collection $providers, ?ConnectionInterface $con = null)
    {
        /** @var Provider[] $providersToDelete */
        $providersToDelete = $this->getProviders(new Criteria(), $con)->diff($providers);


        $this->providersScheduledForDeletion = $providersToDelete;

        foreach ($providersToDelete as $providerRemoved) {
            $providerRemoved->setContractor(null);
        }

        $this->collProviders = null;
        foreach ($providers as $provider) {
            $this->addProvider($provider);
        }

        $this->collProviders = $providers;
        $this->collProvidersPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseProvider objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseProvider objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countProviders(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collProvidersPartial && !$this->isNew();
        if (null === $this->collProviders || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProviders) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getProviders());
            }

            $query = ProviderQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByContractor($this)
                ->count($con);
        }

        return count($this->collProviders);
    }

    /**
     * Method called to associate a Provider object to this object
     * through the Provider foreign key attribute.
     *
     * @param Provider $l Provider
     * @return $this The current object (for fluent API support)
     */
    public function addProvider(Provider $l)
    {
        if ($this->collProviders === null) {
            $this->initProviders();
            $this->collProvidersPartial = true;
        }

        if (!$this->collProviders->contains($l)) {
            $this->doAddProvider($l);

            if ($this->providersScheduledForDeletion and $this->providersScheduledForDeletion->contains($l)) {
                $this->providersScheduledForDeletion->remove($this->providersScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Provider $provider The Provider object to add.
     */
    protected function doAddProvider(Provider $provider): void
    {
        $this->collProviders[]= $provider;
        $provider->setContractor($this);
    }

    /**
     * @param Provider $provider The Provider object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeProvider(Provider $provider)
    {
        if ($this->getProviders()->contains($provider)) {
            $pos = $this->collProviders->search($provider);
            $this->collProviders->remove($pos);
            if (null === $this->providersScheduledForDeletion) {
                $this->providersScheduledForDeletion = clone $this->collProviders;
                $this->providersScheduledForDeletion->clear();
            }
            $this->providersScheduledForDeletion[]= clone $provider;
            $provider->setContractor(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related Providers from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Provider[] List of Provider objects
     * @phpstan-return ObjectCollection&\Traversable<Provider}> List of Provider objects
     */
    public function getProvidersJoinCurrency(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ProviderQuery::create(null, $criteria);
        $query->joinWith('Currency', $joinBehavior);

        return $this->getProviders($query, $con);
    }

    /**
     * Clears out the collScores collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addScores()
     */
    public function clearScores()
    {
        $this->collScores = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collScores collection loaded partially.
     *
     * @return void
     */
    public function resetPartialScores($v = true): void
    {
        $this->collScoresPartial = $v;
    }

    /**
     * Initializes the collScores collection.
     *
     * By default this just sets the collScores collection to an empty array (like clearcollScores());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initScores(bool $overrideExisting = true): void
    {
        if (null !== $this->collScores && !$overrideExisting) {
            return;
        }

        $collectionClassName = ScoreTableMap::getTableMap()->getCollectionClassName();

        $this->collScores = new $collectionClassName;
        $this->collScores->setModel('\Shop\Infrastructure\Models\Score\Score');
    }

    /**
     * Gets an array of Score objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCustomer is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Score[] List of Score objects
     * @phpstan-return ObjectCollection&\Traversable<Score> List of Score objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getScores(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collScoresPartial && !$this->isNew();
        if (null === $this->collScores || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collScores) {
                    $this->initScores();
                } else {
                    $collectionClassName = ScoreTableMap::getTableMap()->getCollectionClassName();

                    $collScores = new $collectionClassName;
                    $collScores->setModel('\Shop\Infrastructure\Models\Score\Score');

                    return $collScores;
                }
            } else {
                $collScores = ScoreQuery::create(null, $criteria)
                    ->filterByCustomer($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collScoresPartial && count($collScores)) {
                        $this->initScores(false);

                        foreach ($collScores as $obj) {
                            if (false == $this->collScores->contains($obj)) {
                                $this->collScores->append($obj);
                            }
                        }

                        $this->collScoresPartial = true;
                    }

                    return $collScores;
                }

                if ($partial && $this->collScores) {
                    foreach ($this->collScores as $obj) {
                        if ($obj->isNew()) {
                            $collScores[] = $obj;
                        }
                    }
                }

                $this->collScores = $collScores;
                $this->collScoresPartial = false;
            }
        }

        return $this->collScores;
    }

    /**
     * Sets a collection of Score objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $scores A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setScores(Collection $scores, ?ConnectionInterface $con = null)
    {
        /** @var Score[] $scoresToDelete */
        $scoresToDelete = $this->getScores(new Criteria(), $con)->diff($scores);


        //since at least one column in the foreign key is at the same time a PK
        //we can not just set a PK to NULL in the lines below. We have to store
        //a backup of all values, so we are able to manipulate these items based on the onDelete value later.
        $this->scoresScheduledForDeletion = clone $scoresToDelete;

        foreach ($scoresToDelete as $scoreRemoved) {
            $scoreRemoved->setCustomer(null);
        }

        $this->collScores = null;
        foreach ($scores as $score) {
            $this->addScore($score);
        }

        $this->collScores = $scores;
        $this->collScoresPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseScore objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseScore objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countScores(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collScoresPartial && !$this->isNew();
        if (null === $this->collScores || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collScores) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getScores());
            }

            $query = ScoreQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByCustomer($this)
                ->count($con);
        }

        return count($this->collScores);
    }

    /**
     * Method called to associate a Score object to this object
     * through the Score foreign key attribute.
     *
     * @param Score $l Score
     * @return $this The current object (for fluent API support)
     */
    public function addScore(Score $l)
    {
        if ($this->collScores === null) {
            $this->initScores();
            $this->collScoresPartial = true;
        }

        if (!$this->collScores->contains($l)) {
            $this->doAddScore($l);

            if ($this->scoresScheduledForDeletion and $this->scoresScheduledForDeletion->contains($l)) {
                $this->scoresScheduledForDeletion->remove($this->scoresScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Score $score The Score object to add.
     */
    protected function doAddScore(Score $score): void
    {
        $this->collScores[]= $score;
        $score->setCustomer($this);
    }

    /**
     * @param Score $score The Score object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeScore(Score $score)
    {
        if ($this->getScores()->contains($score)) {
            $pos = $this->collScores->search($score);
            $this->collScores->remove($pos);
            if (null === $this->scoresScheduledForDeletion) {
                $this->scoresScheduledForDeletion = clone $this->collScores;
                $this->scoresScheduledForDeletion->clear();
            }
            $this->scoresScheduledForDeletion[]= clone $score;
            $score->setCustomer(null);
        }

        return $this;
    }

    /**
     * Clears out the collDraftProducts collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addDraftProducts()
     */
    public function clearDraftProducts()
    {
        $this->collDraftProducts = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collDraftProducts collection loaded partially.
     *
     * @return void
     */
    public function resetPartialDraftProducts($v = true): void
    {
        $this->collDraftProductsPartial = $v;
    }

    /**
     * Initializes the collDraftProducts collection.
     *
     * By default this just sets the collDraftProducts collection to an empty array (like clearcollDraftProducts());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initDraftProducts(bool $overrideExisting = true): void
    {
        if (null !== $this->collDraftProducts && !$overrideExisting) {
            return;
        }

        $collectionClassName = DraftProductTableMap::getTableMap()->getCollectionClassName();

        $this->collDraftProducts = new $collectionClassName;
        $this->collDraftProducts->setModel('\Shop\Infrastructure\Models\DraftProduct\DraftProduct');
    }

    /**
     * Gets an array of DraftProduct objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCustomer is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct> List of DraftProduct objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getDraftProducts(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collDraftProductsPartial && !$this->isNew();
        if (null === $this->collDraftProducts || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collDraftProducts) {
                    $this->initDraftProducts();
                } else {
                    $collectionClassName = DraftProductTableMap::getTableMap()->getCollectionClassName();

                    $collDraftProducts = new $collectionClassName;
                    $collDraftProducts->setModel('\Shop\Infrastructure\Models\DraftProduct\DraftProduct');

                    return $collDraftProducts;
                }
            } else {
                $collDraftProducts = DraftProductQuery::create(null, $criteria)
                    ->filterByCustomer($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collDraftProductsPartial && count($collDraftProducts)) {
                        $this->initDraftProducts(false);

                        foreach ($collDraftProducts as $obj) {
                            if (false == $this->collDraftProducts->contains($obj)) {
                                $this->collDraftProducts->append($obj);
                            }
                        }

                        $this->collDraftProductsPartial = true;
                    }

                    return $collDraftProducts;
                }

                if ($partial && $this->collDraftProducts) {
                    foreach ($this->collDraftProducts as $obj) {
                        if ($obj->isNew()) {
                            $collDraftProducts[] = $obj;
                        }
                    }
                }

                $this->collDraftProducts = $collDraftProducts;
                $this->collDraftProductsPartial = false;
            }
        }

        return $this->collDraftProducts;
    }

    /**
     * Sets a collection of DraftProduct objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $draftProducts A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setDraftProducts(Collection $draftProducts, ?ConnectionInterface $con = null)
    {
        /** @var DraftProduct[] $draftProductsToDelete */
        $draftProductsToDelete = $this->getDraftProducts(new Criteria(), $con)->diff($draftProducts);


        $this->draftProductsScheduledForDeletion = $draftProductsToDelete;

        foreach ($draftProductsToDelete as $draftProductRemoved) {
            $draftProductRemoved->setCustomer(null);
        }

        $this->collDraftProducts = null;
        foreach ($draftProducts as $draftProduct) {
            $this->addDraftProduct($draftProduct);
        }

        $this->collDraftProducts = $draftProducts;
        $this->collDraftProductsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseDraftProduct objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseDraftProduct objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countDraftProducts(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collDraftProductsPartial && !$this->isNew();
        if (null === $this->collDraftProducts || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collDraftProducts) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getDraftProducts());
            }

            $query = DraftProductQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByCustomer($this)
                ->count($con);
        }

        return count($this->collDraftProducts);
    }

    /**
     * Method called to associate a DraftProduct object to this object
     * through the DraftProduct foreign key attribute.
     *
     * @param DraftProduct $l DraftProduct
     * @return $this The current object (for fluent API support)
     */
    public function addDraftProduct(DraftProduct $l)
    {
        if ($this->collDraftProducts === null) {
            $this->initDraftProducts();
            $this->collDraftProductsPartial = true;
        }

        if (!$this->collDraftProducts->contains($l)) {
            $this->doAddDraftProduct($l);

            if ($this->draftProductsScheduledForDeletion and $this->draftProductsScheduledForDeletion->contains($l)) {
                $this->draftProductsScheduledForDeletion->remove($this->draftProductsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param DraftProduct $draftProduct The DraftProduct object to add.
     */
    protected function doAddDraftProduct(DraftProduct $draftProduct): void
    {
        $this->collDraftProducts[]= $draftProduct;
        $draftProduct->setCustomer($this);
    }

    /**
     * @param DraftProduct $draftProduct The DraftProduct object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeDraftProduct(DraftProduct $draftProduct)
    {
        if ($this->getDraftProducts()->contains($draftProduct)) {
            $pos = $this->collDraftProducts->search($draftProduct);
            $this->collDraftProducts->remove($pos);
            if (null === $this->draftProductsScheduledForDeletion) {
                $this->draftProductsScheduledForDeletion = clone $this->collDraftProducts;
                $this->draftProductsScheduledForDeletion->clear();
            }
            $this->draftProductsScheduledForDeletion[]= clone $draftProduct;
            $draftProduct->setCustomer(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct}> List of DraftProduct objects
     */
    public function getDraftProductsJoinProduct(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Product', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct}> List of DraftProduct objects
     */
    public function getDraftProductsJoinCategory(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Category', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Customer is new, it will return
     * an empty collection; or if this Customer has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Customer.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct}> List of DraftProduct objects
     */
    public function getDraftProductsJoinBrand(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Brand', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     *
     * @return $this
     */
    public function clear()
    {
        if (null !== $this->aCustomerGroup) {
            $this->aCustomerGroup->removeCustomer($this);
        }
        if (null !== $this->aCustomerCity) {
            $this->aCustomerCity->removeCustomer($this);
        }
        if (null !== $this->aManager) {
            $this->aManager->removeCustomer($this);
        }
        $this->id = null;
        $this->name = null;
        $this->email = null;
        $this->password = null;
        $this->phone = null;
        $this->registred = null;
        $this->lastauth = null;
        $this->blocked = null;
        $this->notify_type = null;
        $this->delete = null;
        $this->discount = null;
        $this->inn = null;
        $this->ogrn = null;
        $this->info_hidden = null;
        $this->group_id = null;
        $this->city_id = null;
        $this->manager_id = null;
        $this->notify_order = null;
        $this->notify_news = null;
        $this->notify_products = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);

        return $this;
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param bool $deep Whether to also clear the references on all referrer objects.
     * @return $this
     */
    public function clearAllReferences(bool $deep = false)
    {
        if ($deep) {
            if ($this->singleCustomerSocialLogin) {
                $this->singleCustomerSocialLogin->clearAllReferences($deep);
            }
            if ($this->singleBasket) {
                $this->singleBasket->clearAllReferences($deep);
            }
            if ($this->collShops) {
                foreach ($this->collShops as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collOrdersRelatedByCustomerId) {
                foreach ($this->collOrdersRelatedByCustomerId as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collOrdersRelatedByContractorId) {
                foreach ($this->collOrdersRelatedByContractorId as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collFastLinksRelatedByOwnerCustomerId) {
                foreach ($this->collFastLinksRelatedByOwnerCustomerId as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->singleFastLinkRelatedByCode) {
                $this->singleFastLinkRelatedByCode->clearAllReferences($deep);
            }
            if ($this->collProviders) {
                foreach ($this->collProviders as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collScores) {
                foreach ($this->collScores as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDraftProducts) {
                foreach ($this->collDraftProducts as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->singleCustomerSocialLogin = null;
        $this->singleBasket = null;
        $this->collShops = null;
        $this->collOrdersRelatedByCustomerId = null;
        $this->collOrdersRelatedByContractorId = null;
        $this->collFastLinksRelatedByOwnerCustomerId = null;
        $this->singleFastLinkRelatedByCode = null;
        $this->collProviders = null;
        $this->collScores = null;
        $this->collDraftProducts = null;
        $this->aCustomerGroup = null;
        $this->aCustomerCity = null;
        $this->aManager = null;
        return $this;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(CustomerTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preSave(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postSave(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before inserting to database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preInsert(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postInsert(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preUpdate(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postUpdate(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preDelete(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postDelete(?ConnectionInterface $con = null): void
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);
            $inputData = $params[0];
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->importFrom($format, $inputData, $keyType);
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = $params[0] ?? true;
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->exportTo($format, $includeLazyLoadColumns, $keyType);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
