<?php


namespace Shop\Application\Shopping\ResetOrderState;


use Shop\Domain\OrderItem\Contracts\OrderItemEntityInterface;

/**
 * Class ResetOrderStateCommand
 * @package Shop\Application\Shopping\ResetOrderState
 */
class ResetOrderStateCommand
{

    /**
     * @var OrderItemEntityInterface
     */
    protected $orderItemEntity;

    /**
     * ResetOrderStateCommand constructor.
     * @param OrderItemEntityInterface $orderItemEntity
     */
    public function __construct(OrderItemEntityInterface $orderItemEntity)
    {
        $this->orderItemEntity = $orderItemEntity;
    }

    /**
     * @return OrderItemEntityInterface
     */
    public function getOrderItemEntity(): OrderItemEntityInterface
    {
        return $this->orderItemEntity;
    }

}