<?php


namespace Shop\Application\Shopping\Dto;


class OrderRequest
{
    /**
     * @var string|null
     */
    protected $deliveryAddress;


    /**
     * @var int
     */
    protected $paymentId;

    /**
     * @var string|null
     */
    protected $comment;


    /**
     * @var array
     */
    protected $items = [];

    /**
     * @var float|null
     *
     */
    protected $discount;

    /**
     * @var int
     */
    protected $clientId;

    /**
     * @var int
     */
    protected $contractorId;

    /**
     * @return int
     */
    public function getClientId(): int
    {
        return $this->clientId;
    }

    /**
     * @param int $clientId
     * @return OrderRequest
     */
    public function setClientId(int $clientId): OrderRequest
    {
        $this->clientId = $clientId;
        return $this;
    }

    /**
     * @return int
     */
    public function getContractorId(): int
    {
        return $this->contractorId;
    }

    /**
     * @param int $contractorId
     * @return OrderRequest
     */
    public function setContractorId(int $contractorId): OrderRequest
    {
        $this->contractorId = $contractorId;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getDeliveryAddress(): ?string
    {
        return $this->deliveryAddress;
    }

    /**
     * @param string|null $deliveryAddress
     * @return OrderRequest
     */
    public function setDeliveryAddress(?string $deliveryAddress): OrderRequest
    {
        $this->deliveryAddress = $deliveryAddress;
        return $this;
    }

    /**
     * @return int
     */
    public function getPaymentId(): int
    {
        return $this->paymentId;
    }

    /**
     * @param int $paymentId
     * @return OrderRequest
     */
    public function setPaymentId(int $paymentId): OrderRequest
    {
        $this->paymentId = $paymentId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getComment(): ?string
    {
        return $this->comment;
    }

    /**
     * @param string|null $comment
     * @return OrderRequest
     */
    public function setComment(?string $comment): OrderRequest
    {
        $this->comment = $comment;
        return $this;
    }




    /**
     * @return array
     */
    public function getItems(): array
    {
        return $this->items;
    }

    /**
     * @param array $items
     * @return OrderRequest
     */
    public function setItems(array $items): OrderRequest
    {
        $this->items = $items;
        return $this;
    }

    /**
     * @return float|null
     */
    public function getDiscount(): ?float
    {
        return $this->discount;
    }

    /**
     * @param float|null $discount
     * @return OrderRequest
     */
    public function setDiscount(?float $discount): OrderRequest
    {
        $this->discount = $discount;
        return $this;
    }


}