<?php


namespace Shop\Infrastructure\Repositories\ProviderOrder;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\ProviderOrder\Contracts\ProviderOrderCriteriaInterface;

class ProviderOrderCriteria extends AbstractCriteria implements ProviderOrderCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $filterByOrderCode;

    /**
     * @var string|null
     */
    protected $sortById;

    /**
     * @var int|null
     */
    protected $filterByStateId;

    public static function create()
    {
        return new self();
    }

    /**
     * @return string|null
     */
    public function getFilterByOrderCode(): ?string
    {
        return $this->filterByOrderCode;
    }

    /**
     * @param string|null $filterByOrderCode
     * @return ProviderOrderCriteria
     */
    public function setFilterByOrderCode(?string $filterByOrderCode): ProviderOrderCriteria
    {
        $this->filterByOrderCode = $filterByOrderCode;
        return $this;
    }



    /**
     * @return string|null
     */
    public function getSortById(): ?string
    {
        return $this->sortById;
    }

    /**
     * @param string|null $sortById
     * @return CustomerOrderCriteria
     */
    public function setSortById(?string $sortById): AbstractCriteria
    {
        $this->sortById = $sortById;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByStateId(): ?int
    {
        return $this->filterByStateId;
    }

    /**
     * @param int|null $filterByStateId
     * @return CustomerOrderCriteria
     */
    public function setFilterByStateId(?int $filterByStateId): CustomerOrderCriteria
    {
        $this->filterByStateId = $filterByStateId;
        return $this;
    }
}