<?php


namespace Shop\Infrastructure\Repositories\PaymentTransaction;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\PaymentTransaction\Contracts\PaymentTransactionCriteriaInterface;
use Shop\Domain\PaymentTransaction\PaymentTransactionCollection;
use Shop\Infrastructure\Models\PaymentTransaction\PaymentTransaction;
use Shop\Infrastructure\Models\PaymentTransaction\PaymentTransactionQuery;

class PaymentTransactionRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    public static function createEntity(): EntityInterface
    {
        return new PaymentTransaction();
    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return PaymentTransactionQuery::create();
    }

    /**
     * @param PaginationInterface $criteria
     * @param ModelCriteria $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $dbCriteria
            ->_if($criteria->getFilterByCode() !== null)
            ->filterByCode($criteria->getFilterByCode())
            ->_endif()
            ->_if($criteria->getFilterByOrderId()!==null)
            ->filterByOrderId($criteria->getFilterByOrderId())
            ->_endif()
        ;
    }

    protected function createCollection(): CollectionInterface
    {
        return new PaymentTransactionCollection();
    }
}