<?php

namespace Shop\Infrastructure\Models\CustomerSocialLogin\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLogin;
use Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLoginQuery;


/**
 * This class defines the structure of the 'shop_customer_social_logins' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class CustomerSocialLoginTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    public const CLASS_NAME = 'Shop.Infrastructure.Models.CustomerSocialLogin.Map.CustomerSocialLoginTableMap';

    /**
     * The default database name for this class
     */
    public const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    public const TABLE_NAME = 'shop_customer_social_logins';

    /**
     * The related Propel class for this table
     */
    public const OM_CLASS = '\\Shop\\Infrastructure\\Models\\CustomerSocialLogin\\CustomerSocialLogin';

    /**
     * A class that can be returned by this tableMap
     */
    public const CLASS_DEFAULT = 'Shop.Infrastructure.Models.CustomerSocialLogin.CustomerSocialLogin';

    /**
     * The total number of columns
     */
    public const NUM_COLUMNS = 4;

    /**
     * The number of lazy-loaded columns
     */
    public const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    public const NUM_HYDRATE_COLUMNS = 4;

    /**
     * the column name for the login field
     */
    public const COL_LOGIN = 'shop_customer_social_logins.login';

    /**
     * the column name for the provider field
     */
    public const COL_PROVIDER = 'shop_customer_social_logins.provider';

    /**
     * the column name for the info field
     */
    public const COL_INFO = 'shop_customer_social_logins.info';

    /**
     * the column name for the customer_id field
     */
    public const COL_CUSTOMER_ID = 'shop_customer_social_logins.customer_id';

    /**
     * The default string format for model objects of the related table
     */
    public const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     *
     * @var array<string, mixed>
     */
    protected static $fieldNames = [
        self::TYPE_PHPNAME       => ['Login', 'Provider', 'Info', 'customerId', ],
        self::TYPE_CAMELNAME     => ['login', 'provider', 'info', 'customerId', ],
        self::TYPE_COLNAME       => [CustomerSocialLoginTableMap::COL_LOGIN, CustomerSocialLoginTableMap::COL_PROVIDER, CustomerSocialLoginTableMap::COL_INFO, CustomerSocialLoginTableMap::COL_CUSTOMER_ID, ],
        self::TYPE_FIELDNAME     => ['login', 'provider', 'info', 'customer_id', ],
        self::TYPE_NUM           => [0, 1, 2, 3, ]
    ];

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     *
     * @var array<string, mixed>
     */
    protected static $fieldKeys = [
        self::TYPE_PHPNAME       => ['Login' => 0, 'Provider' => 1, 'Info' => 2, 'customerId' => 3, ],
        self::TYPE_CAMELNAME     => ['login' => 0, 'provider' => 1, 'info' => 2, 'customerId' => 3, ],
        self::TYPE_COLNAME       => [CustomerSocialLoginTableMap::COL_LOGIN => 0, CustomerSocialLoginTableMap::COL_PROVIDER => 1, CustomerSocialLoginTableMap::COL_INFO => 2, CustomerSocialLoginTableMap::COL_CUSTOMER_ID => 3, ],
        self::TYPE_FIELDNAME     => ['login' => 0, 'provider' => 1, 'info' => 2, 'customer_id' => 3, ],
        self::TYPE_NUM           => [0, 1, 2, 3, ]
    ];

    /**
     * Holds a list of column names and their normalized version.
     *
     * @var array<string>
     */
    protected $normalizedColumnNameMap = [
        'Login' => 'LOGIN',
        'CustomerSocialLogin.Login' => 'LOGIN',
        'login' => 'LOGIN',
        'customerSocialLogin.login' => 'LOGIN',
        'CustomerSocialLoginTableMap::COL_LOGIN' => 'LOGIN',
        'COL_LOGIN' => 'LOGIN',
        'shop_customer_social_logins.login' => 'LOGIN',
        'Provider' => 'PROVIDER',
        'CustomerSocialLogin.Provider' => 'PROVIDER',
        'provider' => 'PROVIDER',
        'customerSocialLogin.provider' => 'PROVIDER',
        'CustomerSocialLoginTableMap::COL_PROVIDER' => 'PROVIDER',
        'COL_PROVIDER' => 'PROVIDER',
        'shop_customer_social_logins.provider' => 'PROVIDER',
        'Info' => 'INFO',
        'CustomerSocialLogin.Info' => 'INFO',
        'info' => 'INFO',
        'customerSocialLogin.info' => 'INFO',
        'CustomerSocialLoginTableMap::COL_INFO' => 'INFO',
        'COL_INFO' => 'INFO',
        'shop_customer_social_logins.info' => 'INFO',
        'customerId' => 'CUSTOMER_ID',
        'CustomerSocialLogin.customerId' => 'CUSTOMER_ID',
        'customerSocialLogin.customerId' => 'CUSTOMER_ID',
        'CustomerSocialLoginTableMap::COL_CUSTOMER_ID' => 'CUSTOMER_ID',
        'COL_CUSTOMER_ID' => 'CUSTOMER_ID',
        'customer_id' => 'CUSTOMER_ID',
        'shop_customer_social_logins.customer_id' => 'CUSTOMER_ID',
    ];

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function initialize(): void
    {
        // attributes
        $this->setName('shop_customer_social_logins');
        $this->setPhpName('CustomerSocialLogin');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Infrastructure\\Models\\CustomerSocialLogin\\CustomerSocialLogin');
        $this->setPackage('Shop.Infrastructure.Models.CustomerSocialLogin');
        $this->setUseIdGenerator(false);
        // columns
        $this->addColumn('login', 'Login', 'VARCHAR', false, 255, null);
        $this->addColumn('provider', 'Provider', 'VARCHAR', false, 255, null);
        $this->addColumn('info', 'Info', 'LONGVARCHAR', false, null, null);
        $this->addForeignPrimaryKey('customer_id', 'customerId', 'INTEGER' , 'shop_customer', 'id', true, null, null);
    }

    /**
     * Build the RelationMap objects for this table relationships
     *
     * @return void
     */
    public function buildRelations(): void
    {
        $this->addRelation('Customer', '\\Shop\\Infrastructure\\Models\\Customer\\Customer', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':customer_id',
    1 => ':id',
  ),
), 'CASCADE', null, null, false);
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string|null The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): ?string
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 3 + $offset : static::translateFieldName('customerId', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 3 + $offset : static::translateFieldName('customerId', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 3 + $offset : static::translateFieldName('customerId', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 3 + $offset : static::translateFieldName('customerId', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 3 + $offset : static::translateFieldName('customerId', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 3 + $offset : static::translateFieldName('customerId', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array $row Resultset row.
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 3 + $offset
                : self::translateFieldName('customerId', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param bool $withPrefix Whether to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass(bool $withPrefix = true): string
    {
        return $withPrefix ? CustomerSocialLoginTableMap::CLASS_DEFAULT : CustomerSocialLoginTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array $row Row returned by DataFetcher->fetch().
     * @param int $offset The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array (CustomerSocialLogin object, last column rank)
     */
    public static function populateObject(array $row, int $offset = 0, string $indexType = TableMap::TYPE_NUM): array
    {
        $key = CustomerSocialLoginTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = CustomerSocialLoginTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + CustomerSocialLoginTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = CustomerSocialLoginTableMap::OM_CLASS;
            /** @var CustomerSocialLogin $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            CustomerSocialLoginTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array<object>
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher): array
    {
        $results = [];

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = CustomerSocialLoginTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = CustomerSocialLoginTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var CustomerSocialLogin $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                CustomerSocialLoginTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria Object containing the columns to add.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function addSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->addSelectColumn(CustomerSocialLoginTableMap::COL_LOGIN);
            $criteria->addSelectColumn(CustomerSocialLoginTableMap::COL_PROVIDER);
            $criteria->addSelectColumn(CustomerSocialLoginTableMap::COL_INFO);
            $criteria->addSelectColumn(CustomerSocialLoginTableMap::COL_CUSTOMER_ID);
        } else {
            $criteria->addSelectColumn($alias . '.login');
            $criteria->addSelectColumn($alias . '.provider');
            $criteria->addSelectColumn($alias . '.info');
            $criteria->addSelectColumn($alias . '.customer_id');
        }
    }

    /**
     * Remove all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be removed as they are only loaded on demand.
     *
     * @param Criteria $criteria Object containing the columns to remove.
     * @param string|null $alias Optional table alias
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return void
     */
    public static function removeSelectColumns(Criteria $criteria, ?string $alias = null): void
    {
        if (null === $alias) {
            $criteria->removeSelectColumn(CustomerSocialLoginTableMap::COL_LOGIN);
            $criteria->removeSelectColumn(CustomerSocialLoginTableMap::COL_PROVIDER);
            $criteria->removeSelectColumn(CustomerSocialLoginTableMap::COL_INFO);
            $criteria->removeSelectColumn(CustomerSocialLoginTableMap::COL_CUSTOMER_ID);
        } else {
            $criteria->removeSelectColumn($alias . '.login');
            $criteria->removeSelectColumn($alias . '.provider');
            $criteria->removeSelectColumn($alias . '.info');
            $criteria->removeSelectColumn($alias . '.customer_id');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap(): TableMap
    {
        return Propel::getServiceContainer()->getDatabaseMap(CustomerSocialLoginTableMap::DATABASE_NAME)->getTable(CustomerSocialLoginTableMap::TABLE_NAME);
    }

    /**
     * Performs a DELETE on the database, given a CustomerSocialLogin or Criteria object OR a primary key value.
     *
     * @param mixed $values Criteria or CustomerSocialLogin object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ?ConnectionInterface $con = null): int
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerSocialLoginTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Infrastructure\Models\CustomerSocialLogin\CustomerSocialLogin) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(CustomerSocialLoginTableMap::DATABASE_NAME);
            $criteria->add(CustomerSocialLoginTableMap::COL_CUSTOMER_ID, (array) $values, Criteria::IN);
        }

        $query = CustomerSocialLoginQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            CustomerSocialLoginTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                CustomerSocialLoginTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_customer_social_logins table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(?ConnectionInterface $con = null): int
    {
        return CustomerSocialLoginQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a CustomerSocialLogin or Criteria object.
     *
     * @param mixed $criteria Criteria or CustomerSocialLogin object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed The new primary key.
     * @throws \Propel\Runtime\Exception\PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ?ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerSocialLoginTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from CustomerSocialLogin object
        }


        // Set the correct dbName
        $query = CustomerSocialLoginQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

}
