<?php

namespace Shop\Infrastructure\Models\Category\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Shop\Infrastructure\Models\Catalog\Catalog;
use Shop\Infrastructure\Models\Catalog\CatalogQuery;
use Shop\Infrastructure\Models\Category\Category as ChildCategory;
use Shop\Infrastructure\Models\Category\CategoryQuery as ChildCategoryQuery;
use Shop\Infrastructure\Models\Category\Map\CategoryTableMap;
use Shop\Infrastructure\Models\DiscountRule\DiscountRule;
use Shop\Infrastructure\Models\DiscountRule\DiscountRuleQuery;
use Shop\Infrastructure\Models\DiscountRule\Base\DiscountRule as BaseDiscountRule;
use Shop\Infrastructure\Models\DiscountRule\Map\DiscountRuleTableMap;
use Shop\Infrastructure\Models\DraftProduct\DraftProduct;
use Shop\Infrastructure\Models\DraftProduct\DraftProductQuery;
use Shop\Infrastructure\Models\DraftProduct\Base\DraftProduct as BaseDraftProduct;
use Shop\Infrastructure\Models\DraftProduct\Map\DraftProductTableMap;
use Shop\Infrastructure\Models\ImageDefault\ImageDefault;
use Shop\Infrastructure\Models\ImageDefault\ImageDefaultQuery;
use Shop\Infrastructure\Models\ImageDefault\Base\ImageDefault as BaseImageDefault;
use Shop\Infrastructure\Models\ImageDefault\Map\ImageDefaultTableMap;
use Shop\Infrastructure\Models\Product\Product;
use Shop\Infrastructure\Models\Product\ProductQuery;
use Shop\Infrastructure\Models\Product\Base\Product as BaseProduct;
use Shop\Infrastructure\Models\Product\Map\ProductTableMap;
use Shop\Infrastructure\Models\SizeGrid\SizeGrid;
use Shop\Infrastructure\Models\SizeGrid\SizeGridQuery;
use Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel;
use Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery;
use Shop\Infrastructure\Models\SizeGridCategoryRel\Base\SizeGridCategoryRel as BaseSizeGridCategoryRel;
use Shop\Infrastructure\Models\SizeGridCategoryRel\Map\SizeGridCategoryRelTableMap;

/**
 * Base class that represents a row from the 'shop_categories' table.
 *
 *
 *
 * @package    propel.generator.Shop.Infrastructure.Models.Category.Base
 */
abstract class Category implements ActiveRecordInterface
{
    /**
     * TableMap class name
     *
     * @var string
     */
    public const TABLE_MAP = '\\Shop\\Infrastructure\\Models\\Category\\Map\\CategoryTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var bool
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var bool
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = [];

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = [];

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the title field.
     *
     * @var        string|null
     */
    protected $title;

    /**
     * The value for the alias field.
     *
     * @var        string|null
     */
    protected $alias;

    /**
     * The value for the full_title field.
     *
     * @var        string|null
     */
    protected $full_title;

    /**
     * The value for the image field.
     *
     * @var        string|null
     */
    protected $image;

    /**
     * The value for the desc field.
     *
     * @var        string|null
     */
    protected $desc;

    /**
     * The value for the parent_id field.
     *
     * @var        int|null
     */
    protected $parent_id;

    /**
     * The value for the catalog_id field.
     *
     * @var        int
     */
    protected $catalog_id;

    /**
     * The value for the active field.
     *
     * Note: this column has a database default value of: 'Y'
     * @var        string
     */
    protected $active;

    /**
     * @var        ChildCategory
     */
    protected $aParentCategory;

    /**
     * @var        Catalog
     */
    protected $aCatalog;

    /**
     * @var        ObjectCollection|ChildCategory[] Collection to store aggregation of ChildCategory objects.
     * @phpstan-var ObjectCollection&\Traversable<ChildCategory> Collection to store aggregation of ChildCategory objects.
     */
    protected $collCategoriesRelatedById;
    protected $collCategoriesRelatedByIdPartial;

    /**
     * @var        ObjectCollection|Product[] Collection to store aggregation of Product objects.
     * @phpstan-var ObjectCollection&\Traversable<Product> Collection to store aggregation of Product objects.
     */
    protected $collProducts;
    protected $collProductsPartial;

    /**
     * @var        ObjectCollection|SizeGridCategoryRel[] Collection to store aggregation of SizeGridCategoryRel objects.
     * @phpstan-var ObjectCollection&\Traversable<SizeGridCategoryRel> Collection to store aggregation of SizeGridCategoryRel objects.
     */
    protected $collSizeGridCategoryRels;
    protected $collSizeGridCategoryRelsPartial;

    /**
     * @var        ObjectCollection|DiscountRule[] Collection to store aggregation of DiscountRule objects.
     * @phpstan-var ObjectCollection&\Traversable<DiscountRule> Collection to store aggregation of DiscountRule objects.
     */
    protected $collDiscountRules;
    protected $collDiscountRulesPartial;

    /**
     * @var        ObjectCollection|ImageDefault[] Collection to store aggregation of ImageDefault objects.
     * @phpstan-var ObjectCollection&\Traversable<ImageDefault> Collection to store aggregation of ImageDefault objects.
     */
    protected $collImageDefaults;
    protected $collImageDefaultsPartial;

    /**
     * @var        ObjectCollection|DraftProduct[] Collection to store aggregation of DraftProduct objects.
     * @phpstan-var ObjectCollection&\Traversable<DraftProduct> Collection to store aggregation of DraftProduct objects.
     */
    protected $collDraftProducts;
    protected $collDraftProductsPartial;

    /**
     * @var        ObjectCollection|SizeGrid[] Cross Collection to store aggregation of SizeGrid objects.
     * @phpstan-var ObjectCollection&\Traversable<SizeGrid> Cross Collection to store aggregation of SizeGrid objects.
     */
    protected $collSizeGrids;

    /**
     * @var bool
     */
    protected $collSizeGridsPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var bool
     */
    protected $alreadyInSave = false;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|SizeGrid[]
     * @phpstan-var ObjectCollection&\Traversable<SizeGrid>
     */
    protected $sizeGridsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ChildCategory[]
     * @phpstan-var ObjectCollection&\Traversable<ChildCategory>
     */
    protected $categoriesRelatedByIdScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|Product[]
     * @phpstan-var ObjectCollection&\Traversable<Product>
     */
    protected $productsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|SizeGridCategoryRel[]
     * @phpstan-var ObjectCollection&\Traversable<SizeGridCategoryRel>
     */
    protected $sizeGridCategoryRelsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|DiscountRule[]
     * @phpstan-var ObjectCollection&\Traversable<DiscountRule>
     */
    protected $discountRulesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ImageDefault[]
     * @phpstan-var ObjectCollection&\Traversable<ImageDefault>
     */
    protected $imageDefaultsScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|DraftProduct[]
     * @phpstan-var ObjectCollection&\Traversable<DraftProduct>
     */
    protected $draftProductsScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues(): void
    {
        $this->active = 'Y';
    }

    /**
     * Initializes internal state of Shop\Infrastructure\Models\Category\Base\Category object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return bool True if the object has been modified.
     */
    public function isModified(): bool
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param string $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return bool True if $col has been modified.
     */
    public function isColumnModified(string $col): bool
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns(): array
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return bool True, if the object has never been persisted.
     */
    public function isNew(): bool
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param bool $b the state of the object.
     */
    public function setNew(bool $b): void
    {
        $this->new = $b;
    }

    /**
     * Whether this object has been deleted.
     * @return bool The deleted state of this object.
     */
    public function isDeleted(): bool
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param bool $b The deleted state of this object.
     * @return void
     */
    public function setDeleted(bool $b): void
    {
        $this->deleted = $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified(?string $col = null): void
    {
        if (null !== $col) {
            unset($this->modifiedColumns[$col]);
        } else {
            $this->modifiedColumns = [];
        }
    }

    /**
     * Compares this with another <code>Category</code> instance.  If
     * <code>obj</code> is an instance of <code>Category</code>, delegates to
     * <code>equals(Category)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param mixed $obj The object to compare to.
     * @return bool Whether equal to the object specified.
     */
    public function equals($obj): bool
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns(): array
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return bool
     */
    public function hasVirtualColumn(string $name): bool
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @return mixed
     *
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getVirtualColumn(string $name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of nonexistent virtual column `%s`.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name The virtual column name
     * @param mixed $value The value to give to the virtual column
     *
     * @return $this The current object, for fluid interface
     */
    public function setVirtualColumn(string $name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param string $msg
     * @param int $priority One of the Propel::LOG_* logging levels
     * @return void
     */
    protected function log(string $msg, int $priority = Propel::LOG_INFO): void
    {
        Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param \Propel\Runtime\Parser\AbstractParser|string $parser An AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME, TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM. Defaults to TableMap::TYPE_PHPNAME.
     * @return string The exported data
     */
    public function exportTo($parser, bool $includeLazyLoadColumns = true, string $keyType = TableMap::TYPE_PHPNAME): string
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray($keyType, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     *
     * @return array<string>
     */
    public function __sleep(): array
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [title] column value.
     *
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Get the [alias] column value.
     *
     * @return string|null
     */
    public function getAlias()
    {
        return $this->alias;
    }

    /**
     * Get the [full_title] column value.
     *
     * @return string|null
     */
    public function getFullTitle()
    {
        return $this->full_title;
    }

    /**
     * Get the [image] column value.
     *
     * @return string|null
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Get the [desc] column value.
     *
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }

    /**
     * Get the [parent_id] column value.
     *
     * @return int|null
     */
    public function getParentId()
    {
        return $this->parent_id;
    }

    /**
     * Get the [catalog_id] column value.
     *
     * @return int
     */
    public function getCatalogId()
    {
        return $this->catalog_id;
    }

    /**
     * Get the [active] column value.
     *
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[CategoryTableMap::COL_ID] = true;
        }

        return $this;
    }

    /**
     * Set the value of [title] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->title !== $v) {
            $this->title = $v;
            $this->modifiedColumns[CategoryTableMap::COL_TITLE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [alias] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setAlias($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->alias !== $v) {
            $this->alias = $v;
            $this->modifiedColumns[CategoryTableMap::COL_ALIAS] = true;
        }

        return $this;
    }

    /**
     * Set the value of [full_title] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setFullTitle($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->full_title !== $v) {
            $this->full_title = $v;
            $this->modifiedColumns[CategoryTableMap::COL_FULL_TITLE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [image] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setImage($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->image !== $v) {
            $this->image = $v;
            $this->modifiedColumns[CategoryTableMap::COL_IMAGE] = true;
        }

        return $this;
    }

    /**
     * Set the value of [desc] column.
     *
     * @param string|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setDesc($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->desc !== $v) {
            $this->desc = $v;
            $this->modifiedColumns[CategoryTableMap::COL_DESC] = true;
        }

        return $this;
    }

    /**
     * Set the value of [parent_id] column.
     *
     * @param int|null $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setParentId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->parent_id !== $v) {
            $this->parent_id = $v;
            $this->modifiedColumns[CategoryTableMap::COL_PARENT_ID] = true;
        }

        if ($this->aParentCategory !== null && $this->aParentCategory->getId() !== $v) {
            $this->aParentCategory = null;
        }

        return $this;
    }

    /**
     * Set the value of [catalog_id] column.
     *
     * @param int $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setCatalogId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->catalog_id !== $v) {
            $this->catalog_id = $v;
            $this->modifiedColumns[CategoryTableMap::COL_CATALOG_ID] = true;
        }

        if ($this->aCatalog !== null && $this->aCatalog->getId() !== $v) {
            $this->aCatalog = null;
        }

        return $this;
    }

    /**
     * Set the value of [active] column.
     *
     * @param string $v New value
     * @return $this The current object (for fluent API support)
     */
    public function setActive($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->active !== $v) {
            $this->active = $v;
            $this->modifiedColumns[CategoryTableMap::COL_ACTIVE] = true;
        }

        return $this;
    }

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return bool Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues(): bool
    {
            if ($this->active !== 'Y') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    }

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array $row The row returned by DataFetcher->fetch().
     * @param int $startcol 0-based offset column which indicates which resultset column to start with.
     * @param bool $rehydrate Whether this object is being re-hydrated from the database.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int next starting column
     * @throws \Propel\Runtime\Exception\PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate(array $row, int $startcol = 0, bool $rehydrate = false, string $indexType = TableMap::TYPE_NUM): int
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : CategoryTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : CategoryTableMap::translateFieldName('Title', TableMap::TYPE_PHPNAME, $indexType)];
            $this->title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : CategoryTableMap::translateFieldName('Alias', TableMap::TYPE_PHPNAME, $indexType)];
            $this->alias = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : CategoryTableMap::translateFieldName('FullTitle', TableMap::TYPE_PHPNAME, $indexType)];
            $this->full_title = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : CategoryTableMap::translateFieldName('Image', TableMap::TYPE_PHPNAME, $indexType)];
            $this->image = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : CategoryTableMap::translateFieldName('Desc', TableMap::TYPE_PHPNAME, $indexType)];
            $this->desc = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : CategoryTableMap::translateFieldName('ParentId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->parent_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : CategoryTableMap::translateFieldName('CatalogId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->catalog_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : CategoryTableMap::translateFieldName('Active', TableMap::TYPE_PHPNAME, $indexType)];
            $this->active = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 9; // 9 = CategoryTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Shop\\Infrastructure\\Models\\Category\\Category'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function ensureConsistency(): void
    {
        if ($this->aParentCategory !== null && $this->parent_id !== $this->aParentCategory->getId()) {
            $this->aParentCategory = null;
        }
        if ($this->aCatalog !== null && $this->catalog_id !== $this->aCatalog->getId()) {
            $this->aCatalog = null;
        }
    }

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param bool $deep (optional) Whether to also de-associated any related objects.
     * @param ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload(bool $deep = false, ?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(CategoryTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildCategoryQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aParentCategory = null;
            $this->aCatalog = null;
            $this->collCategoriesRelatedById = null;

            $this->collProducts = null;

            $this->collSizeGridCategoryRels = null;

            $this->collDiscountRules = null;

            $this->collImageDefaults = null;

            $this->collDraftProducts = null;

            $this->collSizeGrids = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param ConnectionInterface $con
     * @return void
     * @throws \Propel\Runtime\Exception\PropelException
     * @see Category::setDeleted()
     * @see Category::isDeleted()
     */
    public function delete(?ConnectionInterface $con = null): void
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(CategoryTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildCategoryQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    public function save(?ConnectionInterface $con = null): int
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(CategoryTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                CategoryTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param ConnectionInterface $con
     * @return int The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws \Propel\Runtime\Exception\PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con): int
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aParentCategory !== null) {
                if ($this->aParentCategory->isModified() || $this->aParentCategory->isNew()) {
                    $affectedRows += $this->aParentCategory->save($con);
                }
                $this->setParentCategory($this->aParentCategory);
            }

            if ($this->aCatalog !== null) {
                if ($this->aCatalog->isModified() || $this->aCatalog->isNew()) {
                    $affectedRows += $this->aCatalog->save($con);
                }
                $this->setCatalog($this->aCatalog);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->sizeGridsScheduledForDeletion !== null) {
                if (!$this->sizeGridsScheduledForDeletion->isEmpty()) {
                    $pks = [];
                    foreach ($this->sizeGridsScheduledForDeletion as $entry) {
                        $entryPk = [];

                        $entryPk[0] = $this->getId();
                        $entryPk[1] = $entry->getId();
                        $pks[] = $entryPk;
                    }

                    \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);

                    $this->sizeGridsScheduledForDeletion = null;
                }

            }

            if ($this->collSizeGrids) {
                foreach ($this->collSizeGrids as $sizeGrid) {
                    if (!$sizeGrid->isDeleted() && ($sizeGrid->isNew() || $sizeGrid->isModified())) {
                        $sizeGrid->save($con);
                    }
                }
            }


            if ($this->categoriesRelatedByIdScheduledForDeletion !== null) {
                if (!$this->categoriesRelatedByIdScheduledForDeletion->isEmpty()) {
                    foreach ($this->categoriesRelatedByIdScheduledForDeletion as $categoryRelatedById) {
                        // need to save related object because we set the relation to null
                        $categoryRelatedById->save($con);
                    }
                    $this->categoriesRelatedByIdScheduledForDeletion = null;
                }
            }

            if ($this->collCategoriesRelatedById !== null) {
                foreach ($this->collCategoriesRelatedById as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->productsScheduledForDeletion !== null) {
                if (!$this->productsScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\Product\ProductQuery::create()
                        ->filterByPrimaryKeys($this->productsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->productsScheduledForDeletion = null;
                }
            }

            if ($this->collProducts !== null) {
                foreach ($this->collProducts as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->sizeGridCategoryRelsScheduledForDeletion !== null) {
                if (!$this->sizeGridCategoryRelsScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRelQuery::create()
                        ->filterByPrimaryKeys($this->sizeGridCategoryRelsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->sizeGridCategoryRelsScheduledForDeletion = null;
                }
            }

            if ($this->collSizeGridCategoryRels !== null) {
                foreach ($this->collSizeGridCategoryRels as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->discountRulesScheduledForDeletion !== null) {
                if (!$this->discountRulesScheduledForDeletion->isEmpty()) {
                    foreach ($this->discountRulesScheduledForDeletion as $discountRule) {
                        // need to save related object because we set the relation to null
                        $discountRule->save($con);
                    }
                    $this->discountRulesScheduledForDeletion = null;
                }
            }

            if ($this->collDiscountRules !== null) {
                foreach ($this->collDiscountRules as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->imageDefaultsScheduledForDeletion !== null) {
                if (!$this->imageDefaultsScheduledForDeletion->isEmpty()) {
                    foreach ($this->imageDefaultsScheduledForDeletion as $imageDefault) {
                        // need to save related object because we set the relation to null
                        $imageDefault->save($con);
                    }
                    $this->imageDefaultsScheduledForDeletion = null;
                }
            }

            if ($this->collImageDefaults !== null) {
                foreach ($this->collImageDefaults as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            if ($this->draftProductsScheduledForDeletion !== null) {
                if (!$this->draftProductsScheduledForDeletion->isEmpty()) {
                    \Shop\Infrastructure\Models\DraftProduct\DraftProductQuery::create()
                        ->filterByPrimaryKeys($this->draftProductsScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->draftProductsScheduledForDeletion = null;
                }
            }

            if ($this->collDraftProducts !== null) {
                foreach ($this->collDraftProducts as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    }

    /**
     * Insert the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @throws \Propel\Runtime\Exception\PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con): void
    {
        $modifiedColumns = [];
        $index = 0;

        $this->modifiedColumns[CategoryTableMap::COL_ID] = true;

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(CategoryTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(CategoryTableMap::COL_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`title`';
        }
        if ($this->isColumnModified(CategoryTableMap::COL_ALIAS)) {
            $modifiedColumns[':p' . $index++]  = '`alias`';
        }
        if ($this->isColumnModified(CategoryTableMap::COL_FULL_TITLE)) {
            $modifiedColumns[':p' . $index++]  = '`full_title`';
        }
        if ($this->isColumnModified(CategoryTableMap::COL_IMAGE)) {
            $modifiedColumns[':p' . $index++]  = '`image`';
        }
        if ($this->isColumnModified(CategoryTableMap::COL_DESC)) {
            $modifiedColumns[':p' . $index++]  = '`desc`';
        }
        if ($this->isColumnModified(CategoryTableMap::COL_PARENT_ID)) {
            $modifiedColumns[':p' . $index++]  = '`parent_id`';
        }
        if ($this->isColumnModified(CategoryTableMap::COL_CATALOG_ID)) {
            $modifiedColumns[':p' . $index++]  = '`catalog_id`';
        }
        if ($this->isColumnModified(CategoryTableMap::COL_ACTIVE)) {
            $modifiedColumns[':p' . $index++]  = '`active`';
        }

        $sql = sprintf(
            'INSERT INTO `shop_categories` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`title`':
                        $stmt->bindValue($identifier, $this->title, PDO::PARAM_STR);
                        break;
                    case '`alias`':
                        $stmt->bindValue($identifier, $this->alias, PDO::PARAM_STR);
                        break;
                    case '`full_title`':
                        $stmt->bindValue($identifier, $this->full_title, PDO::PARAM_STR);
                        break;
                    case '`image`':
                        $stmt->bindValue($identifier, $this->image, PDO::PARAM_STR);
                        break;
                    case '`desc`':
                        $stmt->bindValue($identifier, $this->desc, PDO::PARAM_STR);
                        break;
                    case '`parent_id`':
                        $stmt->bindValue($identifier, $this->parent_id, PDO::PARAM_INT);
                        break;
                    case '`catalog_id`':
                        $stmt->bindValue($identifier, $this->catalog_id, PDO::PARAM_INT);
                        break;
                    case '`active`':
                        $stmt->bindValue($identifier, $this->active, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        if ($pk !== null) {
            $this->setId($pk);
        }

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param ConnectionInterface $con
     *
     * @return int Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con): int
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param string $name name
     * @param string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName(string $name, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = CategoryTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos Position in XML schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition(int $pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();

            case 1:
                return $this->getTitle();

            case 2:
                return $this->getAlias();

            case 3:
                return $this->getFullTitle();

            case 4:
                return $this->getImage();

            case 5:
                return $this->getDesc();

            case 6:
                return $this->getParentId();

            case 7:
                return $this->getCatalogId();

            case 8:
                return $this->getActive();

            default:
                return null;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param string $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param bool $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param bool $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array An associative array containing the field names (as keys) and field values
     */
    public function toArray(string $keyType = TableMap::TYPE_PHPNAME, bool $includeLazyLoadColumns = true, array $alreadyDumpedObjects = [], bool $includeForeignObjects = false): array
    {
        if (isset($alreadyDumpedObjects['Category'][$this->hashCode()])) {
            return ['*RECURSION*'];
        }
        $alreadyDumpedObjects['Category'][$this->hashCode()] = true;
        $keys = CategoryTableMap::getFieldNames($keyType);
        $result = [
            $keys[0] => $this->getId(),
            $keys[1] => $this->getTitle(),
            $keys[2] => $this->getAlias(),
            $keys[3] => $this->getFullTitle(),
            $keys[4] => $this->getImage(),
            $keys[5] => $this->getDesc(),
            $keys[6] => $this->getParentId(),
            $keys[7] => $this->getCatalogId(),
            $keys[8] => $this->getActive(),
        ];
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aParentCategory) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'category';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_categories';
                        break;
                    default:
                        $key = 'ParentCategory';
                }

                $result[$key] = $this->aParentCategory->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aCatalog) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'catalog';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_catalogs';
                        break;
                    default:
                        $key = 'Catalog';
                }

                $result[$key] = $this->aCatalog->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collCategoriesRelatedById) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'categories';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_categoriess';
                        break;
                    default:
                        $key = 'Categories';
                }

                $result[$key] = $this->collCategoriesRelatedById->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collProducts) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'products';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_productss';
                        break;
                    default:
                        $key = 'Products';
                }

                $result[$key] = $this->collProducts->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collSizeGridCategoryRels) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'sizeGridCategoryRels';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_size_grid_category_rels';
                        break;
                    default:
                        $key = 'SizeGridCategoryRels';
                }

                $result[$key] = $this->collSizeGridCategoryRels->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collDiscountRules) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'discountRules';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_discount_ruless';
                        break;
                    default:
                        $key = 'DiscountRules';
                }

                $result[$key] = $this->collDiscountRules->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collImageDefaults) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'imageDefaults';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_images_defaults';
                        break;
                    default:
                        $key = 'ImageDefaults';
                }

                $result[$key] = $this->collImageDefaults->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
            if (null !== $this->collDraftProducts) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'draftProducts';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_product_draftss';
                        break;
                    default:
                        $key = 'DraftProducts';
                }

                $result[$key] = $this->collDraftProducts->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param string $name
     * @param mixed $value field value
     * @param string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this
     */
    public function setByName(string $name, $value, string $type = TableMap::TYPE_PHPNAME)
    {
        $pos = CategoryTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        $this->setByPosition($pos, $value);

        return $this;
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param int $pos position in xml schema
     * @param mixed $value field value
     * @return $this
     */
    public function setByPosition(int $pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setTitle($value);
                break;
            case 2:
                $this->setAlias($value);
                break;
            case 3:
                $this->setFullTitle($value);
                break;
            case 4:
                $this->setImage($value);
                break;
            case 5:
                $this->setDesc($value);
                break;
            case 6:
                $this->setParentId($value);
                break;
            case 7:
                $this->setCatalogId($value);
                break;
            case 8:
                $this->setActive($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param array $arr An array to populate the object from.
     * @param string $keyType The type of keys the array uses.
     * @return $this
     */
    public function fromArray(array $arr, string $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = CategoryTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setTitle($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setAlias($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setFullTitle($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setImage($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setDesc($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setParentId($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setCatalogId($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setActive($arr[$keys[8]]);
        }

        return $this;
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this The current object, for fluid interface
     */
    public function importFrom($parser, string $data, string $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria(): Criteria
    {
        $criteria = new Criteria(CategoryTableMap::DATABASE_NAME);

        if ($this->isColumnModified(CategoryTableMap::COL_ID)) {
            $criteria->add(CategoryTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(CategoryTableMap::COL_TITLE)) {
            $criteria->add(CategoryTableMap::COL_TITLE, $this->title);
        }
        if ($this->isColumnModified(CategoryTableMap::COL_ALIAS)) {
            $criteria->add(CategoryTableMap::COL_ALIAS, $this->alias);
        }
        if ($this->isColumnModified(CategoryTableMap::COL_FULL_TITLE)) {
            $criteria->add(CategoryTableMap::COL_FULL_TITLE, $this->full_title);
        }
        if ($this->isColumnModified(CategoryTableMap::COL_IMAGE)) {
            $criteria->add(CategoryTableMap::COL_IMAGE, $this->image);
        }
        if ($this->isColumnModified(CategoryTableMap::COL_DESC)) {
            $criteria->add(CategoryTableMap::COL_DESC, $this->desc);
        }
        if ($this->isColumnModified(CategoryTableMap::COL_PARENT_ID)) {
            $criteria->add(CategoryTableMap::COL_PARENT_ID, $this->parent_id);
        }
        if ($this->isColumnModified(CategoryTableMap::COL_CATALOG_ID)) {
            $criteria->add(CategoryTableMap::COL_CATALOG_ID, $this->catalog_id);
        }
        if ($this->isColumnModified(CategoryTableMap::COL_ACTIVE)) {
            $criteria->add(CategoryTableMap::COL_ACTIVE, $this->active);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return \Propel\Runtime\ActiveQuery\Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria(): Criteria
    {
        $criteria = ChildCategoryQuery::create();
        $criteria->add(CategoryTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int|string Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param int|null $key Primary key.
     * @return void
     */
    public function setPrimaryKey(?int $key = null): void
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     *
     * @return bool
     */
    public function isPrimaryKeyNull(): bool
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param object $copyObj An object of \Shop\Infrastructure\Models\Category\Category (or compatible) type.
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param bool $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws \Propel\Runtime\Exception\PropelException
     * @return void
     */
    public function copyInto(object $copyObj, bool $deepCopy = false, bool $makeNew = true): void
    {
        $copyObj->setTitle($this->getTitle());
        $copyObj->setAlias($this->getAlias());
        $copyObj->setFullTitle($this->getFullTitle());
        $copyObj->setImage($this->getImage());
        $copyObj->setDesc($this->getDesc());
        $copyObj->setParentId($this->getParentId());
        $copyObj->setCatalogId($this->getCatalogId());
        $copyObj->setActive($this->getActive());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getCategoriesRelatedById() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addCategoryRelatedById($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getProducts() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addProduct($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getSizeGridCategoryRels() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addSizeGridCategoryRel($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getDiscountRules() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addDiscountRule($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getImageDefaults() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addImageDefault($relObj->copy($deepCopy));
                }
            }

            foreach ($this->getDraftProducts() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addDraftProduct($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param bool $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Shop\Infrastructure\Models\Category\Category Clone of current object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function copy(bool $deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a ChildCategory object.
     *
     * @param ChildCategory|null $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setParentCategory(ChildCategory $v = null)
    {
        if ($v === null) {
            $this->setParentId(NULL);
        } else {
            $this->setParentId($v->getId());
        }

        $this->aParentCategory = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the ChildCategory object, it will not be re-added.
        if ($v !== null) {
            $v->addCategoryRelatedById($this);
        }


        return $this;
    }


    /**
     * Get the associated ChildCategory object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return ChildCategory|null The associated ChildCategory object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getParentCategory(?ConnectionInterface $con = null)
    {
        if ($this->aParentCategory === null && ($this->parent_id != 0)) {
            $this->aParentCategory = ChildCategoryQuery::create()->findPk($this->parent_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aParentCategory->addCategoriesRelatedById($this);
             */
        }

        return $this->aParentCategory;
    }

    /**
     * Declares an association between this object and a Catalog object.
     *
     * @param Catalog $v
     * @return $this The current object (for fluent API support)
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function setCatalog(Catalog $v = null)
    {
        if ($v === null) {
            $this->setCatalogId(NULL);
        } else {
            $this->setCatalogId($v->getId());
        }

        $this->aCatalog = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Catalog object, it will not be re-added.
        if ($v !== null) {
            $v->addCategory($this);
        }


        return $this;
    }


    /**
     * Get the associated Catalog object
     *
     * @param ConnectionInterface $con Optional Connection object.
     * @return Catalog The associated Catalog object.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getCatalog(?ConnectionInterface $con = null)
    {
        if ($this->aCatalog === null && ($this->catalog_id != 0)) {
            $this->aCatalog = CatalogQuery::create()->findPk($this->catalog_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aCatalog->addCategories($this);
             */
        }

        return $this->aCatalog;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName): void
    {
        if ('CategoryRelatedById' === $relationName) {
            $this->initCategoriesRelatedById();
            return;
        }
        if ('Product' === $relationName) {
            $this->initProducts();
            return;
        }
        if ('SizeGridCategoryRel' === $relationName) {
            $this->initSizeGridCategoryRels();
            return;
        }
        if ('DiscountRule' === $relationName) {
            $this->initDiscountRules();
            return;
        }
        if ('ImageDefault' === $relationName) {
            $this->initImageDefaults();
            return;
        }
        if ('DraftProduct' === $relationName) {
            $this->initDraftProducts();
            return;
        }
    }

    /**
     * Clears out the collCategoriesRelatedById collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addCategoriesRelatedById()
     */
    public function clearCategoriesRelatedById()
    {
        $this->collCategoriesRelatedById = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collCategoriesRelatedById collection loaded partially.
     *
     * @return void
     */
    public function resetPartialCategoriesRelatedById($v = true): void
    {
        $this->collCategoriesRelatedByIdPartial = $v;
    }

    /**
     * Initializes the collCategoriesRelatedById collection.
     *
     * By default this just sets the collCategoriesRelatedById collection to an empty array (like clearcollCategoriesRelatedById());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initCategoriesRelatedById(bool $overrideExisting = true): void
    {
        if (null !== $this->collCategoriesRelatedById && !$overrideExisting) {
            return;
        }

        $collectionClassName = CategoryTableMap::getTableMap()->getCollectionClassName();

        $this->collCategoriesRelatedById = new $collectionClassName;
        $this->collCategoriesRelatedById->setModel('\Shop\Infrastructure\Models\Category\Category');
    }

    /**
     * Gets an array of ChildCategory objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCategory is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|ChildCategory[] List of ChildCategory objects
     * @phpstan-return ObjectCollection&\Traversable<ChildCategory> List of ChildCategory objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getCategoriesRelatedById(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collCategoriesRelatedByIdPartial && !$this->isNew();
        if (null === $this->collCategoriesRelatedById || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collCategoriesRelatedById) {
                    $this->initCategoriesRelatedById();
                } else {
                    $collectionClassName = CategoryTableMap::getTableMap()->getCollectionClassName();

                    $collCategoriesRelatedById = new $collectionClassName;
                    $collCategoriesRelatedById->setModel('\Shop\Infrastructure\Models\Category\Category');

                    return $collCategoriesRelatedById;
                }
            } else {
                $collCategoriesRelatedById = ChildCategoryQuery::create(null, $criteria)
                    ->filterByParentCategory($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collCategoriesRelatedByIdPartial && count($collCategoriesRelatedById)) {
                        $this->initCategoriesRelatedById(false);

                        foreach ($collCategoriesRelatedById as $obj) {
                            if (false == $this->collCategoriesRelatedById->contains($obj)) {
                                $this->collCategoriesRelatedById->append($obj);
                            }
                        }

                        $this->collCategoriesRelatedByIdPartial = true;
                    }

                    return $collCategoriesRelatedById;
                }

                if ($partial && $this->collCategoriesRelatedById) {
                    foreach ($this->collCategoriesRelatedById as $obj) {
                        if ($obj->isNew()) {
                            $collCategoriesRelatedById[] = $obj;
                        }
                    }
                }

                $this->collCategoriesRelatedById = $collCategoriesRelatedById;
                $this->collCategoriesRelatedByIdPartial = false;
            }
        }

        return $this->collCategoriesRelatedById;
    }

    /**
     * Sets a collection of ChildCategory objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $categoriesRelatedById A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setCategoriesRelatedById(Collection $categoriesRelatedById, ?ConnectionInterface $con = null)
    {
        /** @var ChildCategory[] $categoriesRelatedByIdToDelete */
        $categoriesRelatedByIdToDelete = $this->getCategoriesRelatedById(new Criteria(), $con)->diff($categoriesRelatedById);


        $this->categoriesRelatedByIdScheduledForDeletion = $categoriesRelatedByIdToDelete;

        foreach ($categoriesRelatedByIdToDelete as $categoryRelatedByIdRemoved) {
            $categoryRelatedByIdRemoved->setParentCategory(null);
        }

        $this->collCategoriesRelatedById = null;
        foreach ($categoriesRelatedById as $categoryRelatedById) {
            $this->addCategoryRelatedById($categoryRelatedById);
        }

        $this->collCategoriesRelatedById = $categoriesRelatedById;
        $this->collCategoriesRelatedByIdPartial = false;

        return $this;
    }

    /**
     * Returns the number of related Category objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related Category objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countCategoriesRelatedById(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collCategoriesRelatedByIdPartial && !$this->isNew();
        if (null === $this->collCategoriesRelatedById || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collCategoriesRelatedById) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getCategoriesRelatedById());
            }

            $query = ChildCategoryQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByParentCategory($this)
                ->count($con);
        }

        return count($this->collCategoriesRelatedById);
    }

    /**
     * Method called to associate a ChildCategory object to this object
     * through the ChildCategory foreign key attribute.
     *
     * @param ChildCategory $l ChildCategory
     * @return $this The current object (for fluent API support)
     */
    public function addCategoryRelatedById(ChildCategory $l)
    {
        if ($this->collCategoriesRelatedById === null) {
            $this->initCategoriesRelatedById();
            $this->collCategoriesRelatedByIdPartial = true;
        }

        if (!$this->collCategoriesRelatedById->contains($l)) {
            $this->doAddCategoryRelatedById($l);

            if ($this->categoriesRelatedByIdScheduledForDeletion and $this->categoriesRelatedByIdScheduledForDeletion->contains($l)) {
                $this->categoriesRelatedByIdScheduledForDeletion->remove($this->categoriesRelatedByIdScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ChildCategory $categoryRelatedById The ChildCategory object to add.
     */
    protected function doAddCategoryRelatedById(ChildCategory $categoryRelatedById): void
    {
        $this->collCategoriesRelatedById[]= $categoryRelatedById;
        $categoryRelatedById->setParentCategory($this);
    }

    /**
     * @param ChildCategory $categoryRelatedById The ChildCategory object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeCategoryRelatedById(ChildCategory $categoryRelatedById)
    {
        if ($this->getCategoriesRelatedById()->contains($categoryRelatedById)) {
            $pos = $this->collCategoriesRelatedById->search($categoryRelatedById);
            $this->collCategoriesRelatedById->remove($pos);
            if (null === $this->categoriesRelatedByIdScheduledForDeletion) {
                $this->categoriesRelatedByIdScheduledForDeletion = clone $this->collCategoriesRelatedById;
                $this->categoriesRelatedByIdScheduledForDeletion->clear();
            }
            $this->categoriesRelatedByIdScheduledForDeletion[]= $categoryRelatedById;
            $categoryRelatedById->setParentCategory(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Category is new, it will return
     * an empty collection; or if this Category has previously
     * been saved, it will retrieve related CategoriesRelatedById from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Category.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|ChildCategory[] List of ChildCategory objects
     * @phpstan-return ObjectCollection&\Traversable<ChildCategory}> List of ChildCategory objects
     */
    public function getCategoriesRelatedByIdJoinCatalog(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ChildCategoryQuery::create(null, $criteria);
        $query->joinWith('Catalog', $joinBehavior);

        return $this->getCategoriesRelatedById($query, $con);
    }

    /**
     * Clears out the collProducts collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addProducts()
     */
    public function clearProducts()
    {
        $this->collProducts = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collProducts collection loaded partially.
     *
     * @return void
     */
    public function resetPartialProducts($v = true): void
    {
        $this->collProductsPartial = $v;
    }

    /**
     * Initializes the collProducts collection.
     *
     * By default this just sets the collProducts collection to an empty array (like clearcollProducts());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initProducts(bool $overrideExisting = true): void
    {
        if (null !== $this->collProducts && !$overrideExisting) {
            return;
        }

        $collectionClassName = ProductTableMap::getTableMap()->getCollectionClassName();

        $this->collProducts = new $collectionClassName;
        $this->collProducts->setModel('\Shop\Infrastructure\Models\Product\Product');
    }

    /**
     * Gets an array of Product objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCategory is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|Product[] List of Product objects
     * @phpstan-return ObjectCollection&\Traversable<Product> List of Product objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getProducts(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collProductsPartial && !$this->isNew();
        if (null === $this->collProducts || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collProducts) {
                    $this->initProducts();
                } else {
                    $collectionClassName = ProductTableMap::getTableMap()->getCollectionClassName();

                    $collProducts = new $collectionClassName;
                    $collProducts->setModel('\Shop\Infrastructure\Models\Product\Product');

                    return $collProducts;
                }
            } else {
                $collProducts = ProductQuery::create(null, $criteria)
                    ->filterByCategory($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collProductsPartial && count($collProducts)) {
                        $this->initProducts(false);

                        foreach ($collProducts as $obj) {
                            if (false == $this->collProducts->contains($obj)) {
                                $this->collProducts->append($obj);
                            }
                        }

                        $this->collProductsPartial = true;
                    }

                    return $collProducts;
                }

                if ($partial && $this->collProducts) {
                    foreach ($this->collProducts as $obj) {
                        if ($obj->isNew()) {
                            $collProducts[] = $obj;
                        }
                    }
                }

                $this->collProducts = $collProducts;
                $this->collProductsPartial = false;
            }
        }

        return $this->collProducts;
    }

    /**
     * Sets a collection of Product objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $products A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setProducts(Collection $products, ?ConnectionInterface $con = null)
    {
        /** @var Product[] $productsToDelete */
        $productsToDelete = $this->getProducts(new Criteria(), $con)->diff($products);


        $this->productsScheduledForDeletion = $productsToDelete;

        foreach ($productsToDelete as $productRemoved) {
            $productRemoved->setCategory(null);
        }

        $this->collProducts = null;
        foreach ($products as $product) {
            $this->addProduct($product);
        }

        $this->collProducts = $products;
        $this->collProductsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseProduct objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseProduct objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countProducts(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collProductsPartial && !$this->isNew();
        if (null === $this->collProducts || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collProducts) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getProducts());
            }

            $query = ProductQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByCategory($this)
                ->count($con);
        }

        return count($this->collProducts);
    }

    /**
     * Method called to associate a Product object to this object
     * through the Product foreign key attribute.
     *
     * @param Product $l Product
     * @return $this The current object (for fluent API support)
     */
    public function addProduct(Product $l)
    {
        if ($this->collProducts === null) {
            $this->initProducts();
            $this->collProductsPartial = true;
        }

        if (!$this->collProducts->contains($l)) {
            $this->doAddProduct($l);

            if ($this->productsScheduledForDeletion and $this->productsScheduledForDeletion->contains($l)) {
                $this->productsScheduledForDeletion->remove($this->productsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param Product $product The Product object to add.
     */
    protected function doAddProduct(Product $product): void
    {
        $this->collProducts[]= $product;
        $product->setCategory($this);
    }

    /**
     * @param Product $product The Product object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeProduct(Product $product)
    {
        if ($this->getProducts()->contains($product)) {
            $pos = $this->collProducts->search($product);
            $this->collProducts->remove($pos);
            if (null === $this->productsScheduledForDeletion) {
                $this->productsScheduledForDeletion = clone $this->collProducts;
                $this->productsScheduledForDeletion->clear();
            }
            $this->productsScheduledForDeletion[]= clone $product;
            $product->setCategory(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Category is new, it will return
     * an empty collection; or if this Category has previously
     * been saved, it will retrieve related Products from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Category.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|Product[] List of Product objects
     * @phpstan-return ObjectCollection&\Traversable<Product}> List of Product objects
     */
    public function getProductsJoinBrand(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ProductQuery::create(null, $criteria);
        $query->joinWith('Brand', $joinBehavior);

        return $this->getProducts($query, $con);
    }

    /**
     * Clears out the collSizeGridCategoryRels collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addSizeGridCategoryRels()
     */
    public function clearSizeGridCategoryRels()
    {
        $this->collSizeGridCategoryRels = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collSizeGridCategoryRels collection loaded partially.
     *
     * @return void
     */
    public function resetPartialSizeGridCategoryRels($v = true): void
    {
        $this->collSizeGridCategoryRelsPartial = $v;
    }

    /**
     * Initializes the collSizeGridCategoryRels collection.
     *
     * By default this just sets the collSizeGridCategoryRels collection to an empty array (like clearcollSizeGridCategoryRels());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initSizeGridCategoryRels(bool $overrideExisting = true): void
    {
        if (null !== $this->collSizeGridCategoryRels && !$overrideExisting) {
            return;
        }

        $collectionClassName = SizeGridCategoryRelTableMap::getTableMap()->getCollectionClassName();

        $this->collSizeGridCategoryRels = new $collectionClassName;
        $this->collSizeGridCategoryRels->setModel('\Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel');
    }

    /**
     * Gets an array of SizeGridCategoryRel objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCategory is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|SizeGridCategoryRel[] List of SizeGridCategoryRel objects
     * @phpstan-return ObjectCollection&\Traversable<SizeGridCategoryRel> List of SizeGridCategoryRel objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getSizeGridCategoryRels(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collSizeGridCategoryRelsPartial && !$this->isNew();
        if (null === $this->collSizeGridCategoryRels || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collSizeGridCategoryRels) {
                    $this->initSizeGridCategoryRels();
                } else {
                    $collectionClassName = SizeGridCategoryRelTableMap::getTableMap()->getCollectionClassName();

                    $collSizeGridCategoryRels = new $collectionClassName;
                    $collSizeGridCategoryRels->setModel('\Shop\Infrastructure\Models\SizeGridCategoryRel\SizeGridCategoryRel');

                    return $collSizeGridCategoryRels;
                }
            } else {
                $collSizeGridCategoryRels = SizeGridCategoryRelQuery::create(null, $criteria)
                    ->filterByCategory($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collSizeGridCategoryRelsPartial && count($collSizeGridCategoryRels)) {
                        $this->initSizeGridCategoryRels(false);

                        foreach ($collSizeGridCategoryRels as $obj) {
                            if (false == $this->collSizeGridCategoryRels->contains($obj)) {
                                $this->collSizeGridCategoryRels->append($obj);
                            }
                        }

                        $this->collSizeGridCategoryRelsPartial = true;
                    }

                    return $collSizeGridCategoryRels;
                }

                if ($partial && $this->collSizeGridCategoryRels) {
                    foreach ($this->collSizeGridCategoryRels as $obj) {
                        if ($obj->isNew()) {
                            $collSizeGridCategoryRels[] = $obj;
                        }
                    }
                }

                $this->collSizeGridCategoryRels = $collSizeGridCategoryRels;
                $this->collSizeGridCategoryRelsPartial = false;
            }
        }

        return $this->collSizeGridCategoryRels;
    }

    /**
     * Sets a collection of SizeGridCategoryRel objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $sizeGridCategoryRels A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setSizeGridCategoryRels(Collection $sizeGridCategoryRels, ?ConnectionInterface $con = null)
    {
        /** @var SizeGridCategoryRel[] $sizeGridCategoryRelsToDelete */
        $sizeGridCategoryRelsToDelete = $this->getSizeGridCategoryRels(new Criteria(), $con)->diff($sizeGridCategoryRels);


        //since at least one column in the foreign key is at the same time a PK
        //we can not just set a PK to NULL in the lines below. We have to store
        //a backup of all values, so we are able to manipulate these items based on the onDelete value later.
        $this->sizeGridCategoryRelsScheduledForDeletion = clone $sizeGridCategoryRelsToDelete;

        foreach ($sizeGridCategoryRelsToDelete as $sizeGridCategoryRelRemoved) {
            $sizeGridCategoryRelRemoved->setCategory(null);
        }

        $this->collSizeGridCategoryRels = null;
        foreach ($sizeGridCategoryRels as $sizeGridCategoryRel) {
            $this->addSizeGridCategoryRel($sizeGridCategoryRel);
        }

        $this->collSizeGridCategoryRels = $sizeGridCategoryRels;
        $this->collSizeGridCategoryRelsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseSizeGridCategoryRel objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseSizeGridCategoryRel objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countSizeGridCategoryRels(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collSizeGridCategoryRelsPartial && !$this->isNew();
        if (null === $this->collSizeGridCategoryRels || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collSizeGridCategoryRels) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getSizeGridCategoryRels());
            }

            $query = SizeGridCategoryRelQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByCategory($this)
                ->count($con);
        }

        return count($this->collSizeGridCategoryRels);
    }

    /**
     * Method called to associate a SizeGridCategoryRel object to this object
     * through the SizeGridCategoryRel foreign key attribute.
     *
     * @param SizeGridCategoryRel $l SizeGridCategoryRel
     * @return $this The current object (for fluent API support)
     */
    public function addSizeGridCategoryRel(SizeGridCategoryRel $l)
    {
        if ($this->collSizeGridCategoryRels === null) {
            $this->initSizeGridCategoryRels();
            $this->collSizeGridCategoryRelsPartial = true;
        }

        if (!$this->collSizeGridCategoryRels->contains($l)) {
            $this->doAddSizeGridCategoryRel($l);

            if ($this->sizeGridCategoryRelsScheduledForDeletion and $this->sizeGridCategoryRelsScheduledForDeletion->contains($l)) {
                $this->sizeGridCategoryRelsScheduledForDeletion->remove($this->sizeGridCategoryRelsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param SizeGridCategoryRel $sizeGridCategoryRel The SizeGridCategoryRel object to add.
     */
    protected function doAddSizeGridCategoryRel(SizeGridCategoryRel $sizeGridCategoryRel): void
    {
        $this->collSizeGridCategoryRels[]= $sizeGridCategoryRel;
        $sizeGridCategoryRel->setCategory($this);
    }

    /**
     * @param SizeGridCategoryRel $sizeGridCategoryRel The SizeGridCategoryRel object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeSizeGridCategoryRel(SizeGridCategoryRel $sizeGridCategoryRel)
    {
        if ($this->getSizeGridCategoryRels()->contains($sizeGridCategoryRel)) {
            $pos = $this->collSizeGridCategoryRels->search($sizeGridCategoryRel);
            $this->collSizeGridCategoryRels->remove($pos);
            if (null === $this->sizeGridCategoryRelsScheduledForDeletion) {
                $this->sizeGridCategoryRelsScheduledForDeletion = clone $this->collSizeGridCategoryRels;
                $this->sizeGridCategoryRelsScheduledForDeletion->clear();
            }
            $this->sizeGridCategoryRelsScheduledForDeletion[]= clone $sizeGridCategoryRel;
            $sizeGridCategoryRel->setCategory(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Category is new, it will return
     * an empty collection; or if this Category has previously
     * been saved, it will retrieve related SizeGridCategoryRels from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Category.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|SizeGridCategoryRel[] List of SizeGridCategoryRel objects
     * @phpstan-return ObjectCollection&\Traversable<SizeGridCategoryRel}> List of SizeGridCategoryRel objects
     */
    public function getSizeGridCategoryRelsJoinSizeGrid(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = SizeGridCategoryRelQuery::create(null, $criteria);
        $query->joinWith('SizeGrid', $joinBehavior);

        return $this->getSizeGridCategoryRels($query, $con);
    }

    /**
     * Clears out the collDiscountRules collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addDiscountRules()
     */
    public function clearDiscountRules()
    {
        $this->collDiscountRules = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collDiscountRules collection loaded partially.
     *
     * @return void
     */
    public function resetPartialDiscountRules($v = true): void
    {
        $this->collDiscountRulesPartial = $v;
    }

    /**
     * Initializes the collDiscountRules collection.
     *
     * By default this just sets the collDiscountRules collection to an empty array (like clearcollDiscountRules());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initDiscountRules(bool $overrideExisting = true): void
    {
        if (null !== $this->collDiscountRules && !$overrideExisting) {
            return;
        }

        $collectionClassName = DiscountRuleTableMap::getTableMap()->getCollectionClassName();

        $this->collDiscountRules = new $collectionClassName;
        $this->collDiscountRules->setModel('\Shop\Infrastructure\Models\DiscountRule\DiscountRule');
    }

    /**
     * Gets an array of DiscountRule objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCategory is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|DiscountRule[] List of DiscountRule objects
     * @phpstan-return ObjectCollection&\Traversable<DiscountRule> List of DiscountRule objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getDiscountRules(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collDiscountRulesPartial && !$this->isNew();
        if (null === $this->collDiscountRules || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collDiscountRules) {
                    $this->initDiscountRules();
                } else {
                    $collectionClassName = DiscountRuleTableMap::getTableMap()->getCollectionClassName();

                    $collDiscountRules = new $collectionClassName;
                    $collDiscountRules->setModel('\Shop\Infrastructure\Models\DiscountRule\DiscountRule');

                    return $collDiscountRules;
                }
            } else {
                $collDiscountRules = DiscountRuleQuery::create(null, $criteria)
                    ->filterByCategory($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collDiscountRulesPartial && count($collDiscountRules)) {
                        $this->initDiscountRules(false);

                        foreach ($collDiscountRules as $obj) {
                            if (false == $this->collDiscountRules->contains($obj)) {
                                $this->collDiscountRules->append($obj);
                            }
                        }

                        $this->collDiscountRulesPartial = true;
                    }

                    return $collDiscountRules;
                }

                if ($partial && $this->collDiscountRules) {
                    foreach ($this->collDiscountRules as $obj) {
                        if ($obj->isNew()) {
                            $collDiscountRules[] = $obj;
                        }
                    }
                }

                $this->collDiscountRules = $collDiscountRules;
                $this->collDiscountRulesPartial = false;
            }
        }

        return $this->collDiscountRules;
    }

    /**
     * Sets a collection of DiscountRule objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $discountRules A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setDiscountRules(Collection $discountRules, ?ConnectionInterface $con = null)
    {
        /** @var DiscountRule[] $discountRulesToDelete */
        $discountRulesToDelete = $this->getDiscountRules(new Criteria(), $con)->diff($discountRules);


        $this->discountRulesScheduledForDeletion = $discountRulesToDelete;

        foreach ($discountRulesToDelete as $discountRuleRemoved) {
            $discountRuleRemoved->setCategory(null);
        }

        $this->collDiscountRules = null;
        foreach ($discountRules as $discountRule) {
            $this->addDiscountRule($discountRule);
        }

        $this->collDiscountRules = $discountRules;
        $this->collDiscountRulesPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseDiscountRule objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseDiscountRule objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countDiscountRules(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collDiscountRulesPartial && !$this->isNew();
        if (null === $this->collDiscountRules || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collDiscountRules) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getDiscountRules());
            }

            $query = DiscountRuleQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByCategory($this)
                ->count($con);
        }

        return count($this->collDiscountRules);
    }

    /**
     * Method called to associate a DiscountRule object to this object
     * through the DiscountRule foreign key attribute.
     *
     * @param DiscountRule $l DiscountRule
     * @return $this The current object (for fluent API support)
     */
    public function addDiscountRule(DiscountRule $l)
    {
        if ($this->collDiscountRules === null) {
            $this->initDiscountRules();
            $this->collDiscountRulesPartial = true;
        }

        if (!$this->collDiscountRules->contains($l)) {
            $this->doAddDiscountRule($l);

            if ($this->discountRulesScheduledForDeletion and $this->discountRulesScheduledForDeletion->contains($l)) {
                $this->discountRulesScheduledForDeletion->remove($this->discountRulesScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param DiscountRule $discountRule The DiscountRule object to add.
     */
    protected function doAddDiscountRule(DiscountRule $discountRule): void
    {
        $this->collDiscountRules[]= $discountRule;
        $discountRule->setCategory($this);
    }

    /**
     * @param DiscountRule $discountRule The DiscountRule object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeDiscountRule(DiscountRule $discountRule)
    {
        if ($this->getDiscountRules()->contains($discountRule)) {
            $pos = $this->collDiscountRules->search($discountRule);
            $this->collDiscountRules->remove($pos);
            if (null === $this->discountRulesScheduledForDeletion) {
                $this->discountRulesScheduledForDeletion = clone $this->collDiscountRules;
                $this->discountRulesScheduledForDeletion->clear();
            }
            $this->discountRulesScheduledForDeletion[]= $discountRule;
            $discountRule->setCategory(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Category is new, it will return
     * an empty collection; or if this Category has previously
     * been saved, it will retrieve related DiscountRules from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Category.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DiscountRule[] List of DiscountRule objects
     * @phpstan-return ObjectCollection&\Traversable<DiscountRule}> List of DiscountRule objects
     */
    public function getDiscountRulesJoinBrand(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DiscountRuleQuery::create(null, $criteria);
        $query->joinWith('Brand', $joinBehavior);

        return $this->getDiscountRules($query, $con);
    }

    /**
     * Clears out the collImageDefaults collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addImageDefaults()
     */
    public function clearImageDefaults()
    {
        $this->collImageDefaults = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collImageDefaults collection loaded partially.
     *
     * @return void
     */
    public function resetPartialImageDefaults($v = true): void
    {
        $this->collImageDefaultsPartial = $v;
    }

    /**
     * Initializes the collImageDefaults collection.
     *
     * By default this just sets the collImageDefaults collection to an empty array (like clearcollImageDefaults());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initImageDefaults(bool $overrideExisting = true): void
    {
        if (null !== $this->collImageDefaults && !$overrideExisting) {
            return;
        }

        $collectionClassName = ImageDefaultTableMap::getTableMap()->getCollectionClassName();

        $this->collImageDefaults = new $collectionClassName;
        $this->collImageDefaults->setModel('\Shop\Infrastructure\Models\ImageDefault\ImageDefault');
    }

    /**
     * Gets an array of ImageDefault objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCategory is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|ImageDefault[] List of ImageDefault objects
     * @phpstan-return ObjectCollection&\Traversable<ImageDefault> List of ImageDefault objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getImageDefaults(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collImageDefaultsPartial && !$this->isNew();
        if (null === $this->collImageDefaults || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collImageDefaults) {
                    $this->initImageDefaults();
                } else {
                    $collectionClassName = ImageDefaultTableMap::getTableMap()->getCollectionClassName();

                    $collImageDefaults = new $collectionClassName;
                    $collImageDefaults->setModel('\Shop\Infrastructure\Models\ImageDefault\ImageDefault');

                    return $collImageDefaults;
                }
            } else {
                $collImageDefaults = ImageDefaultQuery::create(null, $criteria)
                    ->filterByCategory($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collImageDefaultsPartial && count($collImageDefaults)) {
                        $this->initImageDefaults(false);

                        foreach ($collImageDefaults as $obj) {
                            if (false == $this->collImageDefaults->contains($obj)) {
                                $this->collImageDefaults->append($obj);
                            }
                        }

                        $this->collImageDefaultsPartial = true;
                    }

                    return $collImageDefaults;
                }

                if ($partial && $this->collImageDefaults) {
                    foreach ($this->collImageDefaults as $obj) {
                        if ($obj->isNew()) {
                            $collImageDefaults[] = $obj;
                        }
                    }
                }

                $this->collImageDefaults = $collImageDefaults;
                $this->collImageDefaultsPartial = false;
            }
        }

        return $this->collImageDefaults;
    }

    /**
     * Sets a collection of ImageDefault objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $imageDefaults A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setImageDefaults(Collection $imageDefaults, ?ConnectionInterface $con = null)
    {
        /** @var ImageDefault[] $imageDefaultsToDelete */
        $imageDefaultsToDelete = $this->getImageDefaults(new Criteria(), $con)->diff($imageDefaults);


        $this->imageDefaultsScheduledForDeletion = $imageDefaultsToDelete;

        foreach ($imageDefaultsToDelete as $imageDefaultRemoved) {
            $imageDefaultRemoved->setCategory(null);
        }

        $this->collImageDefaults = null;
        foreach ($imageDefaults as $imageDefault) {
            $this->addImageDefault($imageDefault);
        }

        $this->collImageDefaults = $imageDefaults;
        $this->collImageDefaultsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseImageDefault objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseImageDefault objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countImageDefaults(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collImageDefaultsPartial && !$this->isNew();
        if (null === $this->collImageDefaults || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collImageDefaults) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getImageDefaults());
            }

            $query = ImageDefaultQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByCategory($this)
                ->count($con);
        }

        return count($this->collImageDefaults);
    }

    /**
     * Method called to associate a ImageDefault object to this object
     * through the ImageDefault foreign key attribute.
     *
     * @param ImageDefault $l ImageDefault
     * @return $this The current object (for fluent API support)
     */
    public function addImageDefault(ImageDefault $l)
    {
        if ($this->collImageDefaults === null) {
            $this->initImageDefaults();
            $this->collImageDefaultsPartial = true;
        }

        if (!$this->collImageDefaults->contains($l)) {
            $this->doAddImageDefault($l);

            if ($this->imageDefaultsScheduledForDeletion and $this->imageDefaultsScheduledForDeletion->contains($l)) {
                $this->imageDefaultsScheduledForDeletion->remove($this->imageDefaultsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ImageDefault $imageDefault The ImageDefault object to add.
     */
    protected function doAddImageDefault(ImageDefault $imageDefault): void
    {
        $this->collImageDefaults[]= $imageDefault;
        $imageDefault->setCategory($this);
    }

    /**
     * @param ImageDefault $imageDefault The ImageDefault object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeImageDefault(ImageDefault $imageDefault)
    {
        if ($this->getImageDefaults()->contains($imageDefault)) {
            $pos = $this->collImageDefaults->search($imageDefault);
            $this->collImageDefaults->remove($pos);
            if (null === $this->imageDefaultsScheduledForDeletion) {
                $this->imageDefaultsScheduledForDeletion = clone $this->collImageDefaults;
                $this->imageDefaultsScheduledForDeletion->clear();
            }
            $this->imageDefaultsScheduledForDeletion[]= $imageDefault;
            $imageDefault->setCategory(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Category is new, it will return
     * an empty collection; or if this Category has previously
     * been saved, it will retrieve related ImageDefaults from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Category.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|ImageDefault[] List of ImageDefault objects
     * @phpstan-return ObjectCollection&\Traversable<ImageDefault}> List of ImageDefault objects
     */
    public function getImageDefaultsJoinShopBrand(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ImageDefaultQuery::create(null, $criteria);
        $query->joinWith('ShopBrand', $joinBehavior);

        return $this->getImageDefaults($query, $con);
    }

    /**
     * Clears out the collDraftProducts collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return $this
     * @see addDraftProducts()
     */
    public function clearDraftProducts()
    {
        $this->collDraftProducts = null; // important to set this to NULL since that means it is uninitialized

        return $this;
    }

    /**
     * Reset is the collDraftProducts collection loaded partially.
     *
     * @return void
     */
    public function resetPartialDraftProducts($v = true): void
    {
        $this->collDraftProductsPartial = $v;
    }

    /**
     * Initializes the collDraftProducts collection.
     *
     * By default this just sets the collDraftProducts collection to an empty array (like clearcollDraftProducts());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param bool $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initDraftProducts(bool $overrideExisting = true): void
    {
        if (null !== $this->collDraftProducts && !$overrideExisting) {
            return;
        }

        $collectionClassName = DraftProductTableMap::getTableMap()->getCollectionClassName();

        $this->collDraftProducts = new $collectionClassName;
        $this->collDraftProducts->setModel('\Shop\Infrastructure\Models\DraftProduct\DraftProduct');
    }

    /**
     * Gets an array of DraftProduct objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCategory is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct> List of DraftProduct objects
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getDraftProducts(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collDraftProductsPartial && !$this->isNew();
        if (null === $this->collDraftProducts || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collDraftProducts) {
                    $this->initDraftProducts();
                } else {
                    $collectionClassName = DraftProductTableMap::getTableMap()->getCollectionClassName();

                    $collDraftProducts = new $collectionClassName;
                    $collDraftProducts->setModel('\Shop\Infrastructure\Models\DraftProduct\DraftProduct');

                    return $collDraftProducts;
                }
            } else {
                $collDraftProducts = DraftProductQuery::create(null, $criteria)
                    ->filterByCategory($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collDraftProductsPartial && count($collDraftProducts)) {
                        $this->initDraftProducts(false);

                        foreach ($collDraftProducts as $obj) {
                            if (false == $this->collDraftProducts->contains($obj)) {
                                $this->collDraftProducts->append($obj);
                            }
                        }

                        $this->collDraftProductsPartial = true;
                    }

                    return $collDraftProducts;
                }

                if ($partial && $this->collDraftProducts) {
                    foreach ($this->collDraftProducts as $obj) {
                        if ($obj->isNew()) {
                            $collDraftProducts[] = $obj;
                        }
                    }
                }

                $this->collDraftProducts = $collDraftProducts;
                $this->collDraftProductsPartial = false;
            }
        }

        return $this->collDraftProducts;
    }

    /**
     * Sets a collection of DraftProduct objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $draftProducts A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setDraftProducts(Collection $draftProducts, ?ConnectionInterface $con = null)
    {
        /** @var DraftProduct[] $draftProductsToDelete */
        $draftProductsToDelete = $this->getDraftProducts(new Criteria(), $con)->diff($draftProducts);


        $this->draftProductsScheduledForDeletion = $draftProductsToDelete;

        foreach ($draftProductsToDelete as $draftProductRemoved) {
            $draftProductRemoved->setCategory(null);
        }

        $this->collDraftProducts = null;
        foreach ($draftProducts as $draftProduct) {
            $this->addDraftProduct($draftProduct);
        }

        $this->collDraftProducts = $draftProducts;
        $this->collDraftProductsPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseDraftProduct objects.
     *
     * @param Criteria $criteria
     * @param bool $distinct
     * @param ConnectionInterface $con
     * @return int Count of related BaseDraftProduct objects.
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function countDraftProducts(?Criteria $criteria = null, bool $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collDraftProductsPartial && !$this->isNew();
        if (null === $this->collDraftProducts || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collDraftProducts) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getDraftProducts());
            }

            $query = DraftProductQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByCategory($this)
                ->count($con);
        }

        return count($this->collDraftProducts);
    }

    /**
     * Method called to associate a DraftProduct object to this object
     * through the DraftProduct foreign key attribute.
     *
     * @param DraftProduct $l DraftProduct
     * @return $this The current object (for fluent API support)
     */
    public function addDraftProduct(DraftProduct $l)
    {
        if ($this->collDraftProducts === null) {
            $this->initDraftProducts();
            $this->collDraftProductsPartial = true;
        }

        if (!$this->collDraftProducts->contains($l)) {
            $this->doAddDraftProduct($l);

            if ($this->draftProductsScheduledForDeletion and $this->draftProductsScheduledForDeletion->contains($l)) {
                $this->draftProductsScheduledForDeletion->remove($this->draftProductsScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param DraftProduct $draftProduct The DraftProduct object to add.
     */
    protected function doAddDraftProduct(DraftProduct $draftProduct): void
    {
        $this->collDraftProducts[]= $draftProduct;
        $draftProduct->setCategory($this);
    }

    /**
     * @param DraftProduct $draftProduct The DraftProduct object to remove.
     * @return $this The current object (for fluent API support)
     */
    public function removeDraftProduct(DraftProduct $draftProduct)
    {
        if ($this->getDraftProducts()->contains($draftProduct)) {
            $pos = $this->collDraftProducts->search($draftProduct);
            $this->collDraftProducts->remove($pos);
            if (null === $this->draftProductsScheduledForDeletion) {
                $this->draftProductsScheduledForDeletion = clone $this->collDraftProducts;
                $this->draftProductsScheduledForDeletion->clear();
            }
            $this->draftProductsScheduledForDeletion[]= clone $draftProduct;
            $draftProduct->setCategory(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Category is new, it will return
     * an empty collection; or if this Category has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Category.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct}> List of DraftProduct objects
     */
    public function getDraftProductsJoinProduct(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Product', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Category is new, it will return
     * an empty collection; or if this Category has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Category.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct}> List of DraftProduct objects
     */
    public function getDraftProductsJoinBrand(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Brand', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Category is new, it will return
     * an empty collection; or if this Category has previously
     * been saved, it will retrieve related DraftProducts from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Category.
     *
     * @param Criteria $criteria optional Criteria object to narrow the query
     * @param ConnectionInterface $con optional connection object
     * @param string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|DraftProduct[] List of DraftProduct objects
     * @phpstan-return ObjectCollection&\Traversable<DraftProduct}> List of DraftProduct objects
     */
    public function getDraftProductsJoinCustomer(?Criteria $criteria = null, ?ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = DraftProductQuery::create(null, $criteria);
        $query->joinWith('Customer', $joinBehavior);

        return $this->getDraftProducts($query, $con);
    }

    /**
     * Clears out the collSizeGrids collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addSizeGrids()
     */
    public function clearSizeGrids()
    {
        $this->collSizeGrids = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Initializes the collSizeGrids crossRef collection.
     *
     * By default this just sets the collSizeGrids collection to an empty collection (like clearSizeGrids());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initSizeGrids()
    {
        $collectionClassName = SizeGridCategoryRelTableMap::getTableMap()->getCollectionClassName();

        $this->collSizeGrids = new $collectionClassName;
        $this->collSizeGridsPartial = true;
        $this->collSizeGrids->setModel('\Shop\Infrastructure\Models\SizeGrid\SizeGrid');
    }

    /**
     * Checks if the collSizeGrids collection is loaded.
     *
     * @return bool
     */
    public function isSizeGridsLoaded(): bool
    {
        return null !== $this->collSizeGrids;
    }

    /**
     * Gets a collection of SizeGrid objects related by a many-to-many relationship
     * to the current object by way of the shop_size_grid_category_rel cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildCategory is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param ConnectionInterface $con Optional connection object
     *
     * @return ObjectCollection|SizeGrid[] List of SizeGrid objects
     * @phpstan-return ObjectCollection&\Traversable<SizeGrid> List of SizeGrid objects
     */
    public function getSizeGrids(?Criteria $criteria = null, ?ConnectionInterface $con = null)
    {
        $partial = $this->collSizeGridsPartial && !$this->isNew();
        if (null === $this->collSizeGrids || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->collSizeGrids) {
                    $this->initSizeGrids();
                }
            } else {

                $query = SizeGridQuery::create(null, $criteria)
                    ->filterByCategory($this);
                $collSizeGrids = $query->find($con);
                if (null !== $criteria) {
                    return $collSizeGrids;
                }

                if ($partial && $this->collSizeGrids) {
                    //make sure that already added objects gets added to the list of the database.
                    foreach ($this->collSizeGrids as $obj) {
                        if (!$collSizeGrids->contains($obj)) {
                            $collSizeGrids[] = $obj;
                        }
                    }
                }

                $this->collSizeGrids = $collSizeGrids;
                $this->collSizeGridsPartial = false;
            }
        }

        return $this->collSizeGrids;
    }

    /**
     * Sets a collection of SizeGrid objects related by a many-to-many relationship
     * to the current object by way of the shop_size_grid_category_rel cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param Collection $sizeGrids A Propel collection.
     * @param ConnectionInterface $con Optional connection object
     * @return $this The current object (for fluent API support)
     */
    public function setSizeGrids(Collection $sizeGrids, ?ConnectionInterface $con = null)
    {
        $this->clearSizeGrids();
        $currentSizeGrids = $this->getSizeGrids();

        $sizeGridsScheduledForDeletion = $currentSizeGrids->diff($sizeGrids);

        foreach ($sizeGridsScheduledForDeletion as $toDelete) {
            $this->removeSizeGrid($toDelete);
        }

        foreach ($sizeGrids as $sizeGrid) {
            if (!$currentSizeGrids->contains($sizeGrid)) {
                $this->doAddSizeGrid($sizeGrid);
            }
        }

        $this->collSizeGridsPartial = false;
        $this->collSizeGrids = $sizeGrids;

        return $this;
    }

    /**
     * Gets the number of SizeGrid objects related by a many-to-many relationship
     * to the current object by way of the shop_size_grid_category_rel cross-reference table.
     *
     * @param Criteria $criteria Optional query object to filter the query
     * @param bool $distinct Set to true to force count distinct
     * @param ConnectionInterface $con Optional connection object
     *
     * @return int The number of related SizeGrid objects
     */
    public function countSizeGrids(?Criteria $criteria = null, $distinct = false, ?ConnectionInterface $con = null): int
    {
        $partial = $this->collSizeGridsPartial && !$this->isNew();
        if (null === $this->collSizeGrids || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collSizeGrids) {
                return 0;
            } else {

                if ($partial && !$criteria) {
                    return count($this->getSizeGrids());
                }

                $query = SizeGridQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByCategory($this)
                    ->count($con);
            }
        } else {
            return count($this->collSizeGrids);
        }
    }

    /**
     * Associate a SizeGrid to this object
     * through the shop_size_grid_category_rel cross reference table.
     *
     * @param SizeGrid $sizeGrid
     * @return ChildCategory The current object (for fluent API support)
     */
    public function addSizeGrid(SizeGrid $sizeGrid)
    {
        if ($this->collSizeGrids === null) {
            $this->initSizeGrids();
        }

        if (!$this->getSizeGrids()->contains($sizeGrid)) {
            // only add it if the **same** object is not already associated
            $this->collSizeGrids->push($sizeGrid);
            $this->doAddSizeGrid($sizeGrid);
        }

        return $this;
    }

    /**
     *
     * @param SizeGrid $sizeGrid
     */
    protected function doAddSizeGrid(SizeGrid $sizeGrid)
    {
        $sizeGridCategoryRel = new SizeGridCategoryRel();

        $sizeGridCategoryRel->setSizeGrid($sizeGrid);

        $sizeGridCategoryRel->setCategory($this);

        $this->addSizeGridCategoryRel($sizeGridCategoryRel);

        // set the back reference to this object directly as using provided method either results
        // in endless loop or in multiple relations
        if (!$sizeGrid->isCategoriesLoaded()) {
            $sizeGrid->initCategories();
            $sizeGrid->getCategories()->push($this);
        } elseif (!$sizeGrid->getCategories()->contains($this)) {
            $sizeGrid->getCategories()->push($this);
        }

    }

    /**
     * Remove sizeGrid of this object
     * through the shop_size_grid_category_rel cross reference table.
     *
     * @param SizeGrid $sizeGrid
     * @return ChildCategory The current object (for fluent API support)
     */
    public function removeSizeGrid(SizeGrid $sizeGrid)
    {
        if ($this->getSizeGrids()->contains($sizeGrid)) {
            $sizeGridCategoryRel = new SizeGridCategoryRel();
            $sizeGridCategoryRel->setSizeGrid($sizeGrid);
            if ($sizeGrid->isCategoriesLoaded()) {
                //remove the back reference if available
                $sizeGrid->getCategories()->removeObject($this);
            }

            $sizeGridCategoryRel->setCategory($this);
            $this->removeSizeGridCategoryRel(clone $sizeGridCategoryRel);
            $sizeGridCategoryRel->clear();

            $this->collSizeGrids->remove($this->collSizeGrids->search($sizeGrid));

            if (null === $this->sizeGridsScheduledForDeletion) {
                $this->sizeGridsScheduledForDeletion = clone $this->collSizeGrids;
                $this->sizeGridsScheduledForDeletion->clear();
            }

            $this->sizeGridsScheduledForDeletion->push($sizeGrid);
        }


        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     *
     * @return $this
     */
    public function clear()
    {
        if (null !== $this->aParentCategory) {
            $this->aParentCategory->removeCategoryRelatedById($this);
        }
        if (null !== $this->aCatalog) {
            $this->aCatalog->removeCategory($this);
        }
        $this->id = null;
        $this->title = null;
        $this->alias = null;
        $this->full_title = null;
        $this->image = null;
        $this->desc = null;
        $this->parent_id = null;
        $this->catalog_id = null;
        $this->active = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);

        return $this;
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param bool $deep Whether to also clear the references on all referrer objects.
     * @return $this
     */
    public function clearAllReferences(bool $deep = false)
    {
        if ($deep) {
            if ($this->collCategoriesRelatedById) {
                foreach ($this->collCategoriesRelatedById as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collProducts) {
                foreach ($this->collProducts as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collSizeGridCategoryRels) {
                foreach ($this->collSizeGridCategoryRels as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDiscountRules) {
                foreach ($this->collDiscountRules as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collImageDefaults) {
                foreach ($this->collImageDefaults as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collDraftProducts) {
                foreach ($this->collDraftProducts as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->collSizeGrids) {
                foreach ($this->collSizeGrids as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->collCategoriesRelatedById = null;
        $this->collProducts = null;
        $this->collSizeGridCategoryRels = null;
        $this->collDiscountRules = null;
        $this->collImageDefaults = null;
        $this->collDraftProducts = null;
        $this->collSizeGrids = null;
        $this->aParentCategory = null;
        $this->aCatalog = null;
        return $this;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(CategoryTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preSave(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postSave(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before inserting to database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preInsert(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postInsert(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before updating the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preUpdate(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postUpdate(?ConnectionInterface $con = null): void
    {
            }

    /**
     * Code to be run before deleting the object in database
     * @param ConnectionInterface|null $con
     * @return bool
     */
    public function preDelete(?ConnectionInterface $con = null): bool
    {
                return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface|null $con
     * @return void
     */
    public function postDelete(?ConnectionInterface $con = null): void
    {
            }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);
            $inputData = $params[0];
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->importFrom($format, $inputData, $keyType);
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = $params[0] ?? true;
            $keyType = $params[1] ?? TableMap::TYPE_PHPNAME;

            return $this->exportTo($format, $includeLazyLoadColumns, $keyType);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
