<?php

namespace Shop\Domain\OrderItem\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

/**
* Description of OrderItem
*
* @author Diamond Code Generator
*/
interface OrderItemCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{
    /**
     * @return string|null
     */
    public function getSortById():?string;

    /**
     * @return string|null
     */
    public function getFilterByOrderCode():?string ;

    /**
     * @return string|null
     */
    public function getFilterByStateId():?int ;

    /**
     * @return string|null
     */
    public function getFilterByProviderId():?int ;

    /**
     * @return string|null
     */
    public function getSearchByName():?string ;

    /**
     * @return string|null
     */
    public function getSearchByArticle():?string ;

    /**
     * @return string|null
     */
    public function getSearchByBrand():?string ;

    /**
     * @return array|null
     */
    public function getFilterByOrderIds():?array ;
}           