<?

namespace Shop\Presentation\Modules\AdminPaymasterTrans;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\Form\ControlBuilder;
use Core\Helpers\Date;
use Core\Registry\Column;
use Core\Registry\Field;
use DiamondTable\CommandFactory;
use DiamondTable\TableFactory;
use Shop\Presentation\Config\Main;
use Shop\Infrastructure\Models\PaymentTransaction\PaymentTransaction;
use Shop\Infrastructure\Repositories\PaymentTransaction\PaymentTransactionCriteria;
use Shop\Infrastructure\Repositories\PaymentTransaction\PaymentTransactionRepository;

/**
 * Description of AdminPaymasterTrans
 *
 * @author Diamond Code Generator
 */
class AdminPaymasterTrans extends \Core\ModuleController
{
    protected $repo;
    protected $tableFactory;
    protected $cBuilder;
    protected $mainConf;

    /**
     * AdminPaymasterTrans constructor.
     * @param TableFactory $tableFactory
     * @param ControlBuilder $cBuilder
     * @param PaymentTransactionRepository $repo
     * @param Main $mainConf
     */
    public function __construct(TableFactory $tableFactory,
                                ControlBuilder $cBuilder,
                                PaymentTransactionRepository $repo,
                                Main $mainConf)
    {
        $this->tableFactory = $tableFactory;
        $this->repo = $repo;
        $this->cBuilder = $cBuilder;
        $this->mainConf = $mainConf;
    }

    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->repo, PaymentTransactionCriteria::create());

        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ACCESS_ADD)
            ->removeControlAccess(DataTableEngine::CONTROL_ACCESS_EDIT)
            ->removeControlAccess(DataTableEngine::CONTROL_ACCESS_DELETE)
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->setDefaultSortColumn('id', 'DESC')
            ->addColumn(
                new ColumnTable('id', '№')
            )
            ->addColumn(
                (new ColumnTable('datetime', 'Дата создания'))->setFormat($this, 'formatDate')
            )
            ->addColumn(
                (new ColumnTable('orderId', 'Заказ'))->setFormat($this, 'formatCode')
            )
            ->addColumn(
                (new ColumnTable('orderSumm', 'Сумма заказа'))
            )
            ->addColumn(
                (new ColumnTable('payedSumm', 'Сумма оплаты'))
            )
            ->addColumn(
                (new ColumnTable('result', 'Результат'))
            )
            ->addColumn(
                (new ColumnTable('commission', 'Комиссия,%'))
            )
            ->addColumn(
                (new ColumnTable('currency', 'Валюта'))
            )
            ->addColumn(
                (new ColumnTable('desc', 'Комментарий'))
            )
            ->addColumn(
                (new ColumnTable('actions', 'Подтверждена'))->setFormat($this, 'formatConfirm')
            )
            ;

        $table->addFilter($this->cBuilder->buildInput('filter_by_orderId'));

        return $table->render();
    }

    /**
     * @param PaymentTransaction $paymentTransaction
     * @return string
     */
    public function formatActions(PaymentTransaction $paymentTransaction): string
    {
        return '';
    }

    /**
     * @param PaymentTransaction $paymentTransaction
     * @return string
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function formatDate(PaymentTransaction $paymentTransaction)
    {
        return $paymentTransaction->getDatetime()->format(Date::formatDisplay());
    }


    /**
     * @param PaymentTransaction $trans
     * @return string
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function formatCode(PaymentTransaction $trans): string
    {
        return \Shop\Presentation\Helpers\Formatter::linkOrderCode($trans->getOrder());
    }

    /**
     * @param PaymentTransaction $trans
     * @return string
     */
    public function formatConfirm(PaymentTransaction $trans): string
    {
        return \Diamond\Helpers\Formatter::formatYN($trans->getConfirmed());
    }
}