<?php declare(strict_types=1);

namespace Shop\Presentation\Modules\AllClientsWidget;

use Core\Helpers\Text;
use Core\ModuleController;
use Shop\Application\Office\OfficeService;
use Shop\Presentation\Config\Main;
use Shop\Infrastructure\Models\Customer\Customer;
use Shop\Infrastructure\Repositories\Customer\CustomerCriteria;

/**
* Description of AllClientsWidget
*
* @author Diamond Code Generator
*/
class AllClientsWidget extends ModuleController
{

    public function __construct(protected OfficeService $officeService, protected Main $mainConf)
    {
    }

    public function process(): string
    {
        $clientsCount = $this->officeService->getCustomersCount();

        $all = $this->officeService->getCustomerRepository()->findByCriteria(
            CustomerCriteria::create()->setFilterByCreateMonthDate((new \DateTime())->format('Y-m'))
        );
        $count = 0;
        /** @var Customer $client */
        foreach($all as $client){
            if($client->getRegistred()->format('d') === (new \DateTime())->format('d')){
                $count ++;
            }
        }
        if ($this->mainConf->getWishfulCountClientMonth()) {
            $clientsProfit = round(($all->count()/ $this->mainConf->getWishfulCountClientMonth()) * 100);
        } else {
            $clientsProfit = 0;
        }
        return $this->render([
            'clients_count' => $clientsCount,
            'clients_new' => $all->count(),
            'clients_proc' => $clientsProfit,
            'clients_new_today_text' => 'пользовател'. Text::morph($count,'ь','я','ей'),
            'clients_new_today' => $count
        ]);
    }
}               